/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.ThreeCore;

@Mod.EventBusSubscriber(modid="threecore", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class PerspectiveAwareBakedModel
implements IBakedModel {
    private static final Map<Supplier<ResourceLocation>, List<Pair<ItemCameraTransforms.TransformType, ResourceLocation>>> LOAD = Maps.newHashMap();
    private final IBakedModel base;
    public final List<Pair<ItemCameraTransforms.TransformType, ? extends IBakedModel>> variants = Lists.newArrayList();

    public PerspectiveAwareBakedModel(IBakedModel base) {
        this.base = base;
    }

    public static void register(ResourceLocation toReplace, Pair<ItemCameraTransforms.TransformType, ResourceLocation> ... replacing) {
        LOAD.put(() -> toReplace, Arrays.asList(replacing));
    }

    public static void register(Item toReplace, Pair<ItemCameraTransforms.TransformType, ResourceLocation> ... replacing) {
        PerspectiveAwareBakedModel.register((ResourceLocation)new ModelResourceLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)toReplace)), "inventory"), replacing);
    }

    public static void register(Supplier<Item> toReplace, Pair<ItemCameraTransforms.TransformType, ResourceLocation> ... replacing) {
        LOAD.put(() -> new ModelResourceLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)toReplace.get())), "inventory"), Arrays.asList(replacing));
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent e) {
        LOAD.forEach((rl, pairs) -> pairs.forEach(pair -> ModelLoader.addSpecialModel((ResourceLocation)((ResourceLocation)pair.getSecond()))));
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        LOAD.forEach((rl, pairs) -> {
            IBakedModel base = (IBakedModel)e.getModelRegistry().get(rl.get());
            if (base != null) {
                PerspectiveAwareBakedModel model = new PerspectiveAwareBakedModel(base);
                pairs.forEach(arg_0 -> PerspectiveAwareBakedModel.lambda$null$4(e, (Supplier)rl, model, arg_0));
                e.getModelRegistry().put(rl.get(), model);
            }
        });
    }

    public PerspectiveAwareBakedModel addVariant(ItemCameraTransforms.TransformType transformType, IBakedModel override) {
        this.variants.add((Pair<ItemCameraTransforms.TransformType, ? extends IBakedModel>)Pair.of((Object)transformType, (Object)override));
        return this;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.base.func_200117_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.base.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.base.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.base.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.base.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.base.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.base.func_188617_f();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        for (Pair<ItemCameraTransforms.TransformType, ? extends IBakedModel> pair : this.variants) {
            if (pair.getFirst() != cameraTransformType) continue;
            return ((IBakedModel)pair.getSecond()).handlePerspective(cameraTransformType, mat);
        }
        return this.base.handlePerspective(cameraTransformType, mat);
    }

    private static /* synthetic */ void lambda$null$4(ModelBakeEvent e, Supplier rl, PerspectiveAwareBakedModel model, Pair pair) {
        IBakedModel overridingModel = (IBakedModel)e.getModelRegistry().get(pair.getSecond());
        if (overridingModel == null) {
            ThreeCore.LOGGER.error("Perspective aware model could not find " + pair.getSecond() + " for " + rl + "!");
        } else {
            model.addVariant((ItemCameraTransforms.TransformType)pair.getFirst(), overridingModel);
        }
    }
}

