/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.container;

import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.block.ConstructionTableBlock;
import net.threetag.threecore.client.gui.inventory.CapacitorBlockScreen;
import net.threetag.threecore.client.gui.inventory.ConstructionTableScreen;
import net.threetag.threecore.client.gui.inventory.FluidComposerScreen;
import net.threetag.threecore.client.gui.inventory.GrinderScreen;
import net.threetag.threecore.client.gui.inventory.HydraulicPressScreen;
import net.threetag.threecore.client.gui.inventory.StirlingGeneratorScreen;
import net.threetag.threecore.container.BootsCraftingContainer;
import net.threetag.threecore.container.CapacitorBlockContainer;
import net.threetag.threecore.container.ChestplateCraftingContainer;
import net.threetag.threecore.container.FluidComposerContainer;
import net.threetag.threecore.container.GrinderContainer;
import net.threetag.threecore.container.HelmetCraftingContainer;
import net.threetag.threecore.container.HydraulicPressContainer;
import net.threetag.threecore.container.LeggingsCraftingContainer;
import net.threetag.threecore.container.StirlingGeneratorContainer;
import net.threetag.threecore.tileentity.FluidComposerTileEntity;
import net.threetag.threecore.tileentity.StirlingGeneratorTileEntity;
import net.threetag.threecore.util.icon.ItemIcon;

public class TCContainerTypes {
    public static final DeferredRegister<ContainerType<?>> CONTAINER_TYPES = new DeferredRegister(ForgeRegistries.CONTAINERS, "threecore");
    public static final RegistryObject<ContainerType<HelmetCraftingContainer>> HELMET_CRAFTING = CONTAINER_TYPES.register("helmet_crafting", () -> new ContainerType(HelmetCraftingContainer::new));
    public static final RegistryObject<ContainerType<ChestplateCraftingContainer>> CHESTPLATE_CRAFTING = CONTAINER_TYPES.register("chestplate_crafting", () -> new ContainerType(ChestplateCraftingContainer::new));
    public static final RegistryObject<ContainerType<LeggingsCraftingContainer>> LEGGINGS_CRAFTING = CONTAINER_TYPES.register("leggings_crafting", () -> new ContainerType(LeggingsCraftingContainer::new));
    public static final RegistryObject<ContainerType<BootsCraftingContainer>> BOOTS_CRAFTING = CONTAINER_TYPES.register("boots_crafting", () -> new ContainerType(BootsCraftingContainer::new));
    public static final RegistryObject<ContainerType<GrinderContainer>> GRINDER = CONTAINER_TYPES.register("grinder", () -> new ContainerType(GrinderContainer::new));
    public static final RegistryObject<ContainerType<HydraulicPressContainer>> HYDRAULIC_PRESS = CONTAINER_TYPES.register("hydraulic_press", () -> new ContainerType(HydraulicPressContainer::new));
    public static final RegistryObject<ContainerType<FluidComposerContainer>> FLUID_COMPOSER = CONTAINER_TYPES.register("fluid_composer", () -> new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
        TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return tileEntity instanceof FluidComposerTileEntity ? new FluidComposerContainer(windowId, inv, (FluidComposerTileEntity)tileEntity) : null;
    })));
    public static final RegistryObject<ContainerType<CapacitorBlockContainer>> CAPACITOR_BLOCK = CONTAINER_TYPES.register("capacitor_block", () -> new ContainerType(CapacitorBlockContainer::new));
    public static final RegistryObject<ContainerType<StirlingGeneratorContainer>> STIRLING_GENERATOR = CONTAINER_TYPES.register("stirling_generator", () -> new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
        TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return tileEntity instanceof StirlingGeneratorTileEntity ? new StirlingGeneratorContainer(windowId, inv, (StirlingGeneratorTileEntity)tileEntity) : null;
    })));

    public static void registerConstructionTableTabls() {
        ConstructionTableBlock.registerTab(new ResourceLocation("threecore", "helmet_crafting"), new ConstructionTableBlock.Tab(() -> HELMET_CRAFTING.get(), (id, playerInventory, player, world, pos) -> new HelmetCraftingContainer(id, playerInventory, IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos)), new ItemIcon((IItemProvider)Items.field_151028_Y)));
        ConstructionTableBlock.registerTab(new ResourceLocation("threecore", "chestplate_crafting"), new ConstructionTableBlock.Tab(() -> CHESTPLATE_CRAFTING.get(), (id, playerInventory, player, world, pos) -> new ChestplateCraftingContainer(id, playerInventory, IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos)), new ItemIcon((IItemProvider)Items.field_151030_Z)));
        ConstructionTableBlock.registerTab(new ResourceLocation("threecore", "leggings_crafting"), new ConstructionTableBlock.Tab(() -> LEGGINGS_CRAFTING.get(), (id, playerInventory, player, world, pos) -> new LeggingsCraftingContainer(id, playerInventory, IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos)), new ItemIcon((IItemProvider)Items.field_151165_aa)));
        ConstructionTableBlock.registerTab(new ResourceLocation("threecore", "boots_crafting"), new ConstructionTableBlock.Tab(() -> BOOTS_CRAFTING.get(), (id, playerInventory, player, world, pos) -> new BootsCraftingContainer(id, playerInventory, IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos)), new ItemIcon((IItemProvider)Items.field_151167_ab)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initContainerScreens() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)HELMET_CRAFTING.get()), ConstructionTableScreen.Helmet::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)CHESTPLATE_CRAFTING.get()), ConstructionTableScreen.Chestplate::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)LEGGINGS_CRAFTING.get()), ConstructionTableScreen.Leggings::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)BOOTS_CRAFTING.get()), ConstructionTableScreen.Boots::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)GRINDER.get()), GrinderScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)HYDRAULIC_PRESS.get()), HydraulicPressScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)FLUID_COMPOSER.get()), FluidComposerScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)STIRLING_GENERATOR.get()), StirlingGeneratorScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)CAPACITOR_BLOCK.get()), CapacitorBlockScreen::new);
    }
}

