/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.threetag.threecore.data.ExtRecipeOutput;
import net.threetag.threecore.item.recipe.TCRecipeSerializers;

public class GrinderRecipeBuilder {
    private String group;
    private Ingredient input;
    private final ExtRecipeOutput output;
    private ExtRecipeOutput byproduct;
    private float byproductChance = 1.0f;
    private float experience = 0.0f;
    private int energy = 0;
    private List<ICondition> conditions = new ArrayList<ICondition>();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();

    public GrinderRecipeBuilder(ItemStack output) {
        this.output = new ExtRecipeOutput(output);
    }

    public GrinderRecipeBuilder(IItemProvider itemProvider) {
        this(itemProvider, 1);
    }

    public GrinderRecipeBuilder(IItemProvider itemProvider, int amount) {
        this(new ItemStack(itemProvider, amount));
    }

    public GrinderRecipeBuilder(Tag<Item> tag) {
        this(tag, 1);
    }

    public GrinderRecipeBuilder(Tag<Item> tag, int amount) {
        this.output = new ExtRecipeOutput(tag, amount);
    }

    public GrinderRecipeBuilder setByproduct(ItemStack stack) {
        this.byproduct = new ExtRecipeOutput(stack);
        return this;
    }

    public GrinderRecipeBuilder setByproduct(IItemProvider itemProvider, int amount) {
        return this.setByproduct(new ItemStack(itemProvider, amount));
    }

    public GrinderRecipeBuilder setByproduct(IItemProvider itemProvider) {
        return this.setByproduct(itemProvider, 1);
    }

    public GrinderRecipeBuilder setByproduct(Tag<Item> tag, int amount) {
        this.byproduct = new ExtRecipeOutput(tag, amount);
        return this;
    }

    public GrinderRecipeBuilder setByproduct(Tag<Item> tag) {
        return this.setByproduct(tag, 1);
    }

    public GrinderRecipeBuilder setByproductChance(float chance) {
        this.byproductChance = MathHelper.func_76131_a((float)chance, (float)0.0f, (float)1.0f);
        return this;
    }

    public GrinderRecipeBuilder setIngredient(Ingredient ingredient) {
        this.input = ingredient;
        return this;
    }

    public GrinderRecipeBuilder setIngredient(IItemProvider ... itemProviders) {
        this.input = Ingredient.func_199804_a((IItemProvider[])itemProviders);
        return this;
    }

    public GrinderRecipeBuilder setIngredient(ItemStack ... stacks) {
        this.input = Ingredient.func_193369_a((ItemStack[])stacks);
        return this;
    }

    public GrinderRecipeBuilder setIngredient(Tag<Item> tag) {
        this.input = Ingredient.func_199805_a(tag);
        return this;
    }

    public GrinderRecipeBuilder setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public GrinderRecipeBuilder setExperience(float experience) {
        this.experience = experience;
        return this;
    }

    public GrinderRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public GrinderRecipeBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public GrinderRecipeBuilder addCriterion(String key, ICriterionInstance criterionInstance) {
        this.advancementBuilder.func_200275_a(key, criterionInstance);
        return this;
    }

    private void validate(ResourceLocation resourceLocation) {
        if (this.input == null) {
            throw new IllegalStateException("No input specified for recipe " + resourceLocation);
        }
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
        if (this.energy <= 0) {
            throw new IllegalStateException("Energy for " + resourceLocation + " must be greater than 0!");
        }
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.output.getId());
    }

    public void build(Consumer<IFinishedRecipe> consumer, String name) {
        ResourceLocation resourceLocation = this.output.getId();
        if (new ResourceLocation(name).equals((Object)resourceLocation)) {
            throw new IllegalStateException("Grinding Recipe " + name + " should remove its 'save' argument");
        }
        this.build(consumer, new ResourceLocation(name));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation name) {
        this.validate(name);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(name)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)name)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(name, this.group == null ? "" : this.group, this.input, this.output, this.byproduct, this.byproductChance, this.experience, this.energy, this.conditions, this.advancementBuilder, new ResourceLocation(name.func_110624_b(), "recipes/" + this.output.getGroup() + "/" + name.func_110623_a())));
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient input;
        private final ExtRecipeOutput output;
        private final ExtRecipeOutput byproduct;
        private final float byproductChance;
        private final float experience;
        private final int energy;
        private final List<ICondition> conditions;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, Ingredient input, ExtRecipeOutput output, ExtRecipeOutput byproduct, float byproductChance, float experience, int energy, List<ICondition> conditions, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.input = input;
            this.output = output;
            this.byproduct = byproduct;
            this.byproductChance = byproductChance;
            this.experience = experience;
            this.energy = energy;
            this.conditions = conditions;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            if (this.conditions != null && !this.conditions.isEmpty()) {
                JsonArray conds = new JsonArray();
                for (ICondition c : this.conditions) {
                    conds.add((JsonElement)CraftingHelper.serialize((ICondition)c));
                }
                jsonObject.add("conditions", (JsonElement)conds);
            }
            jsonObject.add("result", (JsonElement)this.output.serialize());
            if (this.byproduct != null) {
                JsonObject byproductJson = this.byproduct.serialize();
                byproductJson.addProperty("chance", (Number)Float.valueOf(this.byproductChance));
            }
            jsonObject.add("ingredient", this.input.func_200304_c());
            jsonObject.addProperty("experience", (Number)Float.valueOf(this.experience));
            jsonObject.addProperty("energy", (Number)this.energy);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TCRecipeSerializers.GRINDING.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

