/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.entity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.NetworkHooks;
import net.threetag.threecore.entity.TCEntityTypes;
import net.threetag.threecore.item.TCItems;

public class SuitStandEntity
extends ArmorStandEntity {
    private static final Rotations DEFAULT_LEFTARM_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_RIGHTARM_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFTLEG_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_RIGHTLEG_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(SuitStandEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public SuitStandEntity(World world) {
        this((EntityType<? extends SuitStandEntity>)((EntityType)TCEntityTypes.SUIT_STAND.get()), world);
    }

    public SuitStandEntity(EntityType<? extends SuitStandEntity> entityType, World world) {
        super(entityType, world);
        this.func_175405_c(DEFAULT_LEFTARM_ROTATION);
        this.func_175428_d(DEFAULT_RIGHTARM_ROTATION);
        this.func_175417_e(DEFAULT_LEFTLEG_ROTATION);
        this.func_175427_f(DEFAULT_RIGHTLEG_ROTATION);
    }

    public SuitStandEntity(World worldIn, double posX, double posY, double posZ) {
        this((EntityType<? extends SuitStandEntity>)((EntityType)TCEntityTypes.SUIT_STAND.get()), worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setDyeColor(DyeColor.func_196056_a((int)nbt.func_74771_c("Color")));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("Color", (byte)this.getDyeColor().func_196059_a());
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec3d, Hand hand) {
        ItemStack stack;
        if (!player.func_213453_ef() && (stack = player.func_184586_b(hand)).func_77973_b().func_206844_a(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color != null) {
                this.setDyeColor(color);
                stack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        return super.func_184199_a(player, vec3d, hand);
    }

    public void func_175416_h(CompoundNBT tagCompound) {
        ListNBT listnbt = tagCompound.func_150295_c("Head", 5);
        this.func_175415_a(listnbt.isEmpty() ? ArmorStandEntity.field_175435_a : new Rotations(listnbt));
        ListNBT listnbt1 = tagCompound.func_150295_c("Body", 5);
        this.func_175424_b(listnbt1.isEmpty() ? ArmorStandEntity.field_175433_b : new Rotations(listnbt1));
        ListNBT listnbt2 = tagCompound.func_150295_c("LeftArm", 5);
        this.func_175405_c(listnbt2.isEmpty() ? DEFAULT_LEFTARM_ROTATION : new Rotations(listnbt2));
        ListNBT listnbt3 = tagCompound.func_150295_c("RightArm", 5);
        this.func_175428_d(listnbt3.isEmpty() ? DEFAULT_RIGHTARM_ROTATION : new Rotations(listnbt3));
        ListNBT listnbt4 = tagCompound.func_150295_c("LeftLeg", 5);
        this.func_175417_e(listnbt4.isEmpty() ? DEFAULT_LEFTLEG_ROTATION : new Rotations(listnbt4));
        ListNBT listnbt5 = tagCompound.func_150295_c("RightLeg", 5);
        this.func_175427_f(listnbt5.isEmpty() ? DEFAULT_RIGHTLEG_ROTATION : new Rotations(listnbt5));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TCItems.SUIT_STAND.get());
    }

    public void func_213815_f(DamageSource p_213815_1_) {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos((Entity)this), (ItemStack)new ItemStack((IItemProvider)TCItems.SUIT_STAND.get()));
        this.func_213816_g(p_213815_1_);
    }

    public void func_175412_z() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150371_ca.func_176223_P()), this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 1.5, this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public DyeColor getDyeColor() {
        return DyeColor.func_196056_a((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setDyeColor(DyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_196059_a() & 0xF)));
    }
}

