/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.entity.attributes;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.SimpleRegistry;
import net.threetag.threecore.entity.attributes.TCAttributes;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.icon.ItemIcon;
import net.threetag.threecore.util.icon.TexturedIcon;

public class AttributeRegistry {
    public static final SimpleRegistry<AttributeEntry> REGISTRY = new SimpleRegistry();

    public static AttributeEntry getEntry(IAttribute attribute) {
        for (AttributeEntry entry : REGISTRY) {
            if (entry.getAttribute() != attribute) continue;
            return entry;
        }
        return null;
    }

    static {
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "max_health"), (Object)new AttributeEntry(SharedMonsterAttributes.field_111267_a, () -> new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 176, 0, 16, 16)));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "follow_range"), (Object)new AttributeEntry(SharedMonsterAttributes.field_111265_b));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "knockback_resistance"), (Object)new AttributeEntry(SharedMonsterAttributes.field_111266_c, () -> new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 208, 0, 16, 16)));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "movement_speed"), (Object)new AttributeEntry(SharedMonsterAttributes.field_111263_d, () -> new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 48, 0, 16, 16)));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "flying_speed"), (Object)new AttributeEntry(SharedMonsterAttributes.field_193334_e));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "attack_damage"), (Object)new AttributeEntry(SharedMonsterAttributes.field_111264_e, () -> new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 32, 0, 16, 16)));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "attack_speed"), (Object)new AttributeEntry(SharedMonsterAttributes.field_188790_f));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "armor"), (Object)new AttributeEntry(SharedMonsterAttributes.field_188791_g, () -> new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 80, 0, 16, 16)));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "armor_toughness"), (Object)new AttributeEntry(SharedMonsterAttributes.field_189429_h));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "luck"), (Object)new AttributeEntry(SharedMonsterAttributes.field_188792_h, () -> new ItemIcon((IItemProvider)Items.field_179556_br)));
        REGISTRY.func_218381_a(new ResourceLocation("minecraft", "reach_distance"), (Object)new AttributeEntry(PlayerEntity.REACH_DISTANCE));
        REGISTRY.func_218381_a(new ResourceLocation("forge", "nametag_distance"), (Object)new AttributeEntry(LivingEntity.NAMETAG_DISTANCE));
        REGISTRY.func_218381_a(new ResourceLocation("forge", "swim_speed"), (Object)new AttributeEntry(LivingEntity.SWIM_SPEED));
        REGISTRY.func_218381_a(new ResourceLocation("forge", "gravity"), (Object)new AttributeEntry(LivingEntity.ENTITY_GRAVITY));
        REGISTRY.func_218381_a(new ResourceLocation("threecore", "size_width"), (Object)new AttributeEntry(TCAttributes.SIZE_WIDTH));
        REGISTRY.func_218381_a(new ResourceLocation("threecore", "size_height"), (Object)new AttributeEntry(TCAttributes.SIZE_HEIGHT));
        REGISTRY.func_218381_a(new ResourceLocation("threecore", "step_height"), (Object)new AttributeEntry(TCAttributes.STEP_HEIGHT));
        REGISTRY.func_218381_a(new ResourceLocation("threecore", "fall_resistance"), (Object)new AttributeEntry(TCAttributes.FALL_RESISTANCE));
        REGISTRY.func_218381_a(new ResourceLocation("threecore", "jump_height"), (Object)new AttributeEntry(TCAttributes.JUMP_HEIGHT));
        REGISTRY.func_218381_a(new ResourceLocation("threecore", "sprint_speed"), (Object)new AttributeEntry(TCAttributes.SPRINT_SPEED));
    }

    public static class AttributeEntry {
        protected IAttribute attribute;
        @Nullable
        protected Supplier<IIcon> iconSupplier;

        public AttributeEntry(IAttribute attribute) {
            this.attribute = attribute;
        }

        public AttributeEntry(IAttribute attribute, @Nullable Supplier<IIcon> iconSupplier) {
            this.attribute = attribute;
            this.iconSupplier = iconSupplier;
        }

        public IAttribute getAttribute() {
            return this.attribute;
        }

        public IIcon makeIcon() {
            return this.iconSupplier != null ? this.iconSupplier.get() : null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AttributeEntry)) {
                return false;
            }
            return this.attribute.equals(obj);
        }
    }
}

