/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.entity.attributes;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.capability.ISizeChanging;

@Mod.EventBusSubscriber(modid="threecore")
public class TCAttributes {
    public static final IAttribute STEP_HEIGHT = new RangedAttribute(null, "threecore.stepHeight", 0.5, 0.0, 20.0).func_111117_a("Step Height").func_111112_a(true);
    public static final IAttribute FALL_RESISTANCE = new RangedAttribute(null, "threecore.fallResistance", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Fall Resistance");
    public static final IAttribute JUMP_HEIGHT = new RangedAttribute(null, "threecore.jumpHeight", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Jump Height").func_111112_a(true);
    public static final IAttribute SPRINT_SPEED = new RangedAttribute(null, "threecore.sprintSpeed", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Sprint Speed").func_111112_a(true);
    public static final IAttribute SIZE_WIDTH = new RangedAttribute(null, "threecore.sizeWidth", 1.0, 0.1, 32.0).func_111112_a(true);
    public static final IAttribute SIZE_HEIGHT = new RangedAttribute(null, "threecore.sizeHeight", 1.0, 0.1, 32.0).func_111112_a(true);
    public static float stepHeight;
    public static final UUID SPRINT_UUID;

    @SubscribeEvent
    public static void onEntityConstruct(EntityEvent.EntityConstructing e) {
        if (e.getEntity() instanceof LivingEntity) {
            ((LivingEntity)e.getEntity()).func_110140_aT().func_111150_b(STEP_HEIGHT).func_111128_a(1.0);
            ((LivingEntity)e.getEntity()).func_110140_aT().func_111150_b(FALL_RESISTANCE);
            ((LivingEntity)e.getEntity()).func_110140_aT().func_111150_b(JUMP_HEIGHT);
            ((LivingEntity)e.getEntity()).func_110140_aT().func_111150_b(SPRINT_SPEED).func_111128_a(1.0);
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent e) {
        IAttributeInstance attributeInstance = e.getEntityLiving().func_110148_a(FALL_RESISTANCE);
        attributeInstance.func_111128_a((double)e.getDamageMultiplier());
        e.setDamageMultiplier((float)attributeInstance.func_111126_e());
    }

    @SubscribeEvent
    public static void onFall(LivingEvent.LivingJumpEvent e) {
        if (!e.getEntityLiving().func_213453_ef()) {
            e.getEntityLiving().func_213293_j(e.getEntity().func_213322_ci().field_72450_a, e.getEntity().func_213322_ci().field_72448_b + (double)0.1f * e.getEntityLiving().func_110148_a(JUMP_HEIGHT).func_111126_e(), e.getEntity().func_213322_ci().field_72449_c);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (e.player.field_70173_aa > 20 && e.player.field_70170_p.field_72995_K) {
                e.player.field_70138_W = stepHeight;
            }
            return;
        }
        if (e.player.field_70173_aa > 20 && e.player.field_70170_p.field_72995_K) {
            stepHeight = e.player.field_70138_W;
            IAttributeInstance attributeInstance = e.player.func_110148_a(STEP_HEIGHT);
            attributeInstance.func_111128_a((double)stepHeight);
            e.player.field_70138_W = (float)attributeInstance.func_111126_e();
            ISizeChanging sizeChanging = (ISizeChanging)e.player.getCapability(CapabilitySizeChanging.SIZE_CHANGING).orElseGet(() -> null);
            if (sizeChanging != null) {
                e.player.field_70138_W *= sizeChanging.getHeight();
            }
        }
        e.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(SPRINT_UUID);
        if (e.player.func_70051_ag() && e.player.func_110148_a(SPRINT_SPEED).func_225505_c_().size() > 0) {
            double amount = e.player.func_110148_a(SPRINT_SPEED).func_111126_e();
            e.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(SPRINT_UUID, "Sprint modifier", amount, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    static {
        SPRINT_UUID = UUID.fromString("11faf62f-c271-4601-809e-83d982687b69");
    }
}

