/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.fluid;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.util.TCFluidUtil;

public class FluidIngredient
implements Predicate<FluidStack> {
    private final FluidStack[] matching;
    private final Tag<Fluid> tag;

    public FluidIngredient(Tag<Fluid> tag, int amount) {
        this.tag = tag;
        Iterator iterator = tag.func_199885_a().iterator();
        this.matching = new FluidStack[tag.func_199885_a().size()];
        int i = 0;
        while (iterator.hasNext()) {
            this.matching[i] = new FluidStack((Fluid)iterator.next(), amount);
            ++i;
        }
    }

    public FluidIngredient(FluidStack ... matching) {
        this.matching = matching;
        this.tag = null;
    }

    public FluidStack[] getFluids() {
        return this.matching;
    }

    public Tag<Fluid> getTag() {
        return this.tag;
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        for (FluidStack stack : this.matching) {
            if (!fluidStack.containsFluid(stack)) continue;
            return true;
        }
        return false;
    }

    public static FluidIngredient read(PacketBuffer buffer) {
        int size = buffer.readInt();
        FluidStack[] fluids = new FluidStack[size];
        for (int i = 0; i < size; ++i) {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.func_192575_l());
            int amount = buffer.readInt();
            if (fluid == null) continue;
            fluids[i] = new FluidStack(fluid, amount);
        }
        return new FluidIngredient(fluids);
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.matching.length);
        for (int i = 0; i < this.matching.length; ++i) {
            buffer.func_192572_a(ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.matching[i].getFluid()));
            buffer.writeInt(this.matching[i].getAmount());
        }
    }

    public static FluidIngredient deserialize(JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"fluid") && JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"tag")) {
                    throw new JsonParseException("An ingredient entry is either a tag or a fluid, not both");
                }
                if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"fluid")) {
                    return new FluidIngredient(TCFluidUtil.deserializeFluidStack(jsonObject));
                }
                if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"tag")) {
                    ResourceLocation tag = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
                    Tag fluidTag = FluidTags.func_226157_a_().func_199910_a(tag);
                    if (fluidTag == null) {
                        throw new JsonSyntaxException("Unknown fluid tag '" + tag + "'");
                    }
                    return new FluidIngredient((Tag<Fluid>)fluidTag, JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount"));
                }
                throw new JsonParseException("An ingredient entry needs either a tag or a fluid");
            }
            if (json.isJsonArray()) {
                JsonArray jsonArray = json.getAsJsonArray();
                if (jsonArray.size() == 0) {
                    throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
                }
                FluidStack[] fluidStacks = new FluidStack[jsonArray.size()];
                for (int i = 0; i < jsonArray.size(); ++i) {
                    fluidStacks[0] = TCFluidUtil.deserializeFluidStack(jsonArray.get(i).getAsJsonObject());
                }
                return new FluidIngredient(fluidStacks);
            }
            throw new JsonSyntaxException("Expected fluid to be object or array of objects");
        }
        throw new JsonSyntaxException("Fluid cannot be null");
    }
}

