/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.fluid;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerFluidHandler
implements IFluidHandler {
    private final IItemHandler itemHandler;

    public ItemHandlerFluidHandler(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    public List<IFluidHandlerItem> getFluidHandlers() {
        ArrayList fluidHandlerItems = Lists.newArrayList();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandlerItems::add);
        }
        return fluidHandlerItems;
    }

    protected void validateTankIndex(int tank, List<IFluidHandlerItem> fluidHandlers) {
        if (tank < 0 || tank >= fluidHandlers.size()) {
            throw new RuntimeException("Tank " + tank + " not in valid range - [0," + fluidHandlers.size() + ")");
        }
    }

    public int getTanks() {
        return this.getFluidHandlers().size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        List<IFluidHandlerItem> fluidHandlerItems = this.getFluidHandlers();
        this.validateTankIndex(tank, fluidHandlerItems);
        return fluidHandlerItems.get(tank).getFluidInTank(0);
    }

    public int getTankCapacity(int tank) {
        List<IFluidHandlerItem> fluidHandlerItems = this.getFluidHandlers();
        this.validateTankIndex(tank, fluidHandlerItems);
        return fluidHandlerItems.get(tank).getTankCapacity(0);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        List<IFluidHandlerItem> fluidHandlerItems = this.getFluidHandlers();
        this.validateTankIndex(tank, fluidHandlerItems);
        return fluidHandlerItems.get(tank).isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        List<IFluidHandlerItem> fluidHandlerItems = this.getFluidHandlers();
        FluidStack fs = resource.copy();
        for (IFluidHandlerItem fluidHandler : fluidHandlerItems) {
            if (fs.getAmount() <= 0) continue;
            fs.setAmount(fs.getAmount() - fluidHandler.fill(fs, action));
        }
        return resource.getAmount() - fs.getAmount();
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        List<IFluidHandlerItem> fluidHandlerItems = this.getFluidHandlers();
        FluidStack fs = resource.copy();
        for (IFluidHandlerItem fluidHandler : fluidHandlerItems) {
            if (fs.getAmount() <= 0 || !fluidHandler.getFluidInTank(0).getFluid().func_207187_a(resource.getFluid())) continue;
            fs.setAmount(fs.getAmount() - fluidHandler.drain(fs, action).getAmount());
        }
        FluidStack result = resource.copy();
        result.setAmount(resource.getAmount() - fs.getAmount());
        return result;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (IFluidHandlerItem item : this.getFluidHandlers()) {
            FluidStack drain = item.drain(maxDrain, action);
            if (drain.isEmpty()) continue;
            return drain;
        }
        return FluidStack.EMPTY;
    }
}

