/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import net.threetag.threecore.ability.AbilityGenerator;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.IAbilityProvider;
import net.threetag.threecore.addonpacks.item.ItemParser;
import net.threetag.threecore.capability.ItemAbilityContainerProvider;
import net.threetag.threecore.client.renderer.entity.model.DummyBipedModel;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerProvider;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerLoader;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerManager;
import net.threetag.threecore.item.ArmorMaterialRegistry;

public class AbilityArmorItem
extends ArmorItem
implements IAbilityProvider,
IModelLayerProvider {
    private List<AbilityGenerator> abilityGenerators;
    private List<ITextComponent> description;
    public List layers = new LinkedList();

    public AbilityArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public AbilityArmorItem setAbilities(List<AbilityGenerator> abilities) {
        this.abilityGenerators = abilities;
        return this;
    }

    public AbilityArmorItem addAbility(AbilityGenerator abilityGenerator) {
        if (this.abilityGenerators == null) {
            this.abilityGenerators = Lists.newArrayList();
        }
        this.abilityGenerators.add(abilityGenerator);
        return this;
    }

    public AbilityArmorItem setDescription(List<ITextComponent> description) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.description = description;
        });
        return this;
    }

    public AbilityArmorItem addDescriptionLine(ITextComponent line) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.description == null) {
                this.description = Lists.newArrayList();
            }
            this.description.add(line);
        });
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.description != null) {
            tooltip.addAll(this.description);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)((Object)DummyBipedModel.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return PlayerContainer.field_226615_c_.toString();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ItemAbilityContainerProvider(stack);
    }

    @Override
    public AbilityMap getAbilities() {
        return new AbilityMap(this.abilityGenerators);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IModelLayer> getModelLayers(IModelLayerContext context) {
        return this.layers;
    }

    public static AbilityArmorItem parse(JsonObject jsonObject, Item.Properties properties) {
        IArmorMaterial material;
        EquipmentSlotType slot = EquipmentSlotType.func_188451_a((String)JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"slot"));
        if (slot.func_188453_a() == EquipmentSlotType.Group.HAND) {
            throw new JsonParseException("Slot type must be an armor slot!");
        }
        JsonElement materialJson = jsonObject.get("armor_material");
        IArmorMaterial iArmorMaterial = material = materialJson.isJsonPrimitive() ? ArmorMaterialRegistry.getArmorMaterial(materialJson.getAsString()) : ItemParser.parseArmorMaterial(materialJson.getAsJsonObject(), false);
        if (material == null) {
            throw new JsonParseException("The armor material '" + materialJson.getAsString() + "' can not be found!");
        }
        AbilityArmorItem item = new AbilityArmorItem(material, slot, properties);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ModelLayerLoader.POST_LOAD_CALLBACKS.add(() -> {
            if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"layers")) {
                if (jsonObject.get("layers").isJsonPrimitive() || jsonObject.get("layers").isJsonObject()) {
                    IModelLayer layer = ModelLayerManager.parseLayer(jsonObject.get("layers"));
                    if (layer != null) {
                        item.layers.add(layer);
                    }
                } else if (jsonObject.get("layers").isJsonArray()) {
                    JsonArray layersArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"layers");
                    for (int i = 0; i < layersArray.size(); ++i) {
                        IModelLayer layer = ModelLayerManager.parseLayer(layersArray.get(i));
                        if (layer == null) continue;
                        item.layers.add(layer);
                    }
                }
            }
        }));
        item.setDescription(JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"description") ? ItemParser.parseDescriptionLines(jsonObject.get("description")) : null);
        return item.setAbilities(JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"abilities") ? AbilityHelper.parseAbilityGenerators(JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"abilities"), true) : null);
    }
}

