/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.threetag.threecore.item.CapacitorItem;
import net.threetag.threecore.util.energy.EnergyUtil;
import net.threetag.threecore.util.energy.IEnergyConfig;

public class CapacitorBlockItem
extends BlockItem {
    private Supplier<Integer> capacity = () -> capacity;
    private Supplier<Integer> maxTransfer = () -> maxTransfer;

    public CapacitorBlockItem(Block blockIn, Item.Properties builder, int capacity, int maxTransfer) {
        super(blockIn, builder);
        this.func_185043_a(new ResourceLocation("threecore", "energy"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
                AtomicReference<Float> f = new AtomicReference<Float>(Float.valueOf(0.0f));
                stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> f.set(Float.valueOf((float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored())));
                return f.get().floatValue();
            }
        });
    }

    public CapacitorBlockItem(Block blockIn, Item.Properties builder, IEnergyConfig energyConfig) {
        this(blockIn, builder, 0, 0);
        this.capacity = energyConfig::getCapacity;
        this.maxTransfer = energyConfig::getPower;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> list.add(EnergyUtil.getFormattedEnergy(e).func_211708_a(TextFormatting.GRAY)));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> stack.func_196082_o().func_74768_a("Energy", e.getMaxEnergyStored()));
            items.add((Object)stack);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapacitorItem.EnergyItemCapabilityProvider(stack, this.capacity.get(), this.maxTransfer.get());
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        AtomicReference<Double> d = new AtomicReference<Double>(1.0);
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> d.set(1.0 - (double)e.getEnergyStored() / (double)e.getMaxEnergyStored()));
        return d.get();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }
}

