/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import net.threetag.threecore.ability.AbilityGenerator;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.IAbilityProvider;
import net.threetag.threecore.capability.ItemAbilityContainerProvider;

public class ShieldAbilityItem
extends ShieldItem
implements IAbilityProvider {
    private List<AbilityGenerator> abilityGenerators;
    private List<ITextComponent> description;
    private final int useDuration;
    private final LazyValue<Ingredient> repairMaterial;

    public ShieldAbilityItem(Item.Properties properties, int useDuration, Supplier<Ingredient> repairMaterial) {
        super(properties);
        this.useDuration = useDuration;
        this.repairMaterial = new LazyValue(repairMaterial);
    }

    public int func_77626_a(ItemStack stack) {
        return this.useDuration;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repairMaterial) {
        return ((Ingredient)this.repairMaterial.func_179281_c()).test(repairMaterial);
    }

    public ShieldAbilityItem setAbilities(List<AbilityGenerator> abilities) {
        this.abilityGenerators = abilities;
        return this;
    }

    public ShieldAbilityItem addAbility(AbilityGenerator abilityGenerator) {
        if (this.abilityGenerators == null) {
            this.abilityGenerators = Lists.newArrayList();
        }
        this.abilityGenerators.add(abilityGenerator);
        return this;
    }

    public ShieldAbilityItem setDescription(List<ITextComponent> description) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.description = description;
        });
        return this;
    }

    public ShieldAbilityItem addDescriptionLine(ITextComponent line) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.description == null) {
                this.description = Lists.newArrayList();
            }
            this.description.add(line);
        });
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.description != null) {
            tooltip.addAll(this.description);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ItemAbilityContainerProvider(stack);
    }

    @Override
    public AbilityMap getAbilities() {
        return new AbilityMap(this.abilityGenerators);
    }

    public static ShieldAbilityItem parse(JsonObject json, Item.Properties properties) {
        ShieldAbilityItem item = new ShieldAbilityItem(properties, JSONUtils.func_151208_a((JsonObject)json, (String)"use_duration", (int)72000), () -> JSONUtils.func_151204_g((JsonObject)json, (String)"repair_material") ? Ingredient.func_199802_a((JsonElement)json.get("repair_material")) : Ingredient.field_193370_a).setAbilities(JSONUtils.func_151204_g((JsonObject)json, (String)"abilities") ? AbilityHelper.parseAbilityGenerators(JSONUtils.func_152754_s((JsonObject)json, (String)"abilities"), true) : null);
        return item;
    }
}

