/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import net.threetag.threecore.ability.AbilityGenerator;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.IAbilityProvider;
import net.threetag.threecore.capability.ItemAbilityContainerProvider;

public class SwordAbilityItem
extends SwordItem
implements IAbilityProvider {
    private List<AbilityGenerator> abilityGenerators;
    private List<ITextComponent> description;

    public SwordAbilityItem(IItemTier itemTier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(itemTier, attackDamage, attackSpeed, properties);
    }

    public SwordAbilityItem setAbilities(List<AbilityGenerator> abilities) {
        this.abilityGenerators = abilities;
        return this;
    }

    public SwordAbilityItem addAbility(AbilityGenerator abilityGenerator) {
        if (this.abilityGenerators == null) {
            this.abilityGenerators = Lists.newArrayList();
        }
        this.abilityGenerators.add(abilityGenerator);
        return this;
    }

    public SwordAbilityItem setDescription(List<ITextComponent> description) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.description = description;
        });
        return this;
    }

    public SwordAbilityItem addDescriptionLine(ITextComponent line) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.description == null) {
                this.description = Lists.newArrayList();
            }
            this.description.add(line);
        });
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.description != null) {
            tooltip.addAll(this.description);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ItemAbilityContainerProvider(stack);
    }

    @Override
    public AbilityMap getAbilities() {
        return new AbilityMap(this.abilityGenerators);
    }
}

