/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.util.threedata.IThreeDataHolder;
import net.threetag.threecore.util.threedata.ThreeData;

public class ThreeDataItemHandler
implements IItemHandlerModifiable {
    public final IThreeDataHolder dataHolder;
    private final List<ThreeData<ItemStack>> dataList;

    public ThreeDataItemHandler(IThreeDataHolder dataHolder, List<ThreeData<ItemStack>> dataList) {
        this.dataHolder = dataHolder;
        this.dataList = dataList;
    }

    public ThreeDataItemHandler(Ability dataHolder, ThreeData<ItemStack> ... data) {
        this.dataHolder = dataHolder;
        this.dataList = Arrays.asList(data);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.dataList.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.dataList.size() + ")");
        }
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.dataHolder.set(this.dataList.get(slot), stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.dataList.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.dataHolder.get(this.dataList.get(slot));
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ThreeData<ItemStack> data = this.dataList.get(slot);
        ItemStack existing = this.dataHolder.get(data);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.dataHolder.set(data, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ThreeData<ItemStack> data = this.dataList.get(slot);
        ItemStack existing = this.dataHolder.get(data);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.dataHolder.set(data, ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.dataHolder.set(data, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    protected void onContentsChanged(int slot) {
    }
}

