/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.threetag.threecore.container.ConstructionTableInventory;

public abstract class AbstractConstructionTableRecipe
implements IRecipe<ConstructionTableInventory> {
    final ResourceLocation id;
    final String group;
    final NonNullList<Ingredient> recipeItems;
    final Ingredient toolIngredient;
    final ItemStack recipeOutput;
    final boolean consumesTool;

    public AbstractConstructionTableRecipe(ResourceLocation id, String group, NonNullList<Ingredient> recipeItems, Ingredient toolIngredient, ItemStack recipeOutput, boolean consumesTool) {
        this.id = id;
        this.group = group;
        this.recipeItems = recipeItems;
        this.toolIngredient = toolIngredient == null ? Ingredient.field_193370_a : toolIngredient;
        this.recipeOutput = recipeOutput;
        this.consumesTool = consumesTool;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public boolean matches(ConstructionTableInventory inv, World worldIn) {
        if (inv.func_70302_i_() != this.recipeItems.size() + 1) {
            return false;
        }
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Ingredient ingredient = (Ingredient)this.recipeItems.get(i);
            if (ingredient.test(stack)) continue;
            return false;
        }
        return this.toolIngredient == Ingredient.field_193370_a || this.toolIngredient.test(inv.getToolItem());
    }

    public ItemStack getCraftingResult(ConstructionTableInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.addAll(this.recipeItems);
        ingredients.add((Object)this.toolIngredient);
        return ingredients;
    }

    public NonNullList<ItemStack> getRemainingItems(ConstructionTableInventory inventory) {
        NonNullList remaining = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (i == remaining.size() - 1) {
                if (this.consumesTool) {
                    remaining.set(i, (Object)ItemStack.field_190927_a);
                    continue;
                }
                if (item.func_77984_f()) {
                    ItemStack copy = item.func_77946_l();
                    boolean[] broken = new boolean[]{false};
                    PlayerEntity playerEntity = ForgeHooks.getCraftingPlayer();
                    copy.func_96631_a(1, playerEntity.func_70681_au(), playerEntity instanceof ServerPlayerEntity ? (ServerPlayerEntity)playerEntity : null);
                    inventory.func_70296_d();
                    remaining.set(i, (Object)(broken[0] ? ItemStack.field_190927_a : copy));
                    continue;
                }
                remaining.set(i, (Object)item.getContainerItem());
                continue;
            }
            if (!item.hasContainerItem()) continue;
            remaining.set(i, (Object)item.getContainerItem());
        }
        return remaining;
    }

    public static abstract class Serializer<T extends AbstractConstructionTableRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final String[] shape;
        public final int size;

        public Serializer(String[] shape) {
            this.shape = shape;
            int i = 0;
            for (String s : shape) {
                i += s.length();
            }
            this.size = i;
        }

        public abstract T create(ResourceLocation var1, String var2, NonNullList<Ingredient> var3, Ingredient var4, ItemStack var5, boolean var6);

        public T read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map map = ShapedRecipe.func_192408_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"pattern");
            NonNullList recipeItems = NonNullList.func_191197_a((int)this.size, (Object)Ingredient.field_193370_a);
            if (jsonArray.size() != this.shape.length) {
                throw new JsonSyntaxException("Invalid pattern: recipe needs " + this.shape.length + " rows");
            }
            int k = 0;
            for (int i = 0; i < jsonArray.size(); ++i) {
                String s = jsonArray.get(i).getAsString();
                if (s.length() != this.shape[i].length()) {
                    throw new JsonSyntaxException("Invalid pattern: recipe needs " + this.shape[i].length() + " columns in row #" + i);
                }
                for (int j = 0; j < s.length(); ++j) {
                    char c = s.charAt(j);
                    if (c == ' ') continue;
                    Ingredient ingredient = (Ingredient)map.get(Character.valueOf(c).toString());
                    if (ingredient == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + c + "' but it's not defined in the key");
                    }
                    recipeItems.set(k++, (Object)ingredient);
                }
            }
            Ingredient toolIngredient = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"tool")) {
                toolIngredient = Ingredient.func_199802_a((JsonElement)json.get("tool"));
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return this.create(recipeId, group, (NonNullList<Ingredient>)recipeItems, toolIngredient, itemstack, JSONUtils.func_151209_a((JsonObject)json, (String)"consumes_tool", (boolean)false));
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList recipeItems = NonNullList.func_191197_a((int)this.size, (Object)Ingredient.field_193370_a);
            for (int k = 0; k < recipeItems.size(); ++k) {
                recipeItems.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            return this.create(recipeId, group, (NonNullList<Ingredient>)recipeItems, ingredient, result, buffer.readBoolean());
        }

        public void write(PacketBuffer buffer, T recipe) {
            buffer.func_180714_a(((AbstractConstructionTableRecipe)recipe).group);
            for (Ingredient ingredient : ((AbstractConstructionTableRecipe)recipe).recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            ((AbstractConstructionTableRecipe)recipe).toolIngredient.func_199564_a(buffer);
            buffer.func_150788_a(((AbstractConstructionTableRecipe)recipe).recipeOutput);
            buffer.writeBoolean(((AbstractConstructionTableRecipe)recipe).consumesTool);
        }
    }
}

