/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.threetag.threecore.fluid.FluidIngredient;
import net.threetag.threecore.item.FluidInventory;
import net.threetag.threecore.item.recipe.IEnergyRecipe;
import net.threetag.threecore.item.recipe.TCRecipeSerializers;
import net.threetag.threecore.util.RecipeUtil;
import net.threetag.threecore.util.TCFluidUtil;

public class FluidComposingRecipe
implements IEnergyRecipe<IInventory> {
    public static final int MAX_WIDTH = 9;
    public static final int MAX_HEIGHT = 9;
    public static final IRecipeType<FluidComposingRecipe> RECIPE_TYPE = RecipeUtil.register("fluid_composing");
    private final ResourceLocation id;
    private final String group;
    private final NonNullList<Ingredient> ingredients;
    private final FluidIngredient inputFluid;
    private final FluidStack output;
    private final int energy;
    private final boolean isSimple;

    public FluidComposingRecipe(ResourceLocation id, String group, NonNullList<Ingredient> ingredients, FluidIngredient inputFluid, FluidStack output, int energy) {
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.inputFluid = inputFluid;
        this.output = output;
        this.energy = energy;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (!(inv instanceof FluidInventory) || !this.inputFluid.test(((FluidInventory)inv).getFluidTank().getFluid())) {
            return false;
        }
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            if (this.isSimple) {
                recipeitemhelper.func_221264_a(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && (this.isSimple ? recipeitemhelper.func_194116_a((IRecipe)this, null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public FluidStack getResult(@Nullable IInventory inv) {
        return this.output;
    }

    @Override
    public int getRequiredEnergy() {
        return this.energy;
    }

    public FluidIngredient getInputFluid() {
        return this.inputFluid;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeSerializer<FluidComposingRecipe> func_199559_b() {
        return (IRecipeSerializer)TCRecipeSerializers.FLUID_COMPOSING.get();
    }

    public IRecipeType<FluidComposingRecipe> func_222127_g() {
        return RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FluidComposingRecipe> {
        public FluidComposingRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
            FluidIngredient fluidIngredient = FluidIngredient.deserialize(json.get("fluid_input"));
            FluidStack output = TCFluidUtil.deserializeFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for fluid composing recipe");
            }
            if (ingredients.size() > 81) {
                throw new JsonParseException("Too many ingredients for fluid composing recipe the max is 81");
            }
            return new FluidComposingRecipe(recipeId, group, ingredients, fluidIngredient, output, energy);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
            NonNullList list = NonNullList.func_191196_a();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonArray.get(i));
                if (ingredient.func_203189_d()) continue;
                list.add((Object)ingredient);
            }
            return list;
        }

        @Nullable
        public FluidComposingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_218666_n();
            int i = buffer.func_150792_a();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            FluidIngredient fluidIngredient = FluidIngredient.read(buffer);
            FluidStack output = FluidStack.readFromPacket((PacketBuffer)buffer);
            int energy = buffer.readInt();
            return new FluidComposingRecipe(recipeId, group, (NonNullList<Ingredient>)ingredients, fluidIngredient, output, energy);
        }

        public void write(PacketBuffer buffer, FluidComposingRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150787_b(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.func_199564_a(buffer);
            }
            recipe.inputFluid.write(buffer);
            recipe.output.writeToPacket(buffer);
            buffer.writeInt(recipe.energy);
        }
    }
}

