/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.threetag.threecore.block.TCBlocks;
import net.threetag.threecore.item.recipe.IEnergyRecipe;
import net.threetag.threecore.item.recipe.TCRecipeSerializers;
import net.threetag.threecore.util.RecipeUtil;

public class PressingRecipe
implements IEnergyRecipe<IInventory> {
    public static final IRecipeType<PressingRecipe> RECIPE_TYPE = RecipeUtil.register("pressing");
    private final ResourceLocation id;
    private final String group;
    private final Ingredient input;
    private final Ingredient cast;
    private final ItemStack output;
    private final float experience;
    private final int energy;

    public PressingRecipe(ResourceLocation id, String group, Ingredient input, Ingredient cast, ItemStack output, float experience, int energy) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.cast = cast;
        this.output = output;
        this.experience = experience;
        this.energy = energy;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)TCBlocks.HYDRAULIC_PRESS.get());
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ItemStack castStack = inv.func_70301_a(0);
        boolean cast = this.cast == null ? castStack.func_190926_b() : this.cast.test(castStack);
        return cast && this.input.test(inv.func_70301_a(1));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output.func_77946_l();
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)(this.cast == null ? Ingredient.field_193370_a : this.cast));
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    @Override
    public int getRequiredEnergy() {
        return this.energy;
    }

    public float getExperience() {
        return this.experience;
    }

    public Ingredient getCast() {
        return this.cast;
    }

    public IRecipeSerializer<PressingRecipe> func_199559_b() {
        return (IRecipeSerializer)TCRecipeSerializers.PRESSING.get();
    }

    public IRecipeType<PressingRecipe> func_222127_g() {
        return RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PressingRecipe> {
        public PressingRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            Ingredient cast = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"cast")) {
                cast = JSONUtils.func_151202_d((JsonObject)json, (String)"cast") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"cast")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"cast"));
            }
            float xp = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
            int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
            return new PressingRecipe(recipeId, group, ingredient, cast, RecipeUtil.parseItemStackExt(JSONUtils.func_152754_s((JsonObject)json, (String)"result"), true), xp, energy);
        }

        public PressingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_218666_n();
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient cast = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            float xp = buffer.readFloat();
            int energy = buffer.func_150792_a();
            return new PressingRecipe(recipeId, s, ingredient, cast, itemstack, xp, energy);
        }

        public void write(PacketBuffer buffer, PressingRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.input.func_199564_a(buffer);
            recipe.cast.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
            buffer.writeFloat(recipe.experience);
            buffer.func_150787_b(recipe.energy);
        }
    }
}

