/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.capability.CapabilitySizeChanging;

public class SyncSizeMessage {
    public int entityId;
    public CompoundNBT data;

    public SyncSizeMessage(int entityId, CompoundNBT data) {
        this.entityId = entityId;
        this.data = data;
    }

    public SyncSizeMessage(PacketBuffer buf) {
        this.entityId = buf.readInt();
        this.data = buf.func_150793_b();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.func_150786_a(this.data);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
            if (entity != null) {
                entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
                    if (sizeChanging instanceof INBTSerializable) {
                        ((INBTSerializable)sizeChanging).deserializeNBT((INBT)this.data);
                        sizeChanging.updateBoundingBox();
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

