/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.sizechanging;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.entity.attributes.TCAttributes;
import net.threetag.threecore.network.SyncSizeMessage;

@Mod.EventBusSubscriber(modid="threecore")
public class SizeChangingEventHandler {
    @SubscribeEvent
    public static void onJoinWorld(EntityJoinWorldEvent e) {
        e.getEntity().getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            sizeChanging.updateBoundingBox();
            if (e.getEntity() instanceof ServerPlayerEntity && sizeChanging instanceof INBTSerializable) {
                ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncSizeMessage(e.getEntity().func_145782_y(), (CompoundNBT)((INBTSerializable)sizeChanging).serializeNBT()), ((ServerPlayerEntity)e.getEntity()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        LivingEntity thrower = null;
        if (e.getEntity() instanceof ThrowableEntity) {
            thrower = ((ThrowableEntity)e.getEntity()).func_85052_h();
        } else if (e.getEntity() instanceof AbstractArrowEntity) {
            thrower = ((AbstractArrowEntity)e.getEntity()).func_212360_k();
        } else if (e.getEntity() instanceof DamagingProjectileEntity) {
            thrower = ((DamagingProjectileEntity)e.getEntity()).field_70235_a;
        }
        if (thrower != null) {
            SizeChangingEventHandler.copyScale((Entity)thrower, e.getEntity());
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent e) {
        e.getEntity().getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(size -> {
            if (size.getScale() <= 0.3f && !e.getEntityLiving().field_70122_E && (e.getEntityLiving().func_184614_ca().func_77973_b() == Items.field_151121_aF || e.getEntityLiving().func_184592_cb().func_77973_b() == Items.field_151121_aF || e.getEntityLiving().func_184614_ca().func_77973_b() == Items.field_151008_G || e.getEntityLiving().func_184592_cb().func_77973_b() == Items.field_151008_G)) {
                e.getEntityLiving().field_70143_R = 0.0f;
                e.getEntityLiving().func_213293_j(e.getEntity().func_213322_ci().field_72450_a, e.getEntity().func_213322_ci().field_72448_b * 0.6, e.getEntity().func_213322_ci().field_72449_c);
            }
        });
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking e) {
        e.getTarget().getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            if (sizeChanging instanceof INBTSerializable && e.getPlayer() instanceof ServerPlayerEntity) {
                ThreeCore.NETWORK_CHANNEL.sendTo((Object)new SyncSizeMessage(e.getTarget().func_145782_y(), (CompoundNBT)((INBTSerializable)sizeChanging).serializeNBT()), ((ServerPlayerEntity)e.getPlayer()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityConstruct(EntityEvent.EntityConstructing e) {
        if (e.getEntity() instanceof LivingEntity) {
            ((LivingEntity)e.getEntity()).func_110140_aT().func_111150_b(TCAttributes.SIZE_WIDTH);
            ((LivingEntity)e.getEntity()).func_110140_aT().func_111150_b(TCAttributes.SIZE_HEIGHT);
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent e) {
        SizeChangingEventHandler.copyScale((Entity)e.getPlayer(), (Entity)e.getEntityItem());
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent e) {
        e.getDrops().forEach(entity -> SizeChangingEventHandler.copyScale((Entity)e.getEntityLiving(), (Entity)entity));
    }

    @SubscribeEvent
    public static void visibility(PlayerEvent.Visibility e) {
        e.getPlayer().getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> e.modifyVisibility((double)sizeChanging.getScale()));
    }

    @SubscribeEvent
    public static void oProjectileImpactFireball(ProjectileImpactEvent.Fireball e) {
        e.getFireball().getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            boolean flag = ForgeEventFactory.getMobGriefingEvent((World)e.getFireball().field_70170_p, (Entity)e.getFireball().field_70235_a);
            e.getFireball().field_70170_p.func_217398_a(null, e.getFireball().func_226277_ct_(), e.getFireball().func_226278_cu_(), e.getFireball().func_226281_cx_(), sizeChanging.getScale(), flag, flag ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
        });
    }

    @SubscribeEvent
    public static void oProjectileImpactThrowable(ProjectileImpactEvent.Throwable e) {
        if (e.getThrowable() instanceof SnowballEntity) {
            e.getThrowable().getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
                float radius = sizeChanging.getScale();
                if (radius > 2.0f) {
                    LinkedList positions = Lists.newLinkedList();
                    int x = 0;
                    while ((float)x < radius) {
                        int z = 0;
                        while ((float)z < radius) {
                            BlockPos pos = new BlockPos(e.getThrowable().func_226277_ct_() + (double)x - (double)(radius / 2.0f), e.getThrowable().func_226278_cu_() + (double)(e.getThrowable().field_213325_aI.field_220316_b / 2.0f) + (double)(radius / 2.0f), e.getThrowable().func_226281_cx_() + (double)z - (double)(radius / 2.0f));
                            int i = 0;
                            boolean b = false;
                            while ((float)i < radius && !b) {
                                if (!e.getThrowable().field_70170_p.func_175623_d(pos)) {
                                    b = true;
                                } else {
                                    pos = pos.func_177977_b();
                                }
                                ++i;
                            }
                            if (e.getThrowable().field_70170_p.func_175623_d(pos.func_177984_a())) {
                                positions.add(pos.func_177984_a());
                            }
                            ++z;
                        }
                        ++x;
                    }
                    for (BlockPos pos : positions) {
                        if (!Blocks.field_150433_aE.func_196260_a(Blocks.field_150433_aE.func_176223_P(), (IWorldReader)e.getThrowable().field_70170_p, pos)) continue;
                        e.getThrowable().field_70170_p.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract e) {
        if (e.getTarget() instanceof CowEntity && e.getItemStack().func_77973_b() instanceof BucketItem) {
            e.getTarget().getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
                if (sizeChanging.getScale() <= 0.75f) {
                    e.setCanceled(true);
                    e.setCancellationResult(ActionResultType.FAIL);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent e) {
        if (e.getSource().func_76364_f() instanceof IProjectile) {
            e.getSource().func_76364_f().getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> e.setAmount(e.getAmount() * sizeChanging.getScale()));
        }
    }

    public static void copyScale(Entity source, Entity entity) {
        source.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging1 -> entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> sizeChanging.setSizeDirectly(sizeChanging1.getSizeChangeType(), sizeChanging1.getScale())));
    }
}

