/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.tileentity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.threetag.threecore.block.CapacitorBlock;
import net.threetag.threecore.container.CapacitorBlockContainer;
import net.threetag.threecore.tileentity.LockableItemCapTileEntity;
import net.threetag.threecore.tileentity.TCTileEntityTypes;
import net.threetag.threecore.util.energy.EnergyStorageExt;
import net.threetag.threecore.util.energy.IEnergyConfig;
import net.threetag.threecore.util.energy.NoReceiveEnergyWrapper;

public class CapacitorBlockTileEntity
extends LockableItemCapTileEntity
implements ITickableTileEntity {
    public CapacitorBlock.Type field_200663_e;
    public EnergyStorageExt energyStorage;
    public final ItemStackHandler inputSlot = new ItemStackHandler(1);
    public final ItemStackHandler outputSlot = new ItemStackHandler(1);
    public final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputSlot, this.outputSlot});
    protected final IIntArray intArray = new IIntArray(){

        public int func_221476_a(int i) {
            switch (i) {
                case 0: {
                    return CapacitorBlockTileEntity.this.energyStorage.getEnergyStored();
                }
                case 1: {
                    return CapacitorBlockTileEntity.this.energyStorage.getMaxEnergyStored();
                }
            }
            return 0;
        }

        public void func_221477_a(int i, int value) {
            switch (i) {
                case 0: {
                    CapacitorBlockTileEntity.this.energyStorage.setEnergyStored(value);
                }
                case 1: {
                    CapacitorBlockTileEntity.this.energyStorage.setMaxEnergyStored(value);
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    public final LazyOptional<IEnergyStorage> energyStorageOptional = LazyOptional.of(() -> this.energyStorage);
    public final NoReceiveEnergyWrapper noReceiveEnergyWrapper = new NoReceiveEnergyWrapper(this.energyStorage);
    public final LazyOptional<IEnergyStorage> energyStorageOptionalBottom = LazyOptional.of(() -> this.noReceiveEnergyWrapper);
    public final LazyOptional<IItemHandler> inputSlotOptional = LazyOptional.of(() -> this.inputSlot);
    public final LazyOptional<IItemHandler> outputSlotOptional = LazyOptional.of(() -> this.outputSlot);
    public final LazyOptional<IItemHandler> combinedInvOptional = LazyOptional.of(() -> this.combinedInvWrapper);

    public CapacitorBlockTileEntity(CapacitorBlock.Type type) {
        super((TileEntityType)TCTileEntityTypes.CAPACITOR_BLOCK.get());
        this.field_200663_e = type;
        this.energyStorage = new EnergyStorageExt(this.getEnergyConfig());
    }

    public IEnergyConfig getEnergyConfig() {
        return this.field_200663_e.getEnergyConfig();
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            int currentLevel;
            int level;
            this.inputSlot.getStackInSlot(0).getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> {
                int energy = e.extractEnergy(e.getEnergyStored(), true);
                if ((energy = this.energyStorage.receiveEnergy(energy, true)) > 0) {
                    this.energyStorage.receiveEnergy(energy, false);
                    e.extractEnergy(energy, false);
                }
            });
            this.outputSlot.getStackInSlot(0).getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> {
                int energy = this.energyStorage.extractEnergy(this.energyStorage.getEnergyStored(), true);
                if ((energy = e.receiveEnergy(energy, true)) > 0) {
                    e.receiveEnergy(energy, false);
                    this.energyStorage.extractEnergy(energy, false);
                }
            });
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
            if (tileEntity != null) {
                tileEntity.getCapability(CapabilityEnergy.ENERGY, Direction.UP).ifPresent(energyStorage -> {
                    if (energyStorage.canReceive()) {
                        this.energyStorage.modifyEnergy(-energyStorage.receiveEnergy(Math.min(this.energyStorage.getEnergyStored(), this.energyStorage.getMaxExtract()), false));
                    }
                });
            }
            if ((level = (int)(10.0f * (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored())) != (currentLevel = ((Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)CapacitorBlock.LEVEL_0_10)).intValue())) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)CapacitorBlock.LEVEL_0_10, (Comparable)Integer.valueOf(level)), 3);
            }
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.threecore.capacitor_block", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new CapacitorBlockContainer(id, playerInventory, this, this.intArray);
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (Objects.requireNonNull(this.field_145850_b).func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.field_200663_e = CapacitorBlock.Type.getByName(compound.func_74779_i("Type"));
        this.energyStorage = new EnergyStorageExt(this.getEnergyConfig(), compound.func_74762_e("Energy"));
        this.inputSlot.deserializeNBT(compound.func_74775_l("InputSlot"));
        this.outputSlot.deserializeNBT(compound.func_74775_l("OutputSlot"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.field_200663_e.func_176610_l());
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        compound.func_218657_a("InputSlot", (INBT)this.inputSlot.serializeNBT());
        compound.func_218657_a("OutputSlot", (INBT)this.outputSlot.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return side == null ? this.combinedInvOptional.cast() : (side == Direction.DOWN ? this.outputSlotOptional.cast() : this.inputSlotOptional.cast());
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return side == Direction.DOWN ? this.energyStorageOptionalBottom.cast() : this.energyStorageOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

