/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.threetag.threecore.ThreeCoreServerConfig;
import net.threetag.threecore.tileentity.TCTileEntityTypes;
import net.threetag.threecore.util.energy.EnergyStorageExt;

public class SolarPanelTileEntity
extends TileEntity
implements ITickableTileEntity {
    public EnergyStorageExt energyStorage;
    private LazyOptional<IEnergyStorage> energyStorageLazyOptional;

    public SolarPanelTileEntity() {
        super((TileEntityType)TCTileEntityTypes.SOLAR_PANEL.get());
        this.energyStorage = EnergyStorageExt.noReceive(ThreeCoreServerConfig.ENERGY.SOLAR_PANEL);
        this.energyStorageLazyOptional = LazyOptional.of(() -> this.energyStorage);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canProduce()) {
            this.energyStorage.modifyEnergy((Integer)ThreeCoreServerConfig.ENERGY.SOLAR_PANEL_PRODUCTION.get());
        }
        if (this.energyStorage.getEnergyStored() > 0) {
            for (Direction direction : Direction.values()) {
                TileEntity tileEntity;
                if (direction == Direction.UP || (tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction))) == null) continue;
                tileEntity.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d()).ifPresent(energyStorage -> {
                    if (energyStorage.canReceive()) {
                        this.energyStorage.modifyEnergy(-energyStorage.receiveEnergy(Math.min(this.energyStorage.getEnergyStored(), this.energyStorage.getMaxExtract()), false));
                    }
                });
            }
        }
    }

    public boolean canProduce() {
        return this.field_145850_b.field_73011_w.func_191066_m() && this.field_145850_b.func_175710_j(this.func_174877_v().func_177984_a()) && !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I() && this.field_145850_b.func_72935_r();
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.energyStorage = EnergyStorageExt.noReceive(ThreeCoreServerConfig.ENERGY.SOLAR_PANEL, compound.func_74762_e("Energy"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityEnergy.ENERGY && (side == Direction.DOWN || side == null) ? this.energyStorageLazyOptional.cast() : super.getCapability(cap, side);
    }
}

