/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import com.google.common.base.MoreObjects;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.HideBodyPartsAbility;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.client.renderer.entity.PlayerSkinHandler;
import net.threetag.threecore.util.RenderUtil;
import net.threetag.threecore.util.threedata.BodyPartListThreeData;

public class AsmHooks {
    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getLocationSkin(NetworkPlayerInfo playerInfo) {
        playerInfo.func_178841_j();
        return PlayerSkinHandler.getCurrentSkin(playerInfo.field_178867_a, (ResourceLocation)MoreObjects.firstNonNull(playerInfo.field_187107_a.get(MinecraftProfileTexture.Type.SKIN), (Object)DefaultPlayerSkin.func_177334_a((UUID)playerInfo.field_178867_a.getId())));
    }

    public static EntitySize getOverridenSize(EntitySize entitySize, Entity entity, Pose pose) {
        Vec2f vec = AsmHooks.getSize(entity, pose);
        return new EntitySize(entitySize.field_220315_a * vec.field_189982_i, entitySize.field_220316_b * vec.field_189983_j, entitySize.field_220317_c);
    }

    public static Vec2f getSize(Entity entity, Pose pose) {
        AtomicReference<Float> width = new AtomicReference<Float>(Float.valueOf(1.0f));
        AtomicReference<Float> height = new AtomicReference<Float>(Float.valueOf(1.0f));
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(s -> {
            width.set(Float.valueOf(s.getWidth()));
            height.set(Float.valueOf(s.getHeight()));
        });
        return new Vec2f(width.get().floatValue(), height.get().floatValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void preRenderCallback(Entity entityIn, MatrixStack matrixStackIn, float partialTicks) {
        matrixStackIn.func_227860_a_();
        entityIn.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            float width = sizeChanging.getRenderWidth(RenderUtil.renderTickTime);
            float height = sizeChanging.getRenderHeight(RenderUtil.renderTickTime);
            matrixStackIn.func_227862_a_(width, height, width);
        });
    }

    public static void entityTick(Entity entity) {
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(s -> s.tick());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderInInvCallback(LivingEntity entity) {
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            float width = 1.0f / sizeChanging.getRenderWidth(RenderUtil.renderTickTime);
            RenderSystem.scalef((float)width, (float)(1.0f / sizeChanging.getRenderHeight(RenderUtil.renderTickTime)), (float)width);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void postRenderCallback(Entity entityIn, MatrixStack matrixStackIn, float partialTicks) {
        matrixStackIn.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void postRotationAnglesCallback(LivingRenderer<? extends LivingEntity, ? extends EntityModel> renderer, LivingEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        for (HideBodyPartsAbility ability : AbilityHelper.getAbilitiesFromClass(entityIn, HideBodyPartsAbility.class)) {
            if (!ability.getConditionManager().isEnabled()) continue;
            for (BodyPartListThreeData.BodyPart bodyPart : (List)ability.get(HideBodyPartsAbility.BODY_PARTS)) {
                bodyPart.setVisibility((PlayerModel)renderer.func_217764_d(), false);
            }
        }
    }
}

