/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerUtil {
    public static void playSound(PlayerEntity player, double x, double y, double z, SoundEvent sound, SoundCategory category) {
        PlayerUtil.playSound(player, x, y, z, sound, category, 1.0f, 1.0f);
    }

    public static void playSound(PlayerEntity player, double x, double y, double z, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlaySoundPacket(sound.getRegistryName(), category, new Vec3d(x, y, z), volume, pitch));
        }
    }

    public static void playSoundToAll(World world, double x, double y, double z, double range, SoundEvent sound, SoundCategory category) {
        PlayerUtil.playSoundToAll(world, x, y, z, range, sound, category, 1.0f, 1.0f);
    }

    public static void playSoundToAll(World world, double x, double y, double z, double range, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        AxisAlignedBB a = new AxisAlignedBB(new BlockPos(x - range, y - range, z - range), new BlockPos(x + range, y + range, z + range));
        for (PlayerEntity players : world.func_217357_a(PlayerEntity.class, a)) {
            PlayerUtil.playSound(players, x, y, z, sound, category, volume, pitch);
        }
    }

    public static void spawnParticle(PlayerEntity player, IParticleData particleIn, boolean longDistanceIn, float xIn, float yIn, float zIn, float xOffsetIn, float yOffsetIn, float zOffsetIn, float speedIn, int countIn) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSpawnParticlePacket(particleIn, longDistanceIn, (double)xIn, (double)yIn, (double)zIn, xOffsetIn, yOffsetIn, zOffsetIn, speedIn, countIn));
        }
    }

    public static void spawnParticleForAll(World world, double range, IParticleData particleIn, boolean longDistanceIn, float xIn, float yIn, float zIn, float xOffsetIn, float yOffsetIn, float zOffsetIn, float speedIn, int countIn) {
        AxisAlignedBB a = new AxisAlignedBB(new BlockPos((double)xIn - range, (double)yIn - range, (double)zIn - range), new BlockPos((double)xIn + range, (double)yIn + range, (double)zIn + range));
        for (PlayerEntity players : world.func_217357_a(PlayerEntity.class, a)) {
            PlayerUtil.spawnParticle(players, particleIn, longDistanceIn, xIn, yIn, zIn, xOffsetIn, yOffsetIn, zOffsetIn, speedIn, countIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasSmallArms(PlayerEntity player) {
        if (player instanceof AbstractClientPlayerEntity) {
            return ((AbstractClientPlayerEntity)player).func_175154_l().equalsIgnoreCase("slim");
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setPlayerSkin(AbstractClientPlayerEntity player, ResourceLocation texture) {
        if (player.func_110306_p().equals((Object)texture)) {
            return;
        }
        NetworkPlayerInfo playerInfo = player.field_175157_a;
        if (playerInfo == null) {
            return;
        }
        Map playerTextures = playerInfo.field_187107_a;
        playerTextures.put(MinecraftProfileTexture.Type.SKIN, texture);
        if (texture == null) {
            playerInfo.field_178864_d = false;
        }
    }
}

