/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.fluid.FluidIngredient;

public class TCFluidUtil {
    public static FluidStack deserializeFluidStack(JsonObject jsonObject) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid")));
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid '" + JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid") + "'");
        }
        return new FluidStack(fluid, JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount"));
    }

    public static JsonObject serializeFluidStack(FluidStack stack) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)stack.getFluid()).toString());
        jsonObject.addProperty("amount", (Number)stack.getAmount());
        return jsonObject;
    }

    public static FluidActionResult interactWithFluidHandler(ItemStack stack, IFluidHandler fluidHandler, IItemHandler itemHandler, @Nullable PlayerEntity player) {
        if (stack.func_190926_b() || fluidHandler == null || itemHandler == null) {
            return FluidActionResult.FAILURE;
        }
        FluidActionResult fillResult = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)fluidHandler, (IItemHandler)itemHandler, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
        if (fillResult.isSuccess()) {
            return fillResult;
        }
        return FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)fluidHandler, (IItemHandler)itemHandler, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
    }

    public static FluidActionResult transferFluidFromTankToItem(ItemStack stack, IFluidHandler fluidHandler, IItemHandler itemHandler, @Nullable PlayerEntity player) {
        if (stack.func_190926_b() || fluidHandler == null || itemHandler == null) {
            return FluidActionResult.FAILURE;
        }
        return FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)fluidHandler, (IItemHandler)itemHandler, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
    }

    public static FluidActionResult transferFluidFromItemToTank(ItemStack stack, IFluidHandler fluidHandler, IItemHandler itemHandler, @Nullable PlayerEntity player) {
        if (stack.func_190926_b() || fluidHandler == null || itemHandler == null) {
            return FluidActionResult.FAILURE;
        }
        return FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)fluidHandler, (IItemHandler)itemHandler, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
    }

    public static boolean drainIngredient(IFluidTank fluidTank, FluidIngredient ingredient, IFluidHandler.FluidAction action) {
        for (FluidStack fluidStack : ingredient.getFluids()) {
            if (!fluidTank.getFluid().containsFluid(fluidStack)) continue;
            fluidTank.drain(fluidStack, action);
            return true;
        }
        return false;
    }

    public static SoundEvent getSound(FluidStack fluidStack, boolean fill) {
        SoundEvent soundEvent;
        SoundEvent soundEvent2 = soundEvent = fill ? fluidStack.getFluid().getAttributes().getFillSound(fluidStack) : fluidStack.getFluid().getAttributes().getEmptySound(fluidStack);
        if (fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204547_b)) {
            return fill ? SoundEvents.field_187633_N : SoundEvents.field_187627_L;
        }
        return soundEvent != null ? soundEvent : (fill ? SoundEvents.field_187630_M : SoundEvents.field_187624_K);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getFormattedFluidInfo(int amount, int capacity) {
        return I18n.func_135052_a((String)"threecore.util.fluid_display", (Object[])new Object[]{amount, "mB"});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<String> getFormattedFluidInfo(FluidTank fluidTank) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(fluidTank.getFluid().getDisplayName().func_150254_d());
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"threecore.util.fluid_tank_display", (Object[])new Object[]{fluidTank.getFluidAmount(), fluidTank.getCapacity(), "mB"}));
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<String> getFormattedFluidInfo(FluidStack fluidStack, int capacity) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(fluidStack.getDisplayName().func_150254_d());
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"threecore.util.fluid_tank_display", (Object[])new Object[]{fluidStack.getAmount(), capacity, "mB"}));
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawTooltip(FluidTank fluidTank, ContainerScreen gui, int x, int y, int width, int height, int mouseX, int mouseY) {
        if (mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height) {
            gui.renderTooltip(TCFluidUtil.getFormattedFluidInfo(fluidTank), mouseX + 10, mouseY);
        }
    }
}

