/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.entityeffect;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.PacketDistributor;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.util.entityeffect.EffectEntity;
import net.threetag.threecore.util.entityeffect.EntityEffectType;
import net.threetag.threecore.util.entityeffect.EntityEffectUpdateMessage;
import net.threetag.threecore.util.threedata.BooleanThreeData;
import net.threetag.threecore.util.threedata.IThreeDataHolder;
import net.threetag.threecore.util.threedata.IWrappedThreeDataHolder;
import net.threetag.threecore.util.threedata.ThreeData;
import net.threetag.threecore.util.threedata.ThreeDataManager;

public abstract class EntityEffect
implements INBTSerializable<CompoundNBT>,
IWrappedThreeDataHolder {
    private final EntityEffectType entityEffectType;
    EffectEntity effectEntity;
    protected ThreeDataManager dataManager = new ThreeDataManager().setListener(new ThreeDataManager.Listener(){

        @Override
        public <T> void dataChanged(ThreeData<T> data, T oldValue, T value) {
            if (EntityEffect.this.effectEntity != null) {
                CompoundNBT nbt = new CompoundNBT();
                data.writeToNBT(nbt, value);
                ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> EntityEffect.this.effectEntity), (Object)new EntityEffectUpdateMessage(EntityEffect.this.effectEntity.func_145782_y(), data.getKey(), nbt));
            }
        }
    });
    public static final ThreeData<Boolean> IS_DONE_PLAYING = new BooleanThreeData("is_done_playing");

    public EntityEffect(EntityEffectType entityEffectType) {
        this.entityEffectType = entityEffectType;
        this.registerData();
    }

    public void registerData() {
        this.register(IS_DONE_PLAYING, false);
    }

    public final EntityEffectType getEntityEffectType() {
        return this.entityEffectType;
    }

    @Override
    public IThreeDataHolder getThreeDataHolder() {
        return this.dataManager;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(EffectEntity var1, Entity var2, MatrixStack var3, IRenderTypeBuffer var4, int var5, boolean var6, float var7);

    public abstract void tick(EffectEntity var1, Entity var2);

    public boolean isDonePlaying() {
        return (Boolean)this.get(IS_DONE_PLAYING);
    }

    public boolean isInRangeToRenderDist(EffectEntity effectEntity, Entity anchor, double distance) {
        return anchor.func_70112_a(distance);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("EntityEffectType", this.entityEffectType.getRegistryName().toString());
        nbt.func_218657_a("Data", (INBT)this.dataManager.serializeNBT());
        nbt.func_218657_a("IsDonePlaying", (INBT)this.dataManager.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.dataManager.deserializeNBT(nbt.func_74775_l("Data"));
    }
}

