/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.util.TCJsonUtil;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.icon.IIconSerializer;

public class TexturedIcon
implements IIcon {
    public static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("threecore", "textures/gui/icons.png");
    public final ResourceLocation texture;
    public final int u;
    public final int v;
    public final int width;
    public final int height;
    public final int textureWidth;
    public final int textureHeight;
    public final Color tint;

    public TexturedIcon(ResourceLocation texture, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.tint = null;
    }

    public TexturedIcon(ResourceLocation texture, int u, int v, int width, int height, int textureWidth, int textureHeight, Color tint) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.tint = tint;
    }

    public TexturedIcon(ResourceLocation texture, int u, int v, int width, int height) {
        this(texture, u, v, width, height, 256, 256);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(Minecraft mc, int x, int y) {
        RenderSystem.pushMatrix();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_227783_c_();
        mc.func_110434_K().func_110577_a(this.texture);
        if (this.tint != null) {
            RenderSystem.color3f((float)((float)this.tint.getRed() / 255.0f), (float)((float)this.tint.getGreen() / 255.0f), (float)((float)this.tint.getBlue() / 255.0f));
        }
        AbstractGui.blit((int)x, (int)y, (float)this.u, (float)this.v, (int)this.width, (int)this.height, (int)this.textureWidth, (int)this.textureHeight);
        RenderHelper.func_227784_d_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public IIconSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIconSerializer<TexturedIcon> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("threecore", "texture");

        @Override
        public TexturedIcon read(JsonObject json) {
            ResourceLocation texture = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"texture"));
            int u = JSONUtils.func_151203_m((JsonObject)json, (String)"u");
            int v = JSONUtils.func_151203_m((JsonObject)json, (String)"v");
            int width = JSONUtils.func_151208_a((JsonObject)json, (String)"width", (int)16);
            int height = JSONUtils.func_151208_a((JsonObject)json, (String)"height", (int)16);
            int textureWidth = JSONUtils.func_151208_a((JsonObject)json, (String)"texture_width", (int)256);
            int textureHeight = JSONUtils.func_151208_a((JsonObject)json, (String)"texture_height", (int)256);
            Color tint = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"tint")) {
                int[] color = TCJsonUtil.getIntArray(json, 3, "tint", 255, 255, 255);
                tint = new Color(color[0], color[1], color[2]);
            }
            return new TexturedIcon(texture, u, v, width, height, textureWidth, textureHeight, tint);
        }

        @Override
        public TexturedIcon read(CompoundNBT nbt) {
            ResourceLocation texture = new ResourceLocation(nbt.func_74779_i("Texture"));
            int u = nbt.func_74762_e("U");
            int v = nbt.func_74762_e("V");
            int width = nbt.func_74762_e("Width");
            int height = nbt.func_74762_e("Height");
            int textureWidth = nbt.func_74762_e("TextureWidth");
            int textureHeight = nbt.func_74762_e("TextureHeight");
            Color tint = null;
            if (nbt.func_74764_b("ColorRed") && nbt.func_74764_b("ColorGreen") && nbt.func_74764_b("ColorBlue")) {
                tint = new Color(nbt.func_74762_e("ColorRed"), nbt.func_74762_e("ColorGreen"), nbt.func_74762_e("ColorBlue"));
            }
            return new TexturedIcon(texture, u, v, width, height, textureWidth, textureHeight, tint);
        }

        @Override
        public CompoundNBT serialize(TexturedIcon icon) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("Texture", icon.texture.toString());
            nbt.func_74768_a("U", icon.u);
            nbt.func_74768_a("V", icon.v);
            nbt.func_74768_a("Width", icon.width);
            nbt.func_74768_a("Height", icon.height);
            nbt.func_74768_a("TextureWidth", icon.textureWidth);
            nbt.func_74768_a("TextureHeight", icon.textureHeight);
            if (icon.tint != null) {
                nbt.func_74768_a("ColorRed", icon.tint.getRed());
                nbt.func_74768_a("ColorGreen", icon.tint.getGreen());
                nbt.func_74768_a("ColorBlue", icon.tint.getBlue());
            }
            return nbt;
        }

        @Override
        public JsonObject serializeJson(TexturedIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("texture", icon.texture.toString());
            jsonObject.addProperty("u", (Number)icon.u);
            jsonObject.addProperty("v", (Number)icon.v);
            jsonObject.addProperty("width", (Number)icon.width);
            jsonObject.addProperty("height", (Number)icon.height);
            jsonObject.addProperty("texture_width", (Number)icon.textureWidth);
            jsonObject.addProperty("texture_height", (Number)icon.textureHeight);
            if (icon.tint != null) {
                JsonArray array = new JsonArray();
                array.add((Number)icon.tint.getRed());
                array.add((Number)icon.tint.getGreen());
                array.add((Number)icon.tint.getBlue());
                jsonObject.add("tint", (JsonElement)array);
            }
            return jsonObject;
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }
    }
}

