/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.entity.attributes.AttributeRegistry;
import net.threetag.threecore.util.threedata.ThreeData;

public class AttributeThreeData
extends ThreeData<IAttribute> {
    public AttributeThreeData(String key) {
        super(key);
    }

    @Override
    public IAttribute parseValue(JsonObject jsonObject, IAttribute defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        AttributeRegistry.AttributeEntry attributeEntry = AttributeRegistry.REGISTRY.func_218349_b(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)this.jsonKey))).orElse(null);
        if (attributeEntry == null) {
            throw new JsonSyntaxException("Attribute " + JSONUtils.func_151200_h((JsonObject)jsonObject, (String)this.jsonKey) + " does not exist!");
        }
        return attributeEntry.getAttribute();
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, IAttribute value) {
        nbt.func_74778_a(this.key, Objects.requireNonNull(AttributeRegistry.REGISTRY.func_177774_c((Object)AttributeRegistry.getEntry(value))).toString());
    }

    @Override
    public IAttribute readFromNBT(CompoundNBT nbt, IAttribute defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        Optional entry = AttributeRegistry.REGISTRY.func_218349_b(new ResourceLocation(nbt.func_74779_i(this.key)));
        return entry.isPresent() ? ((AttributeRegistry.AttributeEntry)entry.get()).getAttribute() : defaultValue;
    }

    @Override
    public JsonElement serializeJson(IAttribute value) {
        return new JsonPrimitive(AttributeRegistry.REGISTRY.func_177774_c((Object)AttributeRegistry.getEntry(value)).toString());
    }
}

