/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.JSONUtils;
import net.threetag.threecore.util.threedata.ThreeData;

public class StringArrayThreeData
extends ThreeData<String[]> {
    public StringArrayThreeData(String key) {
        super(key);
    }

    @Override
    public String[] parseValue(JsonObject jsonObject, String[] defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        JsonElement element = jsonObject.get(this.jsonKey);
        if (element.isJsonPrimitive()) {
            return new String[]{element.getAsString()};
        }
        JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)this.jsonKey);
        String[] array = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = jsonArray.get(i).getAsString();
        }
        return array;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, String[] value) {
        ListNBT list = new ListNBT();
        for (String s : value) {
            list.add((Object)StringNBT.func_229705_a_((String)s));
        }
        nbt.func_218657_a(this.key, (INBT)list);
    }

    @Override
    public String[] readFromNBT(CompoundNBT nbt, String[] defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        ListNBT list = nbt.func_150295_c(this.key, 8);
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.func_150307_f(i);
        }
        return array;
    }

    @Override
    public JsonElement serializeJson(String[] value) {
        if (value.length == 1) {
            return new JsonPrimitive(value[0]);
        }
        JsonArray jsonArray = new JsonArray();
        for (String s : value) {
            jsonArray.add(s);
        }
        return jsonArray;
    }
}

