/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import net.minecraft.nbt.CompoundNBT;
import net.threetag.threecore.util.threedata.EnumSync;

public abstract class ThreeData<T> {
    protected final String key;
    protected String jsonKey;
    protected String description;
    protected EnumSync syncType = EnumSync.EVERYONE;
    protected boolean write = true;
    private final TypeToken<T> typeToken = new TypeToken<T>(this.getClass()){};
    private final Type type = this.typeToken.getType();

    public ThreeData(String key) {
        this.key = key;
    }

    public Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getJsonKey() {
        return this.jsonKey;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isUserSetting() {
        return this.jsonKey != null && !this.jsonKey.isEmpty();
    }

    public ThreeData<T> enableSetting(String jsonKey, String desc) {
        this.jsonKey = jsonKey;
        this.description = desc;
        return this;
    }

    public ThreeData<T> enableSetting(String desc) {
        return this.enableSetting(this.key, desc);
    }

    public ThreeData<T> setSyncType(EnumSync syncType) {
        this.syncType = syncType;
        return this;
    }

    public ThreeData<T> disableSaving() {
        this.write = false;
        return this;
    }

    public boolean canBeSaved() {
        return this.write;
    }

    public abstract T parseValue(JsonObject var1, T var2);

    public abstract void writeToNBT(CompoundNBT var1, T var2);

    public abstract T readFromNBT(CompoundNBT var1, T var2);

    public abstract JsonElement serializeJson(T var1);

    public final String getJsonString(T value) {
        JsonElement element = this.serializeJson(value);
        if (element.isJsonPrimitive()) {
            return this.serializeJson(value).toString().replaceAll("\\\\\"", "\"");
        }
        if (element.isJsonObject()) {
            String s = this.serializeJson(value).toString().replaceAll("\\\\\"", "\"");
            return "{" + s.substring(1, s.length() - 1) + "}";
        }
        return this.serializeJson(value).toString().replaceAll("\\\\\"", "\"");
    }

    public EnumSync getSyncType() {
        return this.syncType;
    }
}

