/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.block.QuarkPaneBlock;
import vazkii.quark.base.handler.RenderLayerHandler;

public class QuarkInheritedPaneBlock
extends QuarkPaneBlock
implements IQuarkBlock,
IBlockColorProvider {
    public final IQuarkBlock parent;

    public QuarkInheritedPaneBlock(IQuarkBlock parent, String name, Block.Properties properties) {
        super(name, parent.getModule(), properties, null);
        this.parent = parent;
        RenderLayerHandler.setInherited((Block)this, parent.getBlock());
    }

    public QuarkInheritedPaneBlock(IQuarkBlock parent, Block.Properties properties) {
        this(parent, Objects.toString(parent.getBlock().getRegistryName()) + "_pane", properties);
    }

    public QuarkInheritedPaneBlock(IQuarkBlock parent) {
        this(parent, Block.Properties.func_200950_a((Block)parent.getBlock()));
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.parent.isEnabled();
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return this.parent.getBlock().getBeaconColorMultiplier(this.parent.getBlock().func_176223_P(), world, pos, beaconPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBlockColor getBlockColor() {
        return this.parent instanceof IBlockColorProvider ? ((IBlockColorProvider)this.parent).getBlockColor() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        return this.parent instanceof IItemColorProvider ? ((IItemColorProvider)this.parent).getItemColor() : null;
    }
}

