/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="quark")
public class BLMHandler {
    private static boolean didTheThing = false;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(TickEvent.ClientTickEvent event) {
        Screen curr;
        Minecraft mc = Minecraft.func_71410_x();
        if (!didTheThing && mc.func_135016_M().func_135041_c().getName().equals("English") && ((curr = mc.field_71462_r) instanceof WorldSelectionScreen || curr instanceof MultiplayerScreen)) {
            mc.func_147108_a((Screen)new BLMScreen(curr));
            didTheThing = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class BLMScreen
    extends Screen {
        private static final int TOTAL_TIME = 10520;
        final Screen parent;
        int ticksElapsed = 0;
        boolean attemptedEsc = false;
        boolean openedWebsite = false;

        protected BLMScreen(Screen parent) {
            super((ITextComponent)new StringTextComponent(""));
            this.parent = parent;
        }

        public void render(int mx, int my, float pticks) {
            super.render(mx, my, pticks);
            BLMScreen.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)-16777216);
            int middle = this.width / 2;
            int timeLeft = 10520 - this.ticksElapsed;
            int secs = timeLeft / 20;
            int mins = secs / 60;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)3.0f, (float)3.0f, (float)3.0f);
            this.drawCenteredString(this.font, String.format("%dm%02ds", mins, secs -= mins * 60), middle / 3, 10, 0xFFFFFF);
            RenderSystem.popMatrix();
            String[] message = new String[]{};
            int dist = 15;
            message = this.attemptedEsc ? new String[]{"Before you go, remember: You can skip this.", "George Floyd couldn't.", "While you're waiting to play, he was waiting to die.", "", "Black people are disproportionately killed by the police", "in the United States. It's time to stand up.", "Click anywhere on screen to find out how to help.", "#BlackLivesMatter", "(Press ESC again to leave)"} : new String[]{"Before you start playing, please read this message provided by Quark.", "George Floyd was killed by a police officer, who stood on him for 8m46s.", "All he'd done was attempt to pay with a fake $20 bill.", "Innocent black lives are being taken by police officers all over the USA.", "It's time to make history.", "", "Click anywhere on screen to find out how to help.", "#BlackLivesMatter", "", "(You may press ESC to skip)"};
            for (int i = 0; i < message.length; ++i) {
                if (!this.attemptedEsc && this.ticksElapsed - 20 <= i * 70) continue;
                this.drawCenteredString(this.font, message[i], middle, 70 + i * dist, 0xFFFFFF);
            }
        }

        public void tick() {
            super.tick();
            ++this.ticksElapsed;
            if (this.ticksElapsed > 10520) {
                this.minecraft.func_147108_a(this.parent);
            }
        }

        public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
            if (p_keyPressed_1_ == 256) {
                if (this.attemptedEsc) {
                    this.minecraft.func_147108_a(this.parent);
                    return true;
                }
                this.attemptedEsc = true;
                return false;
            }
            return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (p_mouseClicked_5_ == 0 && !this.openedWebsite) {
                this.minecraft.func_147108_a((Screen)new ConfirmOpenLinkScreen(this::consume, "https://blacklivesmatter.carrd.co/", true));
                return true;
            }
            return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }

        private void consume(boolean b) {
            this.minecraft.func_147108_a((Screen)this);
            if (b) {
                Util.func_110647_a().func_195640_a("https://blacklivesmatter.carrd.co/");
            }
            this.openedWebsite = b;
        }
    }
}

