/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.integration.jei.ElytraDuplicationExtension;
import vazkii.quark.tools.item.AncientTomeItem;
import vazkii.quark.tools.module.AncientTomesModule;
import vazkii.quark.tools.module.ColorRunesModule;
import vazkii.quark.tools.module.PickarangModule;
import vazkii.quark.tweaks.recipe.ElytraDuplicationRecipe;

@JeiPlugin
public class QuarkJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("quark", "quark");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{AncientTomesModule.ancient_tome});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(ElytraDuplicationRecipe.class, ElytraDuplicationExtension::new);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        if (ModuleLoader.INSTANCE.isModuleEnabled(AncientTomesModule.class)) {
            this.registerAncientTomeAnvilRecipes(registration, factory);
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(PickarangModule.class)) {
            this.registerPickarangAnvilRepairs(registration, factory);
        }
    }

    private void registerAncientTomeAnvilRecipes(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        for (Enchantment enchant : AncientTomesModule.validEnchants) {
            EnchantmentData data = new EnchantmentData(enchant, enchant.func_77325_b());
            recipes.add(factory.createAnvilRecipe(EnchantedBookItem.func_92111_a((EnchantmentData)data), Collections.singletonList(AncientTomeItem.getEnchantedItemStack(data)), Collections.singletonList(EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(data.field_76302_b, data.field_76303_c + 1)))));
        }
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }

    private void registerRuneAnvilRecipes(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        Random random = new Random();
        List used = Stream.of(Items.field_151048_u, Items.field_151046_w, Items.field_151056_x, Items.field_151047_v, Items.field_151012_L, Items.field_151161_ac, Items.field_151163_ad, Items.field_151173_ae, Items.field_151175_af, Items.field_185160_cR, Items.field_185159_cQ, Items.field_151031_f, Items.field_222114_py, Items.field_151146_bM, Items.field_151112_aM, Items.field_151097_aZ).map(item -> QuarkJeiPlugin.makeEnchantedDisplayItem(item, random)).collect(Collectors.toList());
        if (ModuleLoader.INSTANCE.isModuleEnabled(PickarangModule.class)) {
            used.add(QuarkJeiPlugin.makeEnchantedDisplayItem(PickarangModule.pickarang, random));
        }
        ArrayList<Object> recipes = new ArrayList<Object>();
        for (Item rune : ColorRunesModule.runesTag.func_199885_a()) {
            ItemStack runeStack = new ItemStack((IItemProvider)rune);
            recipes.add(factory.createAnvilRecipe(used, Collections.singletonList(runeStack), used.stream().map(stack -> {
                ItemStack output = stack.func_77946_l();
                ItemNBTHelper.setBoolean((ItemStack)output, (String)"quark:RuneAttached", (boolean)true);
                ItemNBTHelper.setCompound((ItemStack)output, (String)"quark:RuneColor", (CompoundNBT)runeStack.serializeNBT());
                return output;
            }).collect(Collectors.toList())));
        }
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }

    private static ItemStack makeEnchantedDisplayItem(Item input, Random random) {
        ItemStack stack = new ItemStack((IItemProvider)input);
        if (input.func_77619_b() <= 0) {
            stack.func_77966_a(Enchantments.field_185307_s, 3);
            return stack;
        }
        return EnchantmentHelper.func_77504_a((Random)random, (ItemStack)stack, (int)25, (boolean)false);
    }

    private void registerPickarangAnvilRepairs(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ItemStack nearlyBroken = new ItemStack((IItemProvider)PickarangModule.pickarang);
        nearlyBroken.func_196085_b(nearlyBroken.func_77958_k());
        ItemStack veryDamaged = nearlyBroken.func_77946_l();
        veryDamaged.func_196085_b(veryDamaged.func_77958_k() * 3 / 4);
        ItemStack damaged = nearlyBroken.func_77946_l();
        damaged.func_196085_b(damaged.func_77958_k() * 2 / 4);
        Object materialRepair = factory.createAnvilRecipe(nearlyBroken, Collections.singletonList(new ItemStack((IItemProvider)Items.field_151045_i)), Collections.singletonList(veryDamaged));
        Object toolRepair = factory.createAnvilRecipe(veryDamaged, Collections.singletonList(veryDamaged), Collections.singletonList(damaged));
        registration.addRecipes(Arrays.asList(materialRepair, toolRepair), VanillaRecipeCategoryUid.ANVIL);
    }
}

