/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.capability;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import vazkii.quark.api.IMagnetTracker;
import vazkii.quark.oddities.capability.Force;

public class MagnetTracker
implements IMagnetTracker {
    private final Multimap<BlockPos, Force> forcesActing = HashMultimap.create();
    private final World world;

    public MagnetTracker(World world) {
        this.world = world;
    }

    @Override
    public Vec3i getNetForce(BlockPos pos) {
        Vec3i net = Vec3i.field_177959_e;
        for (Force force : this.forcesActing.get((Object)pos)) {
            net = force.add(net);
        }
        return net;
    }

    @Override
    public void applyForce(BlockPos pos, int magnitude, boolean pushing, Direction dir, int distance, BlockPos origin) {
        this.forcesActing.put((Object)pos, (Object)new Force(magnitude, pushing, dir, distance, origin));
    }

    @Override
    public void actOnForces(BlockPos pos) {
        Vec3i net = this.getNetForce(pos);
        if (net.equals((Object)Vec3i.field_177959_e)) {
            return;
        }
        Direction target = Direction.func_176737_a((float)net.func_177958_n(), (float)net.func_177956_o(), (float)net.func_177952_p());
        for (Force force : this.forcesActing.get((Object)pos)) {
            if (force.getDirection() != target) continue;
            BlockState origin = this.world.func_180495_p(force.getOrigin());
            this.world.func_175641_c(force.getOrigin(), origin.func_177230_c(), force.isPushing() ? 0 : 1, force.getDistance());
        }
    }

    @Override
    public Collection<BlockPos> getTrackedPositions() {
        return this.forcesActing.keySet();
    }

    @Override
    public void clear() {
        this.forcesActing.clear();
    }
}

