/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.forge.blocks.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.shedaniel.rareice.forge.ItemLocation;
import me.shedaniel.rareice.forge.RareIce;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;

public class RareIceBlockEntity
extends TileEntity
implements IClearable,
ITickableTileEntity {
    private static final Random RANDOM = new Random();
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("rare-ice:chests/rare_ice");
    private final NonNullList<ItemStack> itemsContained = NonNullList.func_191196_a();
    private final List<ItemLocation> itemsLocations = new ArrayList<ItemLocation>();
    private boolean setup = false;
    private int delay = 0;

    public RareIceBlockEntity() {
        super(RareIce.RARE_ICE_BLOCK_ENTITY_TYPE);
    }

    public void func_174888_l() {
        this.itemsContained.clear();
        this.itemsLocations.clear();
    }

    public NonNullList<ItemStack> getItemsContained() {
        return this.itemsContained;
    }

    public List<ItemLocation> getItemsLocations() {
        return this.itemsLocations;
    }

    public void func_145839_a(CompoundNBT tag) {
        this.loadInitialChunkData(tag);
        this.delay = tag.func_74762_e("RevertDelay");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.saveInitialChunkData(tag);
        tag.func_74768_a("RevertDelay", this.delay);
        return tag;
    }

    private CompoundNBT saveInitialChunkData(CompoundNBT tag) {
        super.func_189515_b(tag);
        ListNBT itemsTag = new ListNBT();
        ListNBT itemLocationsTag = new ListNBT();
        for (int i = 0; i < this.itemsLocations.size(); ++i) {
            CompoundNBT CompoundNBT2;
            ItemLocation itemLocation = this.itemsLocations.get(i);
            ItemStack stack = (ItemStack)this.itemsContained.get(i);
            if (!stack.func_190926_b()) {
                CompoundNBT2 = new CompoundNBT();
                stack.func_77955_b(CompoundNBT2);
                itemsTag.add((Object)CompoundNBT2);
            }
            if (stack.func_190926_b()) continue;
            CompoundNBT2 = new CompoundNBT();
            itemLocation.write(CompoundNBT2);
            itemLocationsTag.add((Object)CompoundNBT2);
        }
        tag.func_218657_a("Items", (INBT)itemsTag);
        tag.func_218657_a("ItemLocations", (INBT)itemLocationsTag);
        return tag;
    }

    private void loadInitialChunkData(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.itemsContained.clear();
        this.itemsLocations.clear();
        ListNBT itemsTag = tag.func_150295_c("Items", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            CompoundNBT CompoundNBT2 = itemsTag.func_150305_b(i);
            this.itemsContained.add((Object)ItemStack.func_199557_a((CompoundNBT)CompoundNBT2));
        }
        ListNBT itemLocationsTag = tag.func_150295_c("ItemLocations", 10);
        for (int i = 0; i < itemLocationsTag.size(); ++i) {
            CompoundNBT CompoundNBT3 = itemLocationsTag.func_150305_b(i);
            this.itemsLocations.add(ItemLocation.read(CompoundNBT3));
        }
    }

    public void addLootTable(World world) {
        this.setup = true;
    }

    public void func_73660_a() {
        if (this.setup) {
            this.setup = false;
            this.delay = 0;
            LootTable lootTable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(LOOT_TABLE);
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_145850_b);
            List drops = lootTable.func_216113_a(builder.func_216022_a(LootParameterSets.field_216260_a));
            int size = MathHelper.func_76125_a((int)(this.field_145850_b.field_73012_v.nextInt(5) - (this.field_145850_b.field_73012_v.nextInt(1) + 2)), (int)0, (int)drops.size());
            if (drops.size() >= 1) {
                for (int i = 0; i < size; ++i) {
                    int index = this.field_145850_b.field_73012_v.nextInt(drops.size());
                    this.addItem(this.field_145850_b, (ItemStack)drops.get(index), null);
                    drops.remove(index);
                }
            }
        } else if (this.itemsContained.isEmpty()) {
            ++this.delay;
            if (this.delay > 20) {
                this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150432_aD.func_176223_P());
                this.func_145843_s();
            }
        } else {
            this.delay = 0;
        }
    }

    public ActionResultType addItem(World world, ItemStack itemStack, PlayerEntity nullablePlayer) {
        return this.addItem(world, itemStack, nullablePlayer, true);
    }

    public ActionResultType addItem(World world, ItemStack itemStack, PlayerEntity nullablePlayer, boolean actuallyAdd) {
        Material material;
        if (itemStack.func_77973_b() instanceof BlockItem && ((material = ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P().func_185904_a()) == Material.field_151588_w || material == Material.field_151598_x)) {
            return ActionResultType.PASS;
        }
        if (this.getItemsContained().size() < 8 && itemStack.func_190916_E() >= 1) {
            if (actuallyAdd) {
                this.getItemsContained().add((Object)itemStack.func_77979_a(1));
                Random random = world.field_73012_v;
                if (random == null) {
                    random = RANDOM;
                }
                this.getItemsLocations().add(new ItemLocation(random.nextDouble() * 0.95 + 0.1, random.nextDouble() * 0.7 + 0.1, random.nextDouble() * 0.95 + 0.1));
                this.updateListeners();
            }
            if (nullablePlayer != null && world.field_72995_K) {
                nullablePlayer.func_184185_a(SoundEvents.field_211419_ds, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void updateListeners() {
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.saveInitialChunkData(new CompoundNBT());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.loadInitialChunkData(tag);
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }
}

