/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.forge.blocks.entities;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import me.shedaniel.rareice.forge.ItemLocation;
import me.shedaniel.rareice.forge.blocks.entities.RareIceBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RareIceBlockEntityRenderer
extends TileEntityRenderer<RareIceBlockEntity> {
    public void render(RareIceBlockEntity blockEntity, double x, double y, double z, float tickDelta, int destroyStage) {
        if (blockEntity.func_145837_r()) {
            return;
        }
        NonNullList<ItemStack> contained = blockEntity.getItemsContained();
        List<ItemLocation> locations = blockEntity.getItemsLocations();
        for (int i = 0; i < contained.size(); ++i) {
            ItemStack stack = (ItemStack)contained.get(i);
            ItemLocation location = locations.get(i);
            if (stack.func_190926_b()) continue;
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)(x + location.field_72450_a), (double)(y + location.field_72448_b), (double)(z + location.field_72449_c));
            double yawDegrees = location.yaw * 180.0;
            if (yawDegrees < 0.0) {
                yawDegrees += 360.0;
            }
            GlStateManager.rotatef((float)((float)yawDegrees), (float)0.0f, (float)1.0f, (float)0.0f);
            double pitchDegrees = location.pitch * 180.0 - 90.0;
            if (pitchDegrees < 0.0) {
                pitchDegrees += 360.0;
            }
            GlStateManager.rotatef((float)((float)pitchDegrees), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)0.8f, (float)0.8f, (float)0.8f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
        }
    }
}

