/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.blocks.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.shedaniel.rareice.ItemLocation;
import me.shedaniel.rareice.RareIce;
import me.shedaniel.rareice.mixin.BlockHooks;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3000;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_3829;
import net.minecraft.class_47;
import net.minecraft.class_52;

public class RareIceBlockEntity
extends class_2586
implements class_3829,
BlockEntityClientSerializable,
class_3000 {
    private static final Random RANDOM = new Random();
    private static final class_2960 LOOT_TABLE = new class_2960("rare-ice:chests/rare_ice");
    private final class_2371<class_1799> itemsContained = class_2371.method_10211();
    private final List<ItemLocation> itemsLocations = new ArrayList<ItemLocation>();
    private boolean setup = false;
    private int delay = 0;

    public RareIceBlockEntity() {
        super(RareIce.RARE_ICE_BLOCK_ENTITY_TYPE);
    }

    public void method_5448() {
        this.itemsContained.clear();
        this.itemsLocations.clear();
    }

    public class_2371<class_1799> getItemsContained() {
        return this.itemsContained;
    }

    public List<ItemLocation> getItemsLocations() {
        return this.itemsLocations;
    }

    public void method_11014(class_2487 tag) {
        this.loadInitialChunkData(tag);
        this.delay = tag.method_10550("RevertDelay");
    }

    public class_2487 method_11007(class_2487 tag) {
        this.saveInitialChunkData(tag);
        tag.method_10569("RevertDelay", this.delay);
        return tag;
    }

    private class_2487 saveInitialChunkData(class_2487 tag) {
        super.method_11007(tag);
        class_2499 itemsTag = new class_2499();
        class_2499 itemLocationsTag = new class_2499();
        for (int i = 0; i < this.itemsLocations.size(); ++i) {
            class_2487 compoundTag;
            ItemLocation itemLocation = this.itemsLocations.get(i);
            class_1799 stack = (class_1799)this.itemsContained.get(i);
            if (!stack.method_7960()) {
                compoundTag = new class_2487();
                stack.method_7953(compoundTag);
                itemsTag.add((Object)compoundTag);
            }
            if (stack.method_7960()) continue;
            compoundTag = new class_2487();
            itemLocation.toTag(compoundTag);
            itemLocationsTag.add((Object)compoundTag);
        }
        tag.method_10566("Items", (class_2520)itemsTag);
        tag.method_10566("ItemLocations", (class_2520)itemLocationsTag);
        return tag;
    }

    private void loadInitialChunkData(class_2487 tag) {
        super.method_11014(tag);
        this.itemsContained.clear();
        this.itemsLocations.clear();
        class_2499 itemsTag = tag.method_10554("Items", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            class_2487 compoundTag = itemsTag.method_10602(i);
            this.itemsContained.add((Object)class_1799.method_7915((class_2487)compoundTag));
        }
        class_2499 itemLocationsTag = tag.method_10554("ItemLocations", 10);
        for (int i = 0; i < itemLocationsTag.size(); ++i) {
            class_2487 compoundTag = itemLocationsTag.method_10602(i);
            this.itemsLocations.add(ItemLocation.fromTag(compoundTag));
        }
    }

    public void addLootTable(class_1937 world) {
        this.setup = true;
    }

    public void method_16896() {
        if (this.setup) {
            this.setup = false;
            this.delay = 0;
            class_52 lootTable = this.field_11863.method_8503().method_3857().method_367(LOOT_TABLE);
            class_47.class_48 builder = new class_47.class_48((class_3218)this.field_11863);
            List drops = lootTable.method_319(builder.method_309(class_173.field_1175));
            int size = class_3532.method_15340((int)(this.field_11863.field_9229.nextInt(5) - (this.field_11863.field_9229.nextInt(1) + 2)), (int)0, (int)drops.size());
            if (drops.size() >= 1) {
                for (int i = 0; i < size; ++i) {
                    int index = this.field_11863.field_9229.nextInt(drops.size());
                    this.addItem(this.field_11863, (class_1799)drops.get(index), null);
                    drops.remove(index);
                }
            }
        } else if (this.itemsContained.isEmpty()) {
            ++this.delay;
            if (this.delay > 20) {
                this.field_11863.method_8501(this.field_11867, class_2246.field_10295.method_9564());
                this.method_11012();
            }
        } else {
            this.delay = 0;
        }
    }

    public class_1269 addItem(class_1937 world, class_1799 itemStack, class_1657 nullablePlayer) {
        return this.addItem(world, itemStack, nullablePlayer, true);
    }

    public class_1269 addItem(class_1937 world, class_1799 itemStack, class_1657 nullablePlayer, boolean actuallyDoIt) {
        class_3614 material;
        if (itemStack.method_7909() instanceof class_1747 && ((material = ((BlockHooks)((class_1747)itemStack.method_7909()).method_7711()).getMaterial()) == class_3614.field_15958 || material == class_3614.field_15928)) {
            return class_1269.field_5811;
        }
        if (this.getItemsContained().size() < 8 && itemStack.method_7947() >= 1) {
            if (actuallyDoIt) {
                this.getItemsContained().add((Object)itemStack.method_7971(1));
                Random random = world.field_9229;
                if (random == null) {
                    random = RANDOM;
                }
                this.getItemsLocations().add(new ItemLocation(random.nextDouble() * 0.95 + 0.1, random.nextDouble() * 0.7 + 0.1, random.nextDouble() * 0.95 + 0.1));
                this.updateListeners();
            }
            if (nullablePlayer != null && world.method_8608()) {
                nullablePlayer.method_5783(class_3417.field_14804, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_21466;
    }

    private void updateListeners() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void fromClientTag(class_2487 tag) {
        this.loadInitialChunkData(tag);
    }

    public class_2487 toClientTag(class_2487 tag) {
        return this.saveInitialChunkData(tag);
    }
}

