/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.forge;

import me.shedaniel.rareice.forge.RareIceClient;
import me.shedaniel.rareice.forge.blocks.RareIceBlock;
import me.shedaniel.rareice.forge.blocks.entities.RareIceBlockEntity;
import me.shedaniel.rareice.forge.world.gen.feature.RareIceConfig;
import me.shedaniel.rareice.forge.world.gen.feature.RareIceFeature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="rare-ice", bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="rare-ice")
public class RareIce {
    public static final Block RARE_ICE_BLOCK = new RareIceBlock(Block.Properties.func_200950_a((Block)Blocks.field_150432_aD).harvestTool(ToolType.PICKAXE));
    public static final TileEntityType<RareIceBlockEntity> RARE_ICE_BLOCK_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(RareIceBlockEntity::new, (Block[])new Block[]{RARE_ICE_BLOCK}).func_206865_a(null);
    public static final Feature<RareIceConfig> RARE_ICE_FEATURE = new RareIceFeature(RareIceConfig::getDefault);

    public RareIce() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().register((Object)new RareIceClient()));
        MinecraftForge.EVENT_BUS.addListener(RareIce::rightClickBlock);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)RARE_ICE_BLOCK.setRegistryName(new ResourceLocation("rare-ice", "rare_ice"))});
    }

    @SubscribeEvent
    public static void registerTileEntityTypes(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register(RARE_ICE_BLOCK_ENTITY_TYPE.setRegistryName(new ResourceLocation("rare-ice", "rare_ice")));
    }

    private static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_225608_bj_()) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150432_aD || state.func_177230_c() == RARE_ICE_BLOCK) {
            TileEntity blockEntity = world.func_175625_s(pos);
            if (blockEntity == null) {
                world.func_175656_a(pos, RARE_ICE_BLOCK.func_176223_P());
                blockEntity = world.func_175625_s(pos);
            }
            if (blockEntity instanceof RareIceBlockEntity) {
                RareIceBlockEntity rareIceBlockEntity = (RareIceBlockEntity)blockEntity;
                ItemStack itemStack = player.func_184586_b(event.getHand());
                itemStack = player.field_71075_bZ.field_75098_d ? itemStack.func_77946_l() : itemStack;
                ActionResultType type = rareIceBlockEntity.addItem(world, itemStack, player, event.getSide().isServer());
                if (type != ActionResultType.PASS) {
                    event.setCanceled(true);
                }
                event.setCancellationResult(type);
            }
        }
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        ForgeRegistries.BIOMES.getValues().stream().filter(biome -> biome.func_185353_n() < 0.15f).forEach(RareIce::handleBiome);
    }

    private static void handleBiome(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, RARE_ICE_FEATURE.func_225566_b_((IFeatureConfig)RareIceConfig.DEFAULT).func_227228_a_(Placement.field_215031_q.func_227446_a_((IPlacementConfig)new CountRangeConfig(16, 32, 128, 256))));
    }
}

