/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.CommonProxy;
import com.github.alexthe666.rats.server.advancements.RatsAdvancementRegistry;
import com.github.alexthe666.rats.server.compat.ChiselCompatBridge;
import com.github.alexthe666.rats.server.compat.CraftTweakerCompatBridge;
import com.github.alexthe666.rats.server.compat.ThaumcraftCompatBridge;
import com.github.alexthe666.rats.server.compat.TinkersCompatBridge;
import com.github.alexthe666.rats.server.entity.EntityIllagerPiper;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.events.ServerEvents;
import com.github.alexthe666.rats.server.inventory.GuiHandler;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.items.RatsNuggetRegistry;
import com.github.alexthe666.rats.server.message.MessageAutoCurdlerFluid;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffRat;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffSync;
import com.github.alexthe666.rats.server.message.MessageDancingRat;
import com.github.alexthe666.rats.server.message.MessageIncreaseRatRecipe;
import com.github.alexthe666.rats.server.message.MessageRatCommand;
import com.github.alexthe666.rats.server.message.MessageRatDismount;
import com.github.alexthe666.rats.server.message.MessageSwingArm;
import com.github.alexthe666.rats.server.message.MessageSyncThrownBlock;
import com.github.alexthe666.rats.server.message.MessageUpdateRatFluid;
import com.github.alexthe666.rats.server.potion.PotionConfitByaldi;
import com.github.alexthe666.rats.server.potion.PotionPlague;
import com.github.alexthe666.rats.server.recipes.RatsRecipeRegistry;
import com.github.alexthe666.rats.server.world.RatsWorldRegistry;
import com.github.alexthe666.rats.server.world.village.RatsVillageRegistry;
import java.io.File;
import java.util.List;
import net.ilexiconn.llibrary.server.network.NetworkWrapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Logger;

@Mod(modid="rats", name="Rats", dependencies="required-after:llibrary@[1.7.9,)", version="3.2.12", guiFactory="com.github.alexthe666.rats.client.gui.RatsGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class RatsMod {
    public static final String MODID = "rats";
    public static final String NAME = "Rats";
    public static final String VERSION = "3.2.12";
    public static final String LLIBRARY_VERSION = "1.7.9";
    public static CreativeTabs TAB = new CreativeTabs("rats"){

        public ItemStack func_78016_d() {
            return new ItemStack(RatsItemRegistry.CHEESE);
        }
    };
    public static CreativeTabs TAB_UPGRADES = new CreativeTabs("rats.upgrades"){

        public ItemStack func_78016_d() {
            return new ItemStack(RatsItemRegistry.RAT_UPGRADE_BASIC);
        }
    };
    @Mod.Instance(value="rats")
    public static RatsMod INSTANCE;
    @SidedProxy(clientSide="com.github.alexthe666.rats.client.ClientProxy", serverSide="com.github.alexthe666.rats.server.CommonProxy")
    public static CommonProxy PROXY;
    @NetworkWrapper(value={MessageRatCommand.class, MessageRatDismount.class, MessageIncreaseRatRecipe.class, MessageAutoCurdlerFluid.class, MessageCheeseStaffRat.class, MessageCheeseStaffSync.class, MessageSyncThrownBlock.class, MessageDancingRat.class, MessageSwingArm.class, MessageUpdateRatFluid.class})
    public static SimpleNetworkWrapper NETWORK_WRAPPER;
    public static Logger logger;
    public static Potion CONFIT_BYALDI_POTION;
    public static Potion PLAGUE_POTION;
    public static Configuration config;
    public static RatConfig CONFIG_OPTIONS;
    public static boolean iafLoaded;
    public static DamageSource ratTrapDamage;

    public static void loadConfig() {
        File configFile = new File(Loader.instance().getConfigDir(), "rats.cfg");
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (Exception e) {
                logger.warn("Could not create a new Rats config file.");
                logger.warn(e.getLocalizedMessage());
            }
        }
        config = new Configuration(configFile);
        config.load();
    }

    public static void syncConfig() {
        CONFIG_OPTIONS.init(config);
        config.save();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        RatsMod.loadConfig();
        RatsMod.syncConfig();
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        PROXY.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        logger = event.getModLog();
        RatsAdvancementRegistry.INSTANCE.init();
        RatsRecipeRegistry.preRegister();
        CraftTweakerCompatBridge.loadTweakerCompat();
        TinkersCompatBridge.loadTinkersCompat();
        ThaumcraftCompatBridge.loadThaumcraftCompat();
        iafLoaded = Loader.isModLoaded((String)"iceandfire");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Rats is initializing");
        PROXY.init();
        ChiselCompatBridge.loadChiselCompat();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        RatsRecipeRegistry.register();
        RatsWorldRegistry.register();
        RatsVillageRegistry.register();
        ratTrapDamage = new DamageSource("rat_trap_damage"){

            public ITextComponent func_151519_b(EntityLivingBase entityLivingBaseIn) {
                String s = "death.rat_trap_damage";
                return new TextComponentTranslation(s, new Object[]{entityLivingBaseIn.func_145748_c_()});
            }
        };
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        List spawnList;
        PROXY.postInit();
        RatsNuggetRegistry.init();
        TinkersCompatBridge.loadTinkersPostInitCompat();
        if (RatsMod.CONFIG_OPTIONS.spawnRats) {
            for (Biome biome : Biome.field_185377_q) {
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) || biome == null || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                spawnList = RatsMod.CONFIG_OPTIONS.ratsSpawnLikeMonsters ? biome.func_76747_a(EnumCreatureType.MONSTER) : biome.func_76747_a(EnumCreatureType.CREATURE);
                spawnList.add(new Biome.SpawnListEntry(EntityRat.class, RatsMod.CONFIG_OPTIONS.ratSpawnRate, 1, 3));
            }
        }
        if (RatsMod.CONFIG_OPTIONS.spawnPiper) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || (spawnList = biome.func_76747_a(EnumCreatureType.MONSTER)).isEmpty() || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) continue;
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
                    spawnList.add(new Biome.SpawnListEntry(EntityIllagerPiper.class, RatsMod.CONFIG_OPTIONS.piperSpawnRate * 3, 1, 1));
                    continue;
                }
                spawnList.add(new Biome.SpawnListEntry(EntityIllagerPiper.class, RatsMod.CONFIG_OPTIONS.piperSpawnRate, 1, 1));
            }
        }
    }

    static {
        CONFIT_BYALDI_POTION = new PotionConfitByaldi();
        PLAGUE_POTION = new PotionPlague();
        CONFIG_OPTIONS = new RatConfig();
    }
}

