/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.BlockRatCageDecorated;
import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCageBreedingLantern;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCageDecorated;
import com.github.alexthe666.rats.server.items.IRatCageDecoration;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRatCage
extends Block {
    public static final PropertyInteger NORTH = PropertyInteger.func_177719_a((String)"north", (int)0, (int)2);
    public static final PropertyInteger EAST = PropertyInteger.func_177719_a((String)"east", (int)0, (int)2);
    public static final PropertyInteger SOUTH = PropertyInteger.func_177719_a((String)"south", (int)0, (int)2);
    public static final PropertyInteger WEST = PropertyInteger.func_177719_a((String)"west", (int)0, (int)2);
    public static final PropertyInteger UP = PropertyInteger.func_177719_a((String)"up", (int)0, (int)2);
    public static final PropertyInteger DOWN = PropertyInteger.func_177719_a((String)"down", (int)0, (int)2);
    private static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 1.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 1.0, 1.0);

    public BlockRatCage(String name) {
        super(Material.field_151573_f, MapColor.field_151665_m);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(RatsMod.TAB);
        this.func_149663_c("rats." + name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)EAST, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)SOUTH, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)WEST, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)UP, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DOWN, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("rats", name);
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tile.rats.rat_cage.desc0", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tile.rats.rat_cage.desc1", (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Integer.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Integer.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Integer.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)WEST, (Comparable)Integer.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.WEST))).func_177226_a((IProperty)UP, (Comparable)Integer.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Integer.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.DOWN)));
    }

    public int canFenceConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        if (world.func_180495_p(other).func_177230_c() instanceof BlockRatTube) {
            return 2;
        }
        return world.func_180495_p(other).func_177230_c() instanceof BlockRatCage ? 1 : 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)RatsBlockRegistry.RAT_CAGE);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(RatsBlockRegistry.RAT_CAGE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (state.func_177230_c() instanceof BlockRatCage) {
            IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
            if ((Integer)actualState.func_177229_b((IProperty)UP) == 0) {
                BlockRatCage.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TOP_AABB);
            }
            if ((Integer)actualState.func_177229_b((IProperty)DOWN) == 0) {
                BlockRatCage.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOTTOM_AABB);
            }
            if ((Integer)actualState.func_177229_b((IProperty)NORTH) == 0) {
                BlockRatCage.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
            }
            if ((Integer)actualState.func_177229_b((IProperty)SOUTH) == 0) {
                BlockRatCage.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
            }
            if ((Integer)actualState.func_177229_b((IProperty)EAST) == 0) {
                BlockRatCage.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
            }
            if ((Integer)actualState.func_177229_b((IProperty)WEST) == 0) {
                BlockRatCage.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand).func_77973_b() instanceof IRatCageDecoration && !this.hasTileEntity(state) && ((IRatCageDecoration)playerIn.func_184586_b(hand).func_77973_b()).canStay(worldIn, pos, this)) {
            EnumFacing limitedFacing = playerIn.func_174811_aO().func_176734_d();
            if (!worldIn.field_72995_K) {
                BlockRatCageDecorated.DECO_TRIGGER.trigger((EntityPlayerMP)playerIn, (Entity)playerIn);
            }
            if (playerIn.func_184586_b(hand).func_77973_b() == RatsItemRegistry.RAT_BREEDING_LANTERN) {
                worldIn.func_180501_a(pos, RatsBlockRegistry.RAT_CAGE_BREEDING_LANTERN.func_176223_P().func_177226_a((IProperty)BlockRatCageDecorated.FACING, (Comparable)limitedFacing), 2);
                TileEntityRatCageBreedingLantern decorated = new TileEntityRatCageBreedingLantern();
                ItemStack added = new ItemStack(playerIn.func_184586_b(hand).func_77973_b(), 1, playerIn.func_184586_b(hand).func_77960_j());
                decorated.setContainedItem(added);
                worldIn.func_175690_a(pos, (TileEntity)decorated);
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184586_b(hand).func_190918_g(1);
                }
            } else {
                worldIn.func_180501_a(pos, RatsBlockRegistry.RAT_CAGE_DECORATED.func_176223_P().func_177226_a((IProperty)BlockRatCageDecorated.FACING, (Comparable)limitedFacing), 2);
                TileEntityRatCageDecorated decorated = new TileEntityRatCageDecorated();
                ItemStack added = new ItemStack(playerIn.func_184586_b(hand).func_77973_b(), 1, playerIn.func_184586_b(hand).func_77960_j());
                decorated.setContainedItem(added);
                worldIn.func_175690_a(pos, (TileEntity)decorated);
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184586_b(hand).func_190918_g(1);
                }
            }
            return true;
        }
        if (this.hasTileEntity(state)) {
            ItemStack stack = this.getContainedItem(worldIn, pos);
            boolean clearIt = true;
            if (stack != ItemStack.field_190927_a) {
                clearIt = playerIn.func_70093_af();
            }
            if (clearIt) {
                worldIn.func_175656_a(pos, RatsBlockRegistry.RAT_CAGE.func_176223_P());
            }
        }
        if (playerIn.func_184586_b(hand).func_190926_b()) {
            boolean ridingRats = false;
            if (!playerIn.func_184188_bt().isEmpty()) {
                for (Entity entity : playerIn.func_184188_bt()) {
                    if (!(entity instanceof EntityRat)) continue;
                    ridingRats = true;
                    break;
                }
            }
            if (ridingRats) {
                int ratCount = 0;
                for (Entity entity : playerIn.func_184188_bt()) {
                    if (!(entity instanceof EntityRat) || ((EntityRat)entity).func_70631_g_()) continue;
                    EntityRat rat = (EntityRat)entity;
                    rat.func_184210_p();
                    rat.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    rat.func_70661_as().func_75499_g();
                    rat.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
                    ++ratCount;
                }
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("entity.rat.cage.deposit", new Object[]{ratCount}), true);
                return true;
            }
            int ratCount = 0;
            List list = worldIn.func_72872_a(EntityRat.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)));
            for (EntityRat rat : list) {
                if (!rat.func_70631_g_()) {
                    rat.func_70107_b(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v);
                }
                ++ratCount;
            }
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("entity.rat.cage.withdrawal", new Object[]{ratCount}), true);
            return true;
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public ItemStack getContainedItem(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityRatCageDecorated) {
            return ((TileEntityRatCageDecorated)te).getContainedItem();
        }
        return ItemStack.field_190927_a;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }
}

