/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.ai.PiperAIStrife;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityIllagerPiper
extends AbstractIllager
implements IRangedAttackMob {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rats", "illager_piper"));
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityIllagerPiper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> RAT_COUNT = EntityDataManager.func_187226_a(EntityIllagerPiper.class, (DataSerializer)DataSerializers.field_187192_b);
    private final PiperAIStrife aiArrowAttack = new PiperAIStrife(this, 0.8, 20, 15.0f);
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 0.8, false);
    private int ratCooldown = 0;
    private int fluteTicks = 0;

    public EntityIllagerPiper(World world) {
        super(world);
        this.setCombatTask();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(RAT_COUNT, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityRat.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    public boolean func_70601_bi() {
        int spawnRoll = RatsMod.CONFIG_OPTIONS.piperSpawnDecrease;
        if (RatUtils.canSpawnInDimension(this.field_70170_p) && (spawnRoll == 0 || this.field_70146_Z.nextInt(spawnRoll) == 0)) {
            return super.func_70601_bi();
        }
        return false;
    }

    public void func_70106_y() {
        if (!this.field_70128_L) {
            double dist = 20.0;
            for (EntityRat rat : this.field_70170_p.func_72872_a(EntityRat.class, new AxisAlignedBB(this.field_70165_t - dist, this.field_70163_u - dist, this.field_70161_v - dist, this.field_70165_t + dist, this.field_70163_u + dist, this.field_70161_v + dist))) {
                if (!rat.isOwnerMonster() || rat.getOwnerMonster() == null || !rat.getOwnerMonster().equals((Object)this)) continue;
                rat.func_70903_f(false);
                rat.func_184754_b(null);
                rat.fleePos = new BlockPos((Entity)rat);
                rat.func_70624_b(null);
                rat.func_70604_c(null);
            }
        }
        this.field_70128_L = true;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("RatsSummoned", this.getRatsSummoned());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRatsSummoned(compound.func_74762_e("RatsSummoned"));
        this.setCombatTask();
    }

    public int getRatsSummoned() {
        return (Integer)this.field_70180_af.func_187225_a(RAT_COUNT);
    }

    public void setRatsSummoned(int count) {
        this.field_70180_af.func_187227_b(RAT_COUNT, (Object)count);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.summonRat();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.setCombatTask();
        return livingdata;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_77973_b() == RatsItemRegistry.RAT_FLUTE) {
                int i = 100;
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(RatsItemRegistry.RAT_FLUTE));
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    @SideOnly(value=Side.CLIENT)
    public AbstractIllager.IllagerArmPose func_193077_p() {
        return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
    }

    public void summonRat() {
        if (this.getRatsSummoned() < 6 && this.ratCooldown == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)82);
            EntityRat rat = new EntityRat(this.field_70170_p);
            rat.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            rat.func_82149_j((Entity)this);
            rat.setPlague(false);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)rat);
            }
            rat.setMonsterOwnerId(this.func_110124_au());
            rat.setOwnerMonster(true);
            rat.setCommand(RatCommand.FOLLOW);
            if (this.func_70638_az() != null) {
                rat.func_70624_b(this.func_70638_az());
            }
            this.setRatsSummoned(this.getRatsSummoned() + 1);
            this.func_184185_a(RatsSoundRegistry.RAT_FLUTE, 0.7f, 1.0f);
            this.ratCooldown = 150;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.ratCooldown > 0) {
            --this.ratCooldown;
        }
        if (this.fluteTicks % 157 == 0) {
            this.func_184185_a(RatsSoundRegistry.PIPER_LOOP, 0.7f, 1.0f);
        }
        ++this.fluteTicks;
        if (this.fluteTicks % 10 == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)83);
        }
        if (this.getRatsSummoned() < 3 && this.ratCooldown == 0) {
            this.summonRat();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 82) {
            this.playEffect(0);
        } else if (id == 83) {
            this.playEffect(1);
        } else {
            super.func_70103_a(id);
        }
    }

    protected void playEffect(int type) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.NOTE;
        if (type == 1) {
            double d0 = 0.0;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, 0.0, 0.0, new int[0]);
        } else {
            double d0 = 0.65;
            for (int i = 0; i < 9; ++i) {
                this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && cause.func_76346_g() instanceof EntityRat) {
            if (new Random().nextBoolean()) {
                this.func_145779_a(RatsItemRegistry.MUSIC_DISC_MICE_ON_VENUS, 1);
            } else {
                this.func_145779_a(RatsItemRegistry.MUSIC_DISC_LIVING_MICE, 1);
            }
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191269_hn;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191270_ho;
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }
}

