/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.BlockRatCage;
import com.github.alexthe666.rats.server.blocks.BlockRatHole;
import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityCheeseCannonball;
import com.github.alexthe666.rats.server.entity.EntityIllagerPiper;
import com.github.alexthe666.rats.server.entity.EntityLaserBeam;
import com.github.alexthe666.rats.server.entity.EntityLaserPortal;
import com.github.alexthe666.rats.server.entity.EntityRatDragonFire;
import com.github.alexthe666.rats.server.entity.EntityThrownBlock;
import com.github.alexthe666.rats.server.entity.RatAquaticMoveHelper;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatNukeExplosion;
import com.github.alexthe666.rats.server.entity.RatStatus;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.ai.AquaticRatPathNavigate;
import com.github.alexthe666.rats.server.entity.ai.FlyingRatPathNavigate;
import com.github.alexthe666.rats.server.entity.ai.RatAIAttackMelee;
import com.github.alexthe666.rats.server.entity.ai.RatAIDepositEnergy;
import com.github.alexthe666.rats.server.entity.ai.RatAIDepositFluid;
import com.github.alexthe666.rats.server.entity.ai.RatAIDepositInInventory;
import com.github.alexthe666.rats.server.entity.ai.RatAIEnterTrap;
import com.github.alexthe666.rats.server.entity.ai.RatAIFleeMobs;
import com.github.alexthe666.rats.server.entity.ai.RatAIFleePosition;
import com.github.alexthe666.rats.server.entity.ai.RatAIFleeSun;
import com.github.alexthe666.rats.server.entity.ai.RatAIFollowOwner;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestBreeder;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestCrops;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestFarmer;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestFisherman;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestMilk;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestMine;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestPlacer;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestShears;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestTrees;
import com.github.alexthe666.rats.server.entity.ai.RatAIHuntAnimals;
import com.github.alexthe666.rats.server.entity.ai.RatAIHurtByTarget;
import com.github.alexthe666.rats.server.entity.ai.RatAIOwnerHurtByTarget;
import com.github.alexthe666.rats.server.entity.ai.RatAIOwnerHurtTarget;
import com.github.alexthe666.rats.server.entity.ai.RatAIPickupEnergy;
import com.github.alexthe666.rats.server.entity.ai.RatAIPickupFluid;
import com.github.alexthe666.rats.server.entity.ai.RatAIPickupFromInventory;
import com.github.alexthe666.rats.server.entity.ai.RatAIRaidChests;
import com.github.alexthe666.rats.server.entity.ai.RatAIRaidCrops;
import com.github.alexthe666.rats.server.entity.ai.RatAISit;
import com.github.alexthe666.rats.server.entity.ai.RatAISwimming;
import com.github.alexthe666.rats.server.entity.ai.RatAITargetItems;
import com.github.alexthe666.rats.server.entity.ai.RatAIWander;
import com.github.alexthe666.rats.server.entity.ai.RatAIWanderAquatic;
import com.github.alexthe666.rats.server.entity.ai.RatAIWanderFlight;
import com.github.alexthe666.rats.server.entity.ai.RatFlyingMoveHelper;
import com.github.alexthe666.rats.server.entity.ai.RatPathNavigate;
import com.github.alexthe666.rats.server.entity.ai.RatPathPathNavigateGround;
import com.github.alexthe666.rats.server.entity.ai.RatTubeMoveHelper;
import com.github.alexthe666.rats.server.entity.ai.RatTubePathNavigate;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCraftingTable;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatHole;
import com.github.alexthe666.rats.server.items.ItemRatCombinedUpgrade;
import com.github.alexthe666.rats.server.items.ItemRatSack;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeBucket;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeEnergy;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeJuryRigged;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeOreDoubling;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.items.RatsNuggetRegistry;
import com.github.alexthe666.rats.server.message.MessageDancingRat;
import com.github.alexthe666.rats.server.message.MessageSyncThrownBlock;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.github.alexthe666.rats.server.recipes.RatsRecipeRegistry;
import com.github.alexthe666.rats.server.recipes.SharedRecipe;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityRat
extends EntityTameable
implements IAnimatedEntity {
    public static final Animation ANIMATION_EAT = Animation.create((int)10);
    public static final Animation ANIMATION_IDLE_SCRATCH = Animation.create((int)25);
    public static final Animation ANIMATION_IDLE_SNIFF = Animation.create((int)20);
    public static final Animation ANIMATION_DANCE_0 = Animation.create((int)35);
    public static final Animation ANIMATION_DANCE_1 = Animation.create((int)30);
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rats", "rat"));
    public static final ResourceLocation CHRISTMAS_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rats", "christmas_rat_gifts"));
    protected static final DataParameter<Optional<UUID>> MONSTER_OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> IS_MALE = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TOGA = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PLAGUE = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> VISUAL_FLAG = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR_VARIANT = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DANCING = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> OWNER_NOT_PLAYER = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DANCE_MOVES = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HELD_RF = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_CUSTOM_RADIUS = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> RADIUS_CENTER = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> SEARCH_RADIUS = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final String[] RAT_TEXTURES = new String[]{"rats:textures/entity/rat/rat_blue.png", "rats:textures/entity/rat/rat_black.png", "rats:textures/entity/rat/rat_brown.png", "rats:textures/entity/rat/rat_green.png", "rats:textures/entity/rat/tamed/rat_albino.png", "rats:textures/entity/rat/tamed/rat_hooded.png", "rats:textures/entity/rat/tamed/rat_hooded_brown.png", "rats:textures/entity/rat/tamed/rat_hooded_gray.png", "rats:textures/entity/rat/tamed/rat_siamese.png", "rats:textures/entity/rat/tamed/rat_white.png", "rats:textures/entity/rat/tamed/rat_hooded_yellow.png", "rats:textures/entity/rat/tamed/rat_brown_undercoat.png", "rats:textures/entity/rat/tamed/rat_dark_undercoat.png"};
    private static final int CHRISTMAS_PRESENT_TIME = 24000;
    private static final SoundEvent[] CRAFTING_SOUNDS = new SoundEvent[]{SoundEvents.field_187698_i, SoundEvents.field_187881_gQ, SoundEvents.field_191253_dD, SoundEvents.field_187647_cU, SoundEvents.field_187726_cu, SoundEvents.field_187728_s, SoundEvents.field_187719_p, SoundEvents.field_187713_n, SoundEvents.field_187927_ha};
    public float sitProgress;
    public float holdProgress;
    public float deadInTrapProgress;
    public float sleepProgress;
    public boolean isDeadInTrap;
    public BlockPos fleePos;
    public boolean holdInMouth = true;
    public int wildTrust = 0;
    public ContainerHorseChest ratInventory;
    public BlockPos depositPos;
    public EnumFacing depositFacing = EnumFacing.UP;
    public BlockPos pickupPos;
    public BlockPos tubeTarget = null;
    public int cheeseFeedings = 0;
    public boolean climbingTube = false;
    public boolean waterBased = false;
    public boolean crafting = false;
    public int cookingProgress = 0;
    public int coinCooldown = 0;
    public int breedCooldown = 0;
    public float flyingPitch;
    public float prevFlyingPitch;
    public BlockPos jukeboxPos;
    public boolean isFleeing = false;
    public FluidStack transportingFluid = null;
    protected int navigatorType;
    private boolean inTube;
    private boolean inCage;
    private int animationTick;
    private Animation currentAnimation;
    private RatStatus status = RatStatus.IDLE;
    private BlockPos finalDigPathPoint = null;
    private BlockPos diggingPos = null;
    private int breakingTime;
    private int previousBreakProgress = -1;
    private int digCooldown = 0;
    private int eatingTicks = 0;
    private ItemStack prevUpgrade = ItemStack.field_190927_a;
    private int eatenItems = 0;
    private EntityAIBase aiHarvest;
    private EntityAIBase aiPickup;
    private EntityAIBase aiDeposit;
    private int rangedAttackCooldownCannon = 0;
    private int rangedAttackCooldownLaser = 0;
    private int rangedAttackCooldownPsychic = 0;
    private int rangedAttackCooldownDragon = 0;
    private int visualCooldown = 0;
    private int poopCooldown = 0;

    public EntityRat(World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.RAIL, 1000.0f);
        this.switchNavigator(1);
        this.func_70105_a(0.49f, 0.49f);
        this.initInventory();
        this.setupDynamicAI();
    }

    public static BlockPos getPositionRelativetoGround(EntityRat rat, World world, double x, double z, Random rng) {
        if (rat.func_110175_bO()) {
            x = (float)(rat.func_180486_cf().func_177958_n() + rng.nextInt((int)rat.func_110174_bM())) - rat.func_110174_bM() / 2.0f;
            z = (float)(rat.func_180486_cf().func_177952_p() + rng.nextInt((int)rat.func_110174_bM())) - rat.func_110174_bM() / 2.0f;
        }
        BlockPos pos = new BlockPos(x, rat.field_70163_u, z);
        while ((world.func_175623_d(pos.func_177977_b()) || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRatCage) && pos.func_177956_o() > 0) {
            pos = pos.func_177977_b();
        }
        if (rat.isInCage()) {
            return pos.func_177981_b(rat.func_70681_au().nextInt(3));
        }
        return pos.func_177981_b(3 + rat.func_70681_au().nextInt(3));
    }

    public static BlockPos getPositionRelativetoWater(EntityRat rat, World world, double x, double z, Random rng) {
        BlockPos topY = new BlockPos(x, rat.field_70163_u, z);
        BlockPos bottomY = new BlockPos(x, rat.field_70163_u, z);
        while (world.func_180495_p(topY).func_185904_a() == Material.field_151586_h && topY.func_177956_o() < world.func_72800_K()) {
            topY = topY.func_177984_a();
        }
        while (world.func_180495_p(bottomY).func_185904_a() == Material.field_151586_h && bottomY.func_177956_o() > 0) {
            bottomY = bottomY.func_177977_b();
        }
        for (int tries = 0; tries < 5; ++tries) {
            BlockPos pos = new BlockPos(x, (double)(bottomY.func_177956_o() + 1 + rng.nextInt(Math.max(1, topY.func_177956_o() - bottomY.func_177956_o() - 2))), z);
            if (world.func_180495_p(pos).func_185904_a() != Material.field_151586_h) continue;
            return pos;
        }
        return rat.func_180425_c();
    }

    protected void func_184651_r() {
        this.aiHarvest = new RatAIHarvestCrops(this);
        this.aiPickup = new RatAIPickupFromInventory(this);
        this.aiDeposit = new RatAIDepositInInventory(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new RatAIAttackMelee(this, 1.45, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new RatAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.45, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new RatAIFleeMobs(this, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_70089_S() && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() != RatsItemRegistry.PIPER_HAT || entity instanceof EntityOcelot;
            }
        }, 10.0f, 0.8, 1.33));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new RatAIFollowOwner(this, 1.33, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new RatAIFleeSun(this, 1.66));
        this.field_70911_d = new RatAISit(this);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new RatAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new RatAIWanderFlight(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new RatAIWanderAquatic(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new RatAIRaidChests(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new RatAIRaidCrops(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new RatAIEnterTrap(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new RatAIFleePosition(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, new RatAIHuntAnimals(this, (Predicate<? super EntityLivingBase>)new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase entity) {
                if (EntityRat.this.hasPlague()) {
                    return entity instanceof EntityPlayer && !entity.func_184191_r((Entity)EntityRat.this) && entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() != RatsItemRegistry.BLACK_DEATH_MASK && entity.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
                }
                if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
                    return false;
                }
                if (EntityRat.this.shouldHuntMonsters()) {
                    return entity instanceof IMob;
                }
                if (EntityRat.this.shouldHuntAnimals()) {
                    return entity != null && !(entity instanceof EntityRat) && !(entity instanceof IMob) && !entity.func_184191_r((Entity)EntityRat.this) && (!(entity instanceof EntityPlayer) || EntityRat.this.hasPlague()) && !entity.func_70631_g_();
                }
                return false;
            }
        }));
        this.field_70715_bh.func_75776_a(1, new RatAITargetItems(this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new RatAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new RatAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new RatAIHurtByTarget(this, false, new Class[0]));
    }

    protected void setupDynamicAI() {
        this.field_70714_bg.func_85156_a(this.aiHarvest);
        this.field_70714_bg.func_85156_a(this.aiDeposit);
        this.field_70714_bg.func_85156_a(this.aiPickup);
        this.aiHarvest = new RatAIHarvestCrops(this);
        this.aiDeposit = new RatAIDepositInInventory(this);
        this.aiPickup = new RatAIPickupFromInventory(this);
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK) && !(this.aiHarvest instanceof RatAIHarvestTrees)) {
            this.aiHarvest = new RatAIHarvestTrees(this);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && !(this.aiHarvest instanceof RatAIHarvestMine)) {
            this.aiHarvest = new RatAIHarvestMine(this);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && !(this.aiHarvest instanceof RatAIHarvestFarmer)) {
            this.aiHarvest = new RatAIHarvestFarmer(this);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) && !(this.aiHarvest instanceof RatAIHarvestFisherman)) {
            this.aiHarvest = new RatAIHarvestFisherman(this);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MILKER) && !(this.aiHarvest instanceof RatAIHarvestMilk)) {
            this.aiHarvest = new RatAIHarvestMilk(this);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SHEARS) && !(this.aiHarvest instanceof RatAIHarvestShears)) {
            this.aiHarvest = new RatAIHarvestShears(this);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLACER) && !(this.aiHarvest instanceof RatAIHarvestPlacer)) {
            this.aiHarvest = new RatAIHarvestPlacer(this);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BREEDER) && !(this.aiHarvest instanceof RatAIHarvestBreeder)) {
            this.aiHarvest = new RatAIHarvestBreeder(this);
        }
        if (this.getMBTransferRate() > 0) {
            this.aiDeposit = new RatAIPickupFluid(this);
            this.aiPickup = new RatAIDepositFluid(this);
        } else if (this.getRFTransferRate() > 0) {
            this.aiDeposit = new RatAIPickupEnergy(this);
            this.aiPickup = new RatAIDepositEnergy(this);
        }
        this.field_70714_bg.func_75776_a(3, this.aiHarvest);
        this.field_70714_bg.func_75776_a(4, this.aiDeposit);
        this.field_70714_bg.func_75776_a(4, this.aiPickup);
    }

    @Nullable
    public EntityLivingBase func_70902_q() {
        try {
            UUID uuid = this.func_184753_b();
            EntityPlayer player = this.field_70170_p.func_152378_a(uuid);
            if (player != null) {
                return player;
            }
        }
        catch (Exception var2) {
            return null;
        }
        return null;
    }

    @Nullable
    public EntityLivingBase getOwnerMonster() {
        try {
            Entity entity;
            UUID uuid = this.getMonsterOwnerId();
            if (!this.field_70170_p.field_72995_K && (entity = this.field_70170_p.func_73046_m().func_71218_a(this.field_71093_bK).func_175733_a(uuid)) instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public boolean func_104002_bU() {
        return !this.func_70692_ba() || super.func_104002_bU();
    }

    protected boolean func_70692_ba() {
        if (RatsMod.CONFIG_OPTIONS.ratsDespawn) {
            return !this.func_70909_n() && !this.func_70631_g_() && !this.isInCage();
        }
        return false;
    }

    protected void func_70623_bb() {
        Event.Result result = null;
        if (!this.func_70692_ba()) {
            return;
        }
        if ((this.field_70708_bq & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
            } else {
                this.func_70106_y();
            }
        } else {
            EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (entity != null) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70163_u - this.field_70163_u;
                double d2 = entity.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.func_70692_ba() && d3 > RatsMod.CONFIG_OPTIONS.ratDespawnFarDistance * RatsMod.CONFIG_OPTIONS.ratDespawnFarDistance) {
                    this.func_70106_y();
                }
                double closeDist = RatsMod.CONFIG_OPTIONS.ratDespawnCloseDistance * RatsMod.CONFIG_OPTIONS.ratDespawnCloseDistance;
                if (this.field_70708_bq > 300 && this.field_70146_Z.nextInt(RatsMod.CONFIG_OPTIONS.ratDespawnRandomChance) == 0 && d3 > closeDist && this.func_70692_ba()) {
                    this.func_70106_y();
                } else if (d3 < closeDist) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }

    public boolean func_70601_bi() {
        int spawnRoll = RatsMod.CONFIG_OPTIONS.ratSpawnDecrease;
        if (RatUtils.canSpawnInDimension(this.field_70170_p)) {
            if (RatsMod.CONFIG_OPTIONS.ratsSpawnLikeMonsters) {
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                    spawnRoll *= 2;
                }
                if (spawnRoll == 0 || this.field_70146_Z.nextInt(spawnRoll) == 0) {
                    BlockPos pos = new BlockPos((Entity)this);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(pos.func_177977_b());
                    return this.isValidLightLevel() && iblockstate.func_189884_a((Entity)this);
                }
            } else {
                return ((spawnRoll = MathHelper.func_76141_d((float)((float)spawnRoll * 0.25f))) == 0 || this.field_70146_Z.nextInt(spawnRoll) == 0) && this.getCanSpawnHereAnimal();
            }
        }
        return false;
    }

    public boolean getCanSpawnHereAnimal() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        return this.field_70170_p.func_175699_k(blockpos) > 8 && super.func_70601_bi();
    }

    public boolean func_70648_aU() {
        return this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AQUATIC) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_UNDERWATER);
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70617_f_() {
        if (this.inTube()) {
            return this.climbingTube;
        }
        return super.func_70617_f_();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_MALE, (Object)false);
        this.field_70180_af.func_187214_a(TOGA, (Object)false);
        this.field_70180_af.func_187214_a(PLAGUE, (Object)false);
        this.field_70180_af.func_187214_a(VISUAL_FLAG, (Object)false);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(COLOR_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(DANCING, (Object)false);
        this.field_70180_af.func_187214_a(DANCE_MOVES, (Object)0);
        this.field_70180_af.func_187214_a(HELD_RF, (Object)0);
        this.field_70180_af.func_187214_a(OWNER_NOT_PLAYER, (Object)false);
        this.field_70180_af.func_187214_a(RADIUS_CENTER, (Object)this.func_180425_c());
        this.field_70180_af.func_187214_a(HAS_CUSTOM_RADIUS, (Object)false);
        this.field_70180_af.func_187214_a(SEARCH_RADIUS, (Object)RatsMod.CONFIG_OPTIONS.defaultRatRadius);
        this.field_70180_af.func_187214_a(MONSTER_OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected void switchNavigator(int type) {
        if (type == 1) {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new RatPathPathNavigateGround(this, this.field_70170_p);
            this.navigatorType = 1;
        } else if (type == 0) {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new RatPathPathNavigateGround(this, this.field_70170_p);
            this.navigatorType = 0;
        } else if (type == 2) {
            this.field_70765_h = new RatFlyingMoveHelper(this);
            this.field_70699_by = new FlyingRatPathNavigate(this, this.field_70170_p);
            this.navigatorType = 2;
        } else if (type == 3) {
            this.field_70765_h = new RatTubeMoveHelper(this);
            RatTubePathNavigate newNav = new RatTubePathNavigate((EntityLiving)this, this.field_70170_p);
            if (this.field_70699_by.func_75505_d() != null && this.field_70699_by.func_75505_d().func_75870_c() != null) {
                PathPoint point = this.field_70699_by.func_75505_d().func_75870_c();
                newNav.func_75492_a(point.field_75839_a, point.field_75837_b, point.field_75838_c, 1.0);
            }
            this.field_70699_by = newNav;
            this.navigatorType = 3;
        } else if (type == 4) {
            this.field_70765_h = new RatAquaticMoveHelper(this);
            this.field_70699_by = new AquaticRatPathNavigate(this, this.field_70170_p);
            this.navigatorType = 4;
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        if (this.func_70909_n() && !this.isInCage()) {
            return super.func_175447_b(worldIn);
        }
        return new RatPathNavigate((EntityLiving)this, worldIn);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("HomeDistance", this.func_110174_bM());
        if (this.func_180486_cf() != null) {
            compound.func_74768_a("HomePosX", this.func_180486_cf().func_177958_n());
            compound.func_74768_a("HomePosY", this.func_180486_cf().func_177956_o());
            compound.func_74768_a("HomePosZ", this.func_180486_cf().func_177952_p());
        }
        if (this.getSearchRadiusCenter() != null) {
            compound.func_74768_a("RadiusPosX", this.getSearchRadiusCenter().func_177958_n());
            compound.func_74768_a("RadiusPosY", this.getSearchRadiusCenter().func_177956_o());
            compound.func_74768_a("RadiusPosZ", this.getSearchRadiusCenter().func_177952_p());
        }
        compound.func_74757_a("CustomSearchZone", this.hasCustomSearchZone());
        compound.func_74768_a("SearchRadius", this.getSearchRadius());
        compound.func_74768_a("CookingProgress", this.cookingProgress);
        compound.func_74768_a("DigCooldown", this.digCooldown);
        compound.func_74768_a("BreedCooldown", this.breedCooldown);
        compound.func_74768_a("CoinCooldown", this.coinCooldown);
        compound.func_74768_a("CheeseFeedings", this.cheeseFeedings);
        compound.func_74768_a("TransportingRF", this.getHeldRF());
        compound.func_74768_a("Command", this.getCommandInteger());
        compound.func_74768_a("ColorVariant", this.getColorVariant());
        compound.func_74757_a("Plague", this.hasPlague());
        compound.func_74757_a("VisualFlag", this.getVisualFlag());
        compound.func_74757_a("Dancing", this.isDancing());
        compound.func_74757_a("Toga", this.hasToga());
        compound.func_74757_a("OwnerMonster", this.isOwnerMonster());
        compound.func_74757_a("IsMale", this.isMale());
        compound.func_74768_a("WildTrust", this.wildTrust);
        if (this.ratInventory != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.ratInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.ratInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        compound.func_74768_a("EatenItems", this.eatenItems);
        if (this.pickupPos != null) {
            compound.func_74768_a("PickupPosX", this.pickupPos.func_177958_n());
            compound.func_74768_a("PickupPosY", this.pickupPos.func_177956_o());
            compound.func_74768_a("PickupPosZ", this.pickupPos.func_177952_p());
        }
        if (this.depositPos != null) {
            compound.func_74768_a("DepositPosX", this.depositPos.func_177958_n());
            compound.func_74768_a("DepositPosY", this.depositPos.func_177956_o());
            compound.func_74768_a("DepositPosZ", this.depositPos.func_177952_p());
            compound.func_74768_a("DepositFacing", this.depositFacing.ordinal());
        }
        if (this.transportingFluid != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            this.transportingFluid.writeToNBT(fluidTag);
            compound.func_74782_a("TransportingFluid", (NBTBase)fluidTag);
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.func_95999_t());
        }
        if (this.getMonsterOwnerId() == null) {
            compound.func_74778_a("MonsterOwnerUUID", "");
        } else {
            compound.func_74778_a("MonsterOwnerUUID", this.getMonsterOwnerId().toString());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        NBTTagCompound fluidTag;
        NBTTagList nbttaglist;
        super.func_70037_a(compound);
        if (compound.func_74764_b("HomePosX") && compound.func_74764_b("HomePosY") && compound.func_74764_b("HomePosZ")) {
            this.func_175449_a(new BlockPos(compound.func_74762_e("HomePosX"), compound.func_74762_e("HomePosY"), compound.func_74762_e("HomePosZ")), compound.func_74762_e("HomeDistance"));
        }
        if (compound.func_74764_b("RadiusPosX") && compound.func_74764_b("RadiusPosY") && compound.func_74764_b("RadiusPosZ")) {
            this.setSearchRadiusCenter(new BlockPos(compound.func_74762_e("RadiusPosX"), compound.func_74762_e("RadiusPosY"), compound.func_74762_e("RadiusPosZ")));
        }
        this.setCustomSearchZone(compound.func_74767_n("CustomSearchZone"));
        this.setSearchRadius(compound.func_74762_e("SearchRadius"));
        this.cookingProgress = compound.func_74762_e("CookingProgress");
        this.digCooldown = compound.func_74762_e("DigCooldown");
        this.breedCooldown = compound.func_74762_e("BreedCooldown");
        this.coinCooldown = compound.func_74762_e("CoinCooldown");
        this.wildTrust = compound.func_74762_e("WildTrust");
        this.eatenItems = compound.func_74762_e("EatenItems");
        this.cheeseFeedings = compound.func_74762_e("CheeseFeedings");
        this.setHeldRF(compound.func_74762_e("TransportingRF"));
        this.setCommandInteger(compound.func_74762_e("Command"));
        this.setPlague(compound.func_74767_n("Plague"));
        this.setDancing(compound.func_74767_n("Dancing"));
        this.setVisualFlag(compound.func_74767_n("VisualFlag"));
        this.setToga(compound.func_74767_n("Toga"));
        this.setMale(compound.func_74767_n("IsMale"));
        this.setOwnerMonster(compound.func_74767_n("OwnerMonster"));
        this.setColorVariant(compound.func_74762_e("ColorVariant"));
        if (this.ratInventory != null) {
            nbttaglist = compound.func_150295_c("Items", 10);
            this.initInventory();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j > 4) continue;
                this.ratInventory.func_70299_a(j, new ItemStack(nbttagcompound));
            }
        } else {
            nbttaglist = compound.func_150295_c("Items", 10);
            this.initInventory();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.ratInventory.func_70299_a(j, new ItemStack(nbttagcompound));
            }
        }
        if (compound.func_74764_b("PickupPosX") && compound.func_74764_b("PickupPosY") && compound.func_74764_b("PickupPosZ")) {
            this.pickupPos = new BlockPos(compound.func_74762_e("PickupPosX"), compound.func_74762_e("PickupPosY"), compound.func_74762_e("PickupPosZ"));
        }
        if (compound.func_74764_b("DepositPosX") && compound.func_74764_b("DepositPosY") && compound.func_74764_b("DepositPosZ")) {
            this.depositPos = new BlockPos(compound.func_74762_e("DepositPosX"), compound.func_74762_e("DepositPosY"), compound.func_74762_e("DepositPosZ"));
            if (compound.func_74764_b("DepositFacing")) {
                this.depositFacing = EnumFacing.values()[compound.func_74762_e("DepositFacing")];
            }
        }
        if (compound.func_74764_b("TransportingFluid") && !(fluidTag = compound.func_74775_l("TransportingFluid")).func_82582_d()) {
            this.transportingFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.func_96094_a(compound.func_74779_i("CustomName"));
        }
        if (compound.func_150297_b("MonsterOwnerUUID", 8) && !compound.func_74779_i("MonsterOwnerUUID").equals("")) {
            String s = compound.func_74779_i("MonsterOwnerUUID");
            this.setMonsterOwnerId(UUID.fromString(s));
            this.setOwnerMonster(true);
        }
        this.setupDynamicAI();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || source == DamageSource.field_76368_d && this.func_184218_aH()) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    private int getCommandInteger() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    private void setCommandInteger(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        if (command == RatCommand.SIT.ordinal()) {
            this.func_70904_g(true);
        } else {
            this.func_70904_g(false);
        }
    }

    @Nullable
    public UUID getMonsterOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(MONSTER_OWNER_UNIQUE_ID)).orNull();
    }

    public void setMonsterOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(MONSTER_OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public int getColorVariant() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR_VARIANT);
    }

    public void setColorVariant(int color) {
        this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)color);
    }

    public void setToga(boolean plague) {
        this.field_70180_af.func_187227_b(TOGA, (Object)plague);
    }

    public boolean hasToga() {
        return (Boolean)this.field_70180_af.func_187225_a(TOGA);
    }

    public void setPlague(boolean plague) {
        this.field_70180_af.func_187227_b(PLAGUE, (Object)plague);
    }

    public boolean hasPlague() {
        return (Boolean)this.field_70180_af.func_187225_a(PLAGUE);
    }

    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MALE);
    }

    public void setMale(boolean male) {
        this.field_70180_af.func_187227_b(IS_MALE, (Object)male);
    }

    public boolean getVisualFlag() {
        return (Boolean)this.field_70180_af.func_187225_a(VISUAL_FLAG);
    }

    public void setVisualFlag(boolean flag) {
        this.field_70180_af.func_187227_b(VISUAL_FLAG, (Object)flag);
    }

    public boolean isDancing() {
        return (Boolean)this.field_70180_af.func_187225_a(DANCING);
    }

    public void setDancing(boolean dancing) {
        this.field_70180_af.func_187227_b(DANCING, (Object)dancing);
    }

    public int getDanceMoves() {
        return (Integer)this.field_70180_af.func_187225_a(DANCE_MOVES);
    }

    public void setDanceMoves(int moves) {
        this.field_70180_af.func_187227_b(DANCE_MOVES, (Object)moves);
    }

    public int getHeldRF() {
        return (Integer)this.field_70180_af.func_187225_a(HELD_RF);
    }

    public void setHeldRF(int rf) {
        this.field_70180_af.func_187227_b(HELD_RF, (Object)rf);
    }

    public boolean isOwnerMonster() {
        return (Boolean)this.field_70180_af.func_187225_a(OWNER_NOT_PLAYER);
    }

    public void setOwnerMonster(boolean monster) {
        this.field_70180_af.func_187227_b(OWNER_NOT_PLAYER, (Object)monster);
    }

    public boolean hasCustomSearchZone() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CUSTOM_RADIUS);
    }

    public void setCustomSearchZone(boolean customSearchZone) {
        this.field_70180_af.func_187227_b(HAS_CUSTOM_RADIUS, (Object)customSearchZone);
    }

    public int getSearchRadius() {
        return (Integer)this.field_70180_af.func_187225_a(SEARCH_RADIUS);
    }

    public void setSearchRadius(int radius) {
        this.field_70180_af.func_187227_b(SEARCH_RADIUS, (Object)radius);
    }

    public BlockPos getSearchRadiusCenter() {
        return (BlockPos)this.field_70180_af.func_187225_a(RADIUS_CENTER);
    }

    public void setSearchRadiusCenter(BlockPos radius) {
        if (radius == null) {
            this.setCustomSearchZone(false);
        } else {
            this.setCustomSearchZone(true);
            this.field_70180_af.func_187227_b(RADIUS_CENTER, (Object)radius);
        }
    }

    public boolean shouldWander() {
        int cmd = this.getCommandInteger();
        return cmd != 1 && cmd != 4 && cmd != 5 && cmd != 6;
    }

    public RatCommand getCommand() {
        return RatCommand.values()[MathHelper.func_76125_a((int)this.getCommandInteger(), (int)0, (int)(RatCommand.values().length - 1))];
    }

    public void setCommand(RatCommand command) {
        this.setCommandInteger(command.ordinal());
    }

    public boolean isFollowing() {
        return this.getCommandInteger() == 2;
    }

    public boolean isTargetCommand() {
        return this.getCommandInteger() == 4 || this.getCommandInteger() == 5;
    }

    public boolean isAttackCommand() {
        return this.getCommandInteger() == 0 || this.getCommandInteger() == 2 || this.getCommandInteger() == 3 || this.getCommandInteger() == 7;
    }

    public boolean isHarvestCommand() {
        return this.getCommandInteger() == 4 || this.getCommandInteger() == 5;
    }

    public boolean isItemTargetCommand() {
        return this.getCommandInteger() == 3 || this.getCommandInteger() == 4 || this.getCommandInteger() == 5 || this.getCommandInteger() == 7;
    }

    public EntitySenses getSenses() {
        return this.func_70635_at();
    }

    public boolean isHoldingFood() {
        return !this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && (RatUtils.isRatFood(this.func_184586_b(EnumHand.MAIN_HAND)) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) && ItemRatUpgradeOreDoubling.isProcessable(this.func_184614_ca()));
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            Explosion explosion;
            this.func_174815_a((EntityLivingBase)this, entityIn);
            if (this.hasPlague() && entityIn instanceof EntityLivingBase && this.rollForPlague((EntityLivingBase)entityIn)) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, 6000));
            }
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FERAL_BITE)) {
                entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, 600));
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 600));
            }
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT)) {
                explosion = new Explosion(this.field_70170_p, null, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, 4.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT_SURVIVOR)) {
                explosion = new RatNukeExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, 4.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        }
        return flag;
    }

    public int func_70658_aO() {
        if (this.func_70909_n()) {
            return super.func_70658_aO() * 3;
        }
        return super.func_70658_aO();
    }

    public void func_70636_d() {
        EntityIllagerPiper piper;
        TileEntity te;
        float particleRand;
        double extraY;
        double extraZ;
        boolean holdingInHands;
        float plateau;
        double planeDist;
        this.setRatStatus(RatStatus.IDLE);
        if (!ItemStack.func_179545_c((ItemStack)this.getUpgradeSlot(), (ItemStack)this.prevUpgrade)) {
            this.onUpgradeChanged();
        }
        super.func_70636_d();
        this.prevFlyingPitch = this.flyingPitch;
        if (this.inTube()) {
            if (this.navigatorType != 3) {
                this.switchNavigator(3);
            }
            if (this.climbingTube) {
                this.field_70181_x += 0.1;
            } else if (!this.field_70122_E && this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.6;
            }
            double ydist = this.field_70167_r - this.field_70163_u;
            planeDist = (Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y)) * 12.0;
            this.flyingPitch += (float)ydist * 100.0f;
            this.flyingPitch = MathHelper.func_76131_a((float)this.flyingPitch, (float)-90.0f, (float)90.0f);
            plateau = 2.0f;
            if (this.flyingPitch > plateau) {
                this.flyingPitch = (float)((double)this.flyingPitch - planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
            }
            if (this.flyingPitch < -plateau) {
                this.flyingPitch = (float)((double)this.flyingPitch + planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
            }
            if (this.flyingPitch > 2.0f) {
                this.flyingPitch -= this.field_70122_E ? Math.max(this.flyingPitch, 10.0f) : 1.0f;
            }
            if (this.flyingPitch < -2.0f) {
                this.flyingPitch += this.field_70122_E ? Math.max(this.flyingPitch, 10.0f) : 1.0f;
            }
            if (this.flyingPitch < 1.0f && this.flyingPitch > -1.0f && this.field_70122_E) {
                this.flyingPitch = 0.0f;
            }
        } else if (this.hasFlight() && !this.func_70090_H()) {
            if (this.navigatorType != 2) {
                this.switchNavigator(2);
            }
            if (this.canMove()) {
                if (this.func_70605_aq().func_179919_e() > this.field_70163_u) {
                    this.field_70181_x += (double)0.08f;
                }
            } else if (!this.field_70122_E) {
                this.field_70181_x -= (double)0.08f;
            }
            if (!this.field_70122_E) {
                double ydist = this.field_70167_r - this.field_70163_u;
                planeDist = (Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y)) * 12.0;
                this.flyingPitch += (float)ydist * 20.0f;
                this.flyingPitch = MathHelper.func_76131_a((float)this.flyingPitch, (float)-90.0f, (float)90.0f);
                plateau = 2.0f;
                if (this.flyingPitch > plateau) {
                    this.flyingPitch = (float)((double)this.flyingPitch - planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
                }
                if (this.flyingPitch < -plateau) {
                    this.flyingPitch = (float)((double)this.flyingPitch + planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
                }
                if (this.flyingPitch > 2.0f) {
                    this.flyingPitch -= 1.0f;
                } else if (this.flyingPitch < -2.0f) {
                    this.flyingPitch += 1.0f;
                }
            } else {
                this.flyingPitch = 0.0f;
            }
        } else if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AQUATIC) && this.func_70090_H()) {
            if (this.navigatorType != 4) {
                this.switchNavigator(4);
            }
            if (this.canMove()) {
                if (this.func_70605_aq().func_179919_e() > this.field_70163_u) {
                    this.field_70181_x += (double)0.08f;
                }
            } else if (!this.field_70122_E) {
                this.field_70181_x -= (double)0.08f;
            }
            if (!this.field_70122_E) {
                double ydist = this.field_70167_r - this.field_70163_u;
                planeDist = (Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y)) * 12.0;
                this.flyingPitch += (float)ydist * 20.0f;
                this.flyingPitch = MathHelper.func_76131_a((float)this.flyingPitch, (float)-90.0f, (float)90.0f);
                plateau = 2.0f;
                if (this.flyingPitch > plateau) {
                    this.flyingPitch = (float)((double)this.flyingPitch - planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
                }
                if (this.flyingPitch < -plateau) {
                    this.flyingPitch = (float)((double)this.flyingPitch + planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
                }
                if (this.flyingPitch > 2.0f) {
                    this.flyingPitch -= 1.0f;
                } else if (this.flyingPitch < -2.0f) {
                    this.flyingPitch += 1.0f;
                }
            } else {
                this.flyingPitch = 0.0f;
            }
        } else {
            boolean wildNavigate;
            if (!this.inTube()) {
                this.flyingPitch = 0.0f;
            }
            boolean bl = wildNavigate = !this.func_70909_n() || this.isInCage();
            if (wildNavigate && this.navigatorType != 1) {
                this.switchNavigator(1);
            }
            if (!wildNavigate && this.navigatorType != 0) {
                this.switchNavigator(0);
            }
        }
        if (this.breedCooldown > 0) {
            --this.breedCooldown;
        }
        if (this.isMoving()) {
            this.setRatStatus(RatStatus.MOVING);
        }
        boolean sitting = this.func_70906_o() || this.func_184218_aH() || this.isDancing() || (this.getAnimation() == ANIMATION_IDLE_SCRATCH || this.getAnimation() == ANIMATION_IDLE_SNIFF) && this.shouldSitDuringAnimation();
        float sitInc = this.getAnimation() == ANIMATION_IDLE_SCRATCH || this.getAnimation() == ANIMATION_IDLE_SNIFF ? 5.0f : 1.0f;
        boolean bl = holdingInHands = !sitting && (!this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && (!this.holdInMouth || this.cookingProgress > 0) || this.getAnimation() == ANIMATION_EAT || this.holdsItemInHandUpgrade() || this.getMBTransferRate() > 0);
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += sitInc;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= sitInc;
        }
        if (holdingInHands && this.holdProgress < 5.0f) {
            this.holdProgress += 0.5f;
        } else if (!holdingInHands && this.holdProgress > 0.0f) {
            this.holdProgress -= 0.5f;
        }
        boolean inTrap = this.isDeadInTrap;
        if (inTrap && this.deadInTrapProgress < 5.0f) {
            this.deadInTrapProgress += 1.0f;
        } else if (!inTrap && this.deadInTrapProgress > 0.0f) {
            this.deadInTrapProgress -= 1.0f;
        }
        if (this.digCooldown <= 0 && RatsMod.CONFIG_OPTIONS.ratsDigBlocks && !this.func_70909_n()) {
            this.findDigTarget();
            this.digTarget();
        }
        if (this.getCommand() == RatCommand.SIT && !this.func_70906_o()) {
            this.func_70904_g(true);
        }
        if (this.func_70906_o() && this.getCommand() != RatCommand.SIT) {
            this.func_70904_g(false);
        }
        if (this.getAnimation() == ANIMATION_EAT && this.isHoldingFood() && this.eatingTicks <= 40) {
            ++this.eatingTicks;
            this.eatItem(this.func_184586_b(EnumHand.MAIN_HAND), 3);
            if (this.eatingTicks == 40) {
                ItemStack pooStack = new ItemStack(RatsItemRegistry.RAT_NUGGET);
                ItemStack eatenFood = this.func_184586_b(EnumHand.MAIN_HAND).func_77946_l();
                if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) && ItemRatUpgradeOreDoubling.isProcessable(this.func_184586_b(EnumHand.MAIN_HAND))) {
                    pooStack = new ItemStack(RatsItemRegistry.RAT_NUGGET_ORE, 2, RatsNuggetRegistry.getNuggetMeta(this.func_184586_b(EnumHand.MAIN_HAND)));
                    NBTTagCompound poopTag = new NBTTagCompound();
                    NBTTagCompound oreTag = new NBTTagCompound();
                    ItemRatUpgradeOreDoubling.getProcessedOre(this.func_184586_b(EnumHand.MAIN_HAND)).func_77955_b(oreTag);
                    NBTTagCompound ingotTag = new NBTTagCompound();
                    ItemRatUpgradeOreDoubling.getProcessedIngot(this.func_184586_b(EnumHand.MAIN_HAND)).func_77955_b(ingotTag);
                    poopTag.func_74782_a("OreItem", (NBTBase)oreTag);
                    poopTag.func_74782_a("IngotItem", (NBTBase)ingotTag);
                    pooStack.func_77982_d(poopTag);
                }
                this.func_184586_b(EnumHand.MAIN_HAND).func_190918_g(1);
                if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) || this.field_70146_Z.nextFloat() <= 0.05f && this.func_70909_n()) {
                    if (RatsMod.CONFIG_OPTIONS.ratFartNoises) {
                        this.func_184185_a(RatsSoundRegistry.RAT_POOP, 0.5f + this.field_70146_Z.nextFloat() * 0.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.5f);
                    }
                    if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) && this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                        ItemStack oneStack = pooStack.func_77946_l();
                        oneStack.func_190920_e(1);
                        this.func_184611_a(EnumHand.MAIN_HAND, oneStack);
                        pooStack.func_190918_g(1);
                    }
                    if (pooStack.func_190916_E() > 0 && !this.field_70170_p.field_72995_K) {
                        this.func_70099_a(pooStack, 0.0f);
                    }
                }
                int healAmount = 1;
                if (eatenFood.func_77973_b() instanceof ItemFood) {
                    healAmount = ((ItemFood)eatenFood.func_77973_b()).func_150905_g(eatenFood);
                }
                this.func_70691_i(healAmount);
                this.eatingTicks = 0;
            }
        }
        if (this.isHoldingFood() && (this.func_70681_au().nextInt(20) == 0 || this.eatingTicks > 0) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHEF) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS) && (this.getCommand() != RatCommand.TRANSPORT && this.getCommand() != RatCommand.GATHER && this.getCommand() != RatCommand.HARVEST && this.getCommand() != RatCommand.HUNT_ANIMALS && this.getCommand() != RatCommand.HUNT_MONSTERS || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) && ItemRatUpgradeOreDoubling.isProcessable(this.func_184614_ca())) && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) || this.shouldDepositItem(this.func_184614_ca()))) {
            this.setAnimation(ANIMATION_EAT);
            this.setRatStatus(RatStatus.EATING);
        }
        if (this.hasPlague() && this.field_70146_Z.nextFloat() < 0.3f) {
            double d0 = 0.0;
            double d1 = this.field_70146_Z.nextGaussian() * 0.05 + 0.5;
            double d2 = 0.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHEF) && !this.func_184614_ca().func_190926_b()) {
            this.tryCooking();
            if (this.cookingProgress > 0) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.cookingProgress == 99) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                } else {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    if (this.field_70146_Z.nextFloat() < 0.125f) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    }
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARCHEOLOGIST) && !this.func_184614_ca().func_190926_b()) {
            this.tryArcheology();
            if (this.cookingProgress > 0) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.cookingProgress == 99) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                } else {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[]{Block.func_149682_b((Block)RatsBlockRegistry.GARBAGE_PILE)});
                    if (this.field_70146_Z.nextFloat() < 0.125f) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    }
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GEMCUTTER) && !this.func_184614_ca().func_190926_b()) {
            this.tryGemcutter();
            if (this.cookingProgress > 0) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.cookingProgress == 99) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                } else {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[]{Block.func_149682_b((Block)Blocks.field_150482_ag)});
                }
            }
        }
        if ((this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENCHANTER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DISENCHANTER)) && !this.func_184614_ca().func_190926_b()) {
            this.tryEnchanting(this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DISENCHANTER));
            if (this.cookingProgress > 0) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.cookingProgress == 999) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                } else {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS)) {
            this.tryGiftgiving();
            if (this.cookingProgress > 0 && this.cookingProgress == 23999) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)126);
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARISTOCRAT)) {
            if (this.coinCooldown <= 0) {
                this.coinCooldown = this.field_70146_Z.nextInt(6000) + 6000;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(new ItemStack(RatsItemRegistry.TINY_COIN, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                }
                this.func_184185_a(SoundEvents.field_187665_Y, this.func_70599_aP(), this.func_70647_i());
            } else {
                --this.coinCooldown;
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENDER)) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70661_as().func_75505_d() != null && this.func_70661_as().func_75505_d().func_75870_c() != null && !this.func_184218_aH()) {
                    Vec3d target = new Vec3d((double)this.func_70661_as().func_75505_d().func_75870_c().field_75839_a, (double)this.func_70661_as().func_75505_d().func_75870_c().field_75837_b, (double)this.func_70661_as().func_75505_d().func_75870_c().field_75838_c);
                    if (this.func_70092_e(target.field_72450_a, target.field_72448_b, target.field_72449_c) > 20.0 || !this.isDirectPathBetweenPoints(target)) {
                        this.func_184595_k(target.field_72450_a, target.field_72448_b, target.field_72449_c);
                    }
                }
            } else {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
        if (this.field_70170_p.field_72995_K && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FERAL_BITE) && this.func_70681_au().nextInt(5) == 0) {
            float sitAddition = 0.125f * (this.sitProgress / 20.0f);
            float radius = 0.3f - sitAddition;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.field_70165_t;
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.field_70161_v;
            extraY = 0.125 + this.field_70163_u + (double)sitAddition;
            particleRand = 0.1f;
            RatsMod.PROXY.spawnParticle("saliva", extraX + (double)(this.field_70146_Z.nextFloat() * particleRand * 2.0f) - (double)particleRand, extraY, extraZ + (double)(this.field_70146_Z.nextFloat() * particleRand * 2.0f) - (double)particleRand, 0.0, 0.0, 0.0);
        }
        if (this.field_70170_p.field_72995_K && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PSYCHIC) && this.func_70681_au().nextInt(5) == 0) {
            float sitAddition = 0.125f * (this.sitProgress / 20.0f);
            float radius = 0.45f - sitAddition;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.field_70165_t;
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.field_70161_v;
            extraY = 0.12 + this.field_70163_u + (double)sitAddition;
            particleRand = 0.4f;
            RatsMod.PROXY.spawnParticle("rat_lightning", extraX + (double)(this.field_70146_Z.nextFloat() * particleRand * 2.0f) - (double)particleRand, extraY, extraZ + (double)(this.field_70146_Z.nextFloat() * particleRand * 2.0f) - (double)particleRand, 0.0, 0.0, 0.0);
        }
        if (this.isInCage() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (this.func_70909_n() && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CRAFTING) && (te = this.field_70170_p.func_175625_s(new BlockPos((Entity)this).func_177977_b())) != null && te instanceof TileEntityRatCraftingTable && !this.field_70170_p.field_72995_K) {
            TileEntityRatCraftingTable ratCraftingTable = (TileEntityRatCraftingTable)te;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            if (ratCraftingTable.func_174887_a_(0) > 0) {
                this.crafting = true;
                this.field_70170_p.func_72960_a((Entity)this, (byte)85);
                ItemStack stack = ratCraftingTable.func_70301_a(0);
                if (stack.func_190926_b()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                } else {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[]{Item.func_150891_b((Item)stack.func_77973_b())});
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[]{Item.func_150891_b((Item)stack.func_77973_b())});
                }
                if (ratCraftingTable.prevCookTime % 20 == 0) {
                    this.func_184185_a(CRAFTING_SOUNDS[this.field_70146_Z.nextInt(CRAFTING_SOUNDS.length - 1)], 0.6f, 0.75f + this.field_70146_Z.nextFloat());
                }
            } else {
                this.crafting = false;
                this.field_70170_p.func_72960_a((Entity)this, (byte)86);
            }
            if (ratCraftingTable.prevCookTime == 199) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
                this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getRatStatus() == RatStatus.IDLE && this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && this.getAnimation() == NO_ANIMATION && this.func_70681_au().nextInt(350) == 0 && this.shouldNotIdleAnimation()) {
            this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_IDLE_SNIFF : ANIMATION_IDLE_SCRATCH);
        }
        if (!this.field_70170_p.field_72995_K && this.isOwnerMonster() && this.getOwnerMonster() instanceof EntityIllagerPiper && (piper = (EntityIllagerPiper)this.getOwnerMonster()).func_70638_az() != null) {
            this.func_70624_b(piper.func_70638_az());
        }
        if (!this.field_70170_p.field_72995_K && this.isOwnerMonster() && this.getOwnerMonster() instanceof EntityBlackDeath) {
            EntityBlackDeath death = (EntityBlackDeath)this.getOwnerMonster();
            if (death.func_70638_az() != null && death.func_70638_az().func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() != RatsItemRegistry.BLACK_DEATH_MASK) {
                this.func_70624_b(death.func_70638_az());
            }
            if (this.func_70638_az() == null || this.func_70638_az().field_70128_L) {
                float radius = 5.0f - (float)Math.sin((double)death.field_70173_aa * 0.4) * 0.5f;
                int maxRatStuff = 360 / Math.max(death.getRatsSummoned(), 1);
                int ratIndex = this.func_145782_y() % Math.max(death.getRatsSummoned(), 1);
                float angle = (float)Math.PI / 180 * ((float)(ratIndex * maxRatStuff) + (float)this.field_70173_aa * 4.1f);
                double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + death.field_70165_t;
                double extraZ2 = (double)(radius * MathHelper.func_76134_b((float)angle)) + death.field_70161_v;
                BlockPos runToPos = new BlockPos(extraX, death.field_70163_u, extraZ2);
                for (int steps = 0; this.field_70170_p.func_180495_p(runToPos).func_185914_p() && steps < 10; ++steps) {
                    runToPos = runToPos.func_177984_a();
                }
                this.func_70661_as().func_75492_a(extraX, (double)runToPos.func_177956_o(), extraZ2, (double)1.33f);
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NONBELIEVER) && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 30 == 0) {
            this.func_70691_i(1.0f);
        }
        if ((this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_VOODOO) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PSYCHIC)) && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 30 == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PSYCHIC) && this.rangedAttackCooldownPsychic == 0 && this.func_70638_az() != null) {
            if (this.field_70146_Z.nextBoolean()) {
                this.rangedAttackCooldownPsychic = 50;
                BlockPos ourPos = new BlockPos((Entity)this);
                int searchRange = 10;
                ArrayList<BlockPos> listOfAll = new ArrayList<BlockPos>();
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)ourPos.func_177982_a(-searchRange, -searchRange, -searchRange), (BlockPos)ourPos.func_177982_a(searchRange, searchRange, searchRange))) {
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (this.field_70170_p.func_175623_d(pos) || !EntityWither.func_181033_a((Block)state.func_177230_c())) continue;
                    listOfAll.add(pos);
                }
                if (listOfAll.size() > 0) {
                    BlockPos pos = (BlockPos)listOfAll.get(this.field_70146_Z.nextInt(listOfAll.size()));
                    EntityThrownBlock thrownBlock = new EntityThrownBlock(this.field_70170_p, this.field_70170_p.func_180495_p(pos), (EntityLivingBase)this);
                    thrownBlock.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    thrownBlock.dropBlock = false;
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)thrownBlock);
                    }
                    RatsMod.NETWORK_WRAPPER.sendToAll((IMessage)new MessageSyncThrownBlock(thrownBlock.func_145782_y(), pos.func_177986_g()));
                } else {
                    this.rangedAttackCooldownPsychic = 5;
                }
            } else {
                this.rangedAttackCooldownPsychic = 100;
                int bounds = 5;
                for (int i = 0; i < this.field_70146_Z.nextInt(2) + 1; ++i) {
                    EntityLaserPortal laserPortal = new EntityLaserPortal(this.field_70170_p, this.func_70638_az().field_70165_t + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, this.field_70163_u + 2.0, this.func_70638_az().field_70161_v + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, (EntityLivingBase)this);
                    this.field_70170_p.func_72838_d((Entity)laserPortal);
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BUCCANEER)) {
            if (this.getVisualFlag() && this.visualCooldown == 0) {
                this.setVisualFlag(false);
            }
            if (this.rangedAttackCooldownCannon == 0 && this.func_70638_az() != null) {
                this.rangedAttackCooldownCannon = 60;
                EntityCheeseCannonball cannonball = new EntityCheeseCannonball(this.field_70170_p, (EntityLivingBase)this);
                cannonball.field_184539_c = this;
                double extraY2 = 0.6 + this.field_70163_u;
                double d0 = this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e() - (double)1.1f;
                double d1 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d3 = this.func_70638_az().field_70161_v - this.field_70161_v;
                double d2 = d0 - extraY2;
                float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
                cannonball.func_70107_b(this.field_70165_t, extraY2, this.field_70161_v);
                cannonball.func_70186_c(d1, d2 + (double)f, d3, 0.75f, 0.4f);
                this.setVisualFlag(true);
                this.visualCooldown = 4;
                this.func_184185_a(SoundEvents.field_187539_bB, 3.0f, 2.3f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)cannonball);
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON)) {
            if (this.getVisualFlag() && this.visualCooldown == 0) {
                this.setVisualFlag(false);
            }
            if (this.rangedAttackCooldownDragon == 0 && this.func_70638_az() != null) {
                this.rangedAttackCooldownDragon = 5;
                float radius = 0.3f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq;
                double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.field_70165_t;
                double extraZ3 = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.field_70161_v;
                double extraY3 = 0.2 + this.field_70163_u;
                double targetRelativeX = this.func_70638_az().field_70165_t - extraX;
                double targetRelativeY = this.func_70638_az().field_70163_u + (double)(this.func_70638_az().field_70131_O / 2.0f) - extraY3;
                double targetRelativeZ = this.func_70638_az().field_70161_v - extraZ3;
                this.func_184185_a(SoundEvents.field_187616_bj, 1.0f, 1.25f + this.field_70146_Z.nextFloat() * 0.5f);
                EntityRatDragonFire beam = new EntityRatDragonFire(this.field_70170_p, (EntityLivingBase)this, targetRelativeX, targetRelativeY, targetRelativeZ);
                beam.func_70107_b(extraX, extraY3, extraZ3);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)beam);
                }
            }
            this.func_70066_B();
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR) && this.rangedAttackCooldownLaser == 0 && this.func_70638_az() != null) {
            this.rangedAttackCooldownLaser = 10;
            float radius = 0.3f;
            for (int i = 0; i < 2; ++i) {
                float angle = (float)Math.PI / 180 * (this.field_70761_aq + (float)(i == 0 ? 90 : -90));
                double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.field_70165_t;
                extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.field_70161_v;
                extraY = 0.2 + this.field_70163_u;
                double targetRelativeX = this.func_70638_az().field_70165_t - extraX;
                double targetRelativeY = this.func_70638_az().field_70163_u + (double)(this.func_70638_az().field_70131_O / 2.0f) - extraY;
                double targetRelativeZ = this.func_70638_az().field_70161_v - extraZ;
                this.func_184185_a(RatsSoundRegistry.LASER, 1.0f, 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
                EntityLaserBeam beam = new EntityLaserBeam(this.field_70170_p, (EntityLivingBase)this);
                beam.setRGB(1.0f, 0.0f, 0.0f);
                beam.func_70239_b(2.0);
                beam.func_70107_b(extraX, extraY, extraZ);
                beam.func_70186_c(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.4f);
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_72838_d((Entity)beam);
            }
        }
        if (this.rangedAttackCooldownCannon > 0) {
            --this.rangedAttackCooldownCannon;
        }
        if (this.rangedAttackCooldownLaser > 0) {
            --this.rangedAttackCooldownLaser;
        }
        if (this.rangedAttackCooldownPsychic > 0) {
            --this.rangedAttackCooldownPsychic;
        }
        if (this.rangedAttackCooldownDragon > 0) {
            --this.rangedAttackCooldownDragon;
        }
        if (this.visualCooldown > 0) {
            --this.visualCooldown;
        }
        this.prevUpgrade = this.getUpgradeSlot();
        if (!this.field_70170_p.field_72995_K) {
            this.inCage = this.inCageLogic();
        }
        if (this.func_70909_n()) {
            this.inTube = this.inTubeLogic();
        }
        if (this.poopCooldown > 0) {
            --this.poopCooldown;
        }
        if (this.getHeldRF() > 0 && this.field_70146_Z.nextFloat() < 0.1f && this.getRFTransferRate() > 0) {
            this.func_184185_a(RatsSoundRegistry.NEORATLANTEAN_IDLE, this.func_70599_aP(), 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.isDancing() && this.getAnimation() != this.getDanceAnimation()) {
            this.setAnimation(this.getDanceAnimation());
        }
        if (this.isDancing() && (this.jukeboxPos == null || this.jukeboxPos.func_177954_c(this.field_70165_t, this.field_70163_u, this.field_70161_v) > 225.0 || this.field_70170_p.func_180495_p(this.jukeboxPos).func_177230_c() != Blocks.field_150421_aI)) {
            this.setDancing(false);
        }
    }

    private boolean inCageLogic() {
        return this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockRatCage;
    }

    private boolean shouldSitDuringAnimation() {
        return !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS);
    }

    public void createBabiesFrom(EntityRat mother, EntityRat father) {
        for (int i = 0; i < 1; ++i) {
            EntityRat baby = new EntityRat(this.field_70170_p);
            baby.setMale(this.field_70146_Z.nextBoolean());
            int babyColor = 0;
            babyColor = father.getColorVariant() <= 3 && mother.getColorVariant() <= 3 ? (this.field_70146_Z.nextInt(6) == 0 ? 4 + this.field_70146_Z.nextInt(RAT_TEXTURES.length - 5) : this.field_70146_Z.nextInt(4)) : this.field_70146_Z.nextInt(RAT_TEXTURES.length);
            baby.setColorVariant(babyColor);
            baby.func_70107_b(mother.field_70165_t, mother.field_70163_u, mother.field_70161_v);
            baby.func_70873_a(-24000);
            if (mother.func_70909_n()) {
                baby.func_70903_f(true);
                baby.func_184754_b(mother.func_184753_b());
                baby.setOwnerMonster(false);
            } else if (father.func_70909_n()) {
                baby.func_70903_f(true);
                baby.func_184754_b(father.func_184753_b());
                baby.setOwnerMonster(false);
            }
            this.field_70170_p.func_72838_d((Entity)baby);
        }
    }

    public boolean func_70067_L() {
        return !this.func_184218_aH() || !(this.func_184187_bx() instanceof EntityPlayer);
    }

    public ItemStack getCookingResultFor(ItemStack stack) {
        ItemStack burntItem = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
        SharedRecipe recipe = RatsRecipeRegistry.getRatChefRecipe(stack);
        if (recipe != null) {
            burntItem = recipe.getOutput().func_77946_l();
        }
        return burntItem;
    }

    public ItemStack getArcheologyResultFor(ItemStack stack) {
        SharedRecipe recipe = RatsRecipeRegistry.getArcheologistRecipe(stack);
        if (recipe != null) {
            return recipe.getOutput().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getGemcutterResultFor(ItemStack stack) {
        SharedRecipe recipe = RatsRecipeRegistry.getGemcutterRecipe(stack);
        if (recipe != null) {
            return recipe.getOutput().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private void tryArcheology() {
        ItemStack heldItem = this.func_184614_ca();
        ItemStack burntItem = this.getArcheologyResultFor(heldItem);
        if (burntItem.func_190926_b()) {
            this.cookingProgress = 0;
        } else {
            ++this.cookingProgress;
            if (this.cookingProgress == 100) {
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    this.func_184611_a(EnumHand.MAIN_HAND, burntItem);
                } else if (!this.tryDepositItemInContainers(burntItem) && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(burntItem, 0.25f);
                }
                this.cookingProgress = 0;
            }
        }
    }

    private void tryCooking() {
        ItemStack heldItem = this.func_184614_ca();
        ItemStack burntItem = this.getCookingResultFor(heldItem);
        if (burntItem.func_190926_b()) {
            this.cookingProgress = 0;
        } else {
            ++this.cookingProgress;
            if (this.cookingProgress == 100) {
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    this.func_184611_a(EnumHand.MAIN_HAND, burntItem);
                } else if (!this.tryDepositItemInContainers(burntItem) && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(burntItem, 0.25f);
                }
                this.cookingProgress = 0;
            }
        }
    }

    private void tryGemcutter() {
        ItemStack heldItem = this.func_184614_ca();
        ItemStack burntItem = this.getGemcutterResultFor(heldItem);
        if (burntItem.func_190926_b()) {
            this.cookingProgress = 0;
        } else {
            ++this.cookingProgress;
            if (this.cookingProgress == 100) {
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    this.func_184611_a(EnumHand.MAIN_HAND, burntItem);
                } else if (!this.tryDepositItemInContainers(burntItem) && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(burntItem, 0.25f);
                }
                this.cookingProgress = 0;
            }
        }
    }

    private void tryEnchanting(boolean disenchant) {
        ItemStack heldItem = this.func_184614_ca();
        ItemStack burntItem = ItemStack.field_190927_a;
        if (heldItem.func_77973_b() == Items.field_151122_aG && !disenchant) {
            burntItem = heldItem.func_77946_l();
        }
        if (heldItem.func_77973_b() == Items.field_151134_bR && disenchant) {
            burntItem = new ItemStack(Items.field_151122_aG, heldItem.func_190916_E(), heldItem.func_77960_j());
        }
        if (heldItem.func_77956_u() && !disenchant && !heldItem.func_77948_v()) {
            burntItem = heldItem.func_77946_l();
        }
        if (disenchant && heldItem.func_77948_v() && (burntItem = heldItem.func_77946_l()).func_77978_p() != null && burntItem.func_77978_p().func_150297_b("ench", 9) && !burntItem.func_77978_p().func_150295_c("ench", 10).func_82582_d()) {
            burntItem.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagCompound());
        }
        if (burntItem.func_190926_b()) {
            this.cookingProgress = 0;
        } else {
            ++this.cookingProgress;
            if (this.cookingProgress == 1000) {
                heldItem.func_190918_g(1);
                if (!disenchant) {
                    float power = 0.0f;
                    BlockPos position = this.func_180425_c();
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (j == 0 && k == 0 || !this.field_70170_p.func_175623_d(position.func_177982_a(k, 0, j)) || !this.field_70170_p.func_175623_d(position.func_177982_a(k, 1, j))) continue;
                            power += ForgeHooks.getEnchantPower((World)this.field_70170_p, (BlockPos)position.func_177982_a(k * 2, 0, j * 2));
                            power += ForgeHooks.getEnchantPower((World)this.field_70170_p, (BlockPos)position.func_177982_a(k * 2, 1, j * 2));
                            if (k == 0 || j == 0) continue;
                            power += ForgeHooks.getEnchantPower((World)this.field_70170_p, (BlockPos)position.func_177982_a(k * 2, 0, j));
                            power += ForgeHooks.getEnchantPower((World)this.field_70170_p, (BlockPos)position.func_177982_a(k * 2, 1, j));
                            power += ForgeHooks.getEnchantPower((World)this.field_70170_p, (BlockPos)position.func_177982_a(k, 0, j * 2));
                            power += ForgeHooks.getEnchantPower((World)this.field_70170_p, (BlockPos)position.func_177982_a(k, 1, j * 2));
                        }
                    }
                    burntItem = EnchantmentHelper.func_77504_a((Random)this.func_70681_au(), (ItemStack)burntItem, (int)((int)(2.0f + (float)this.func_70681_au().nextInt(2) + power)), (boolean)false);
                }
                if (heldItem.func_190926_b()) {
                    this.func_184611_a(EnumHand.MAIN_HAND, burntItem);
                } else if (!this.tryDepositItemInContainers(burntItem) && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(burntItem, 0.25f);
                }
                this.cookingProgress = 0;
            }
        }
    }

    private void tryGiftgiving() {
        ItemStack heldItem = this.func_184614_ca();
        boolean held = false;
        boolean luck = true;
        List result = new ArrayList();
        if (!this.field_70170_p.field_72995_K) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p);
            lootcontext$builder.func_186469_a((float)luck).func_186472_a((Entity)this);
            result = this.field_70170_p.func_184146_ak().func_186521_a(CHRISTMAS_LOOT).func_186462_a(this.func_70681_au(), lootcontext$builder.func_186471_a());
            if (result.isEmpty()) {
                this.cookingProgress = 0;
            } else {
                ++this.cookingProgress;
                if (this.cookingProgress >= 24000) {
                    for (ItemStack stack : result) {
                        if (heldItem.func_190926_b() && !held) {
                            this.func_184611_a(EnumHand.MAIN_HAND, stack.func_77946_l());
                            held = true;
                            continue;
                        }
                        if (this.tryDepositItemInContainers(stack.func_77946_l()) || this.field_70170_p.field_72995_K) continue;
                        this.func_70099_a(stack.func_77946_l(), 0.25f);
                    }
                    this.cookingProgress = 0;
                }
            }
        }
    }

    private boolean tryDepositItemInContainers(ItemStack burntItem) {
        TileEntity te;
        IItemHandler handler;
        if (this.field_70170_p.func_175625_s(new BlockPos((Entity)this)) != null && (handler = (IItemHandler)(te = this.field_70170_p.func_175625_s(new BlockPos((Entity)this))).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null && ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)burntItem, (boolean)true).func_190926_b()) {
            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)burntItem, (boolean)false);
            return true;
        }
        return false;
    }

    protected void eatItem(ItemStack stack, int eatingParticleCount) {
        if (!stack.func_190926_b()) {
            if (stack.func_77975_n() == EnumAction.DRINK) {
                this.func_184185_a(SoundEvents.field_187664_bz, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (RatUtils.isRatFood(stack) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING)) {
                for (int i = 0; i < eatingParticleCount; ++i) {
                    Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                    vec3d = vec3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                    vec3d = vec3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
                    Vec3d vec3d1 = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, d0, 0.1);
                    vec3d1 = vec3d1.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                    vec3d1 = vec3d1.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    vec3d1 = vec3d1.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                    if (stack.func_77981_g()) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j()});
                        continue;
                    }
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b())});
                }
                this.func_184185_a(SoundEvents.field_187537_bA, 0.25f + 0.25f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.3f);
            }
        }
    }

    private void digTarget() {
        if (this.diggingPos != null) {
            ++this.breakingTime;
            int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
            this.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            this.field_70179_y *= 0.0;
            this.field_70159_w *= 0.0;
            if (this.breakingTime % 40 == 0) {
                this.func_184185_a(RatsSoundRegistry.RAT_DIG, this.func_70599_aP(), this.func_70647_i());
            }
            if (i != this.previousBreakProgress) {
                this.field_70170_p.func_175715_c(this.func_145782_y(), this.diggingPos, i);
                this.previousBreakProgress = i;
            }
            if (this.breakingTime == 160) {
                TileEntity tileentity1;
                this.breakingTime = 0;
                this.previousBreakProgress = -1;
                IBlockState prevState = this.field_70170_p.func_180495_p(this.diggingPos);
                double d1 = (this.finalDigPathPoint == null ? this.field_70165_t : (double)this.finalDigPathPoint.func_177958_n()) - (double)this.diggingPos.func_177958_n();
                double d2 = (this.finalDigPathPoint == null ? this.field_70161_v : (double)this.finalDigPathPoint.func_177952_p()) - (double)this.diggingPos.func_177952_p();
                float rotation = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                EnumFacing facing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(rotation * 4.0f / 360.0f) + 0.5)) & 3));
                this.field_70170_p.func_175656_a(this.diggingPos, RatsBlockRegistry.RAT_HOLE.func_176223_P());
                if (this.field_70170_p.func_180495_p(this.diggingPos).func_177230_c() instanceof BlockRatHole && (tileentity1 = this.field_70170_p.func_175625_s(this.diggingPos)) instanceof TileEntityRatHole) {
                    ((TileEntityRatHole)tileentity1).setImmitatedBlockState(prevState);
                }
                this.digCooldown = 3000;
                this.diggingPos = null;
            }
            if (this.diggingPos != null && this.func_174818_b(this.diggingPos) > 2.0) {
                this.breakingTime = 0;
                this.previousBreakProgress = -1;
                this.field_70170_p.func_175715_c(this.func_145782_y(), this.diggingPos, 0);
                this.diggingPos = null;
            }
        } else {
            this.breakingTime = 0;
            this.previousBreakProgress = -1;
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(this.isInRatHole() || this.crafting || this.inTube())) {
            entityIn.func_70108_f((Entity)this);
        }
        if (this.hasPlague()) {
            if (entityIn instanceof EntityRat && !((EntityRat)entityIn).func_70909_n()) {
                ((EntityRat)entityIn).setPlague(true);
            } else if (entityIn instanceof EntityLivingBase && this.rollForPlague((EntityLivingBase)entityIn) && ((EntityLivingBase)entityIn).func_70660_b(RatsMod.PLAGUE_POTION) != null) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, 6000));
            }
        }
    }

    private boolean rollForPlague(EntityLivingBase target) {
        boolean mask;
        boolean bl = mask = target.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == RatsItemRegistry.PLAGUE_DOCTOR_MASK || target.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == RatsItemRegistry.BLACK_DEATH_MASK;
        if (mask) {
            return this.field_70146_Z.nextFloat() < 0.3f;
        }
        return true;
    }

    public boolean isInRatHole() {
        return RatUtils.isRatHoleInBoundingBox(this.func_174813_aQ().func_72314_b(0.5, 0.5, 0.5), this.field_70170_p);
    }

    private void findDigTarget() {
        if (this.func_70661_as() instanceof RatPathPathNavigateGround) {
            BlockPos digPos;
            BlockPos target;
            if (((RatPathPathNavigateGround)this.func_70661_as()).targetPosition != null && this.field_70170_p.func_175625_s(target = ((RatPathPathNavigateGround)this.func_70661_as()).targetPosition.func_177977_b()) != null) {
                this.finalDigPathPoint = target;
            }
            if (!this.field_70123_F || !this.func_70661_as().func_75500_f()) {
                return;
            }
            if (this.finalDigPathPoint != null && (digPos = this.rayTraceBlockPos(this.finalDigPathPoint)) != null && this.func_174818_b(digPos) < 2.0 && this.field_70170_p.func_175625_s(digPos) == null) {
                Material material = this.field_70170_p.func_180495_p(digPos).func_185904_a();
                if (RatUtils.canRatBreakBlock(this.field_70170_p, digPos, this) && this.canDigBlock(this.field_70170_p, digPos) && (material.func_76229_l() || material == Material.field_151596_z) && digPos.func_177956_o() == (int)Math.round(this.field_70163_u)) {
                    this.diggingPos = digPos;
                }
            }
        }
    }

    private boolean canDigBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185914_p();
    }

    public BlockPos rayTraceBlockPos(BlockPos targetPos) {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.field_70170_p, this.func_174791_d(), new Vec3d((double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.5, (double)targetPos.func_177952_p() + 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            if (!this.field_70170_p.func_175623_d(sidePos)) {
                return sidePos;
            }
            if (!this.field_70170_p.func_175623_d(pos)) {
                return pos;
            }
            return null;
        }
        return null;
    }

    public void func_70619_bc() {
        if (this.func_70605_aq().func_75640_a()) {
            double d0 = this.func_70605_aq().func_75638_b();
            if (d0 == 0.6) {
                this.func_70095_a(true);
                this.func_70031_b(false);
            } else if (d0 >= 1.1 && d0 < 2.0) {
                this.func_70095_a(false);
                this.func_70031_b(true);
            } else {
                this.func_70095_a(false);
                this.func_70031_b(false);
            }
        } else {
            this.func_70095_a(false);
            this.func_70031_b(false);
        }
    }

    protected void func_174808_Z() {
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.canMove()) {
            strafe = 0.0f;
            vertical = 0.0f;
            forward = 0.0f;
            this.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
        }
        super.func_191986_a(strafe, vertical, forward);
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            playerEntity.openGui((Object)RatsMod.INSTANCE, 1, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public boolean canMove() {
        return this.diggingPos == null && !this.func_70906_o() && this.getCommand().freeMove && !this.func_70631_g_();
    }

    public boolean isInCage() {
        return this.inCage;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_EAT, ANIMATION_IDLE_SCRATCH, ANIMATION_IDLE_SNIFF, ANIMATION_DANCE_0, ANIMATION_DANCE_1};
    }

    public Animation getDanceAnimation() {
        switch (this.getDanceMoves()) {
            case 0: {
                return ANIMATION_DANCE_0;
            }
        }
        return NO_ANIMATION;
    }

    public boolean canPhaseThroughBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockFence || world.func_180495_p(pos).func_177230_c() instanceof BlockFenceGate;
    }

    public void setKilledInTrap() {
        this.isDeadInTrap = true;
        this.func_70097_a(RatsMod.ratTrapDamage, Float.MAX_VALUE);
    }

    protected void func_70609_aI() {
        int maxDeathTime;
        ++this.field_70725_aQ;
        int n = maxDeathTime = this.isDeadInTrap ? 60 : 20;
        if (this.field_70725_aQ == maxDeathTime) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
                if (this.field_70146_Z.nextInt(RatsMod.CONFIG_OPTIONS.tokenDropRate) == 0) {
                    this.func_70099_a(new ItemStack(RatsItemRegistry.CHUNKY_CHEESE_TOKEN), 0.0f);
                }
                if (this.hasPlague() && this.field_70146_Z.nextFloat() <= RatsMod.CONFIG_OPTIONS.plagueEssenceDropRate) {
                    this.func_70099_a(new ItemStack(RatsItemRegistry.PLAGUE_ESSENCE), 0.0f);
                }
                if (this.hasPlague() && this.field_70146_Z.nextFloat() <= RatsMod.CONFIG_OPTIONS.plagueTomeDropRate) {
                    this.func_70099_a(new ItemStack(RatsItemRegistry.PLAGUE_TOME), 0.0f);
                }
                if (this.hasToga()) {
                    this.func_70099_a(new ItemStack(RatsItemRegistry.RAT_TOGA), 0.0f);
                    if (this.field_71093_bK == RatsMod.CONFIG_OPTIONS.ratlantisDimensionId) {
                        boolean flag = false;
                        if (!flag && this.field_70146_Z.nextFloat() < 0.01f) {
                            this.func_70099_a(new ItemStack(Items.field_151045_i), 0.0f);
                            flag = true;
                        }
                        if (!flag && this.field_70146_Z.nextFloat() < 0.6f) {
                            this.func_70099_a(new ItemStack(RatsItemRegistry.CHEESE, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                            flag = true;
                        }
                        if (!flag && this.field_70146_Z.nextFloat() < 0.3f) {
                            this.func_70099_a(new ItemStack(Items.field_151043_k), 0.0f);
                            flag = true;
                        }
                        if (!flag && this.field_70146_Z.nextFloat() < 0.3f) {
                            this.func_70099_a(new ItemStack(Items.field_179563_cD), 0.0f);
                            flag = true;
                        }
                        if (!flag && this.field_70146_Z.nextFloat() < 0.3f) {
                            this.func_70099_a(new ItemStack(Items.field_151122_aG), 0.0f);
                            flag = true;
                        }
                    }
                }
            }
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    public void func_70106_y() {
        IRangedAttackMob illagerPiper;
        if (!this.field_70128_L && this.func_70909_n() && this.getOwnerMonster() != null && this.getOwnerMonster() instanceof EntityIllagerPiper) {
            illagerPiper = (EntityIllagerPiper)this.getOwnerMonster();
            illagerPiper.setRatsSummoned(illagerPiper.getRatsSummoned() - 1);
        }
        if (!this.field_70128_L && this.func_70909_n() && this.getOwnerMonster() != null && this.getOwnerMonster() instanceof EntityBlackDeath) {
            illagerPiper = (EntityBlackDeath)this.getOwnerMonster();
            illagerPiper.setRatsSummoned(illagerPiper.getRatsSummoned() - 1);
        }
        this.field_70128_L = true;
        super.func_70106_y();
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (entity != null && (entity.field_70128_L || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110143_aJ() <= 0.0f)) {
            this.func_184210_p();
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70071_h_();
            if (this.func_184218_aH()) {
                this.updateRiding(entity);
            }
        }
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        this.func_189511_e(compound);
        return true;
    }

    public void func_184226_ay() {
    }

    public void updateRiding(Entity riding) {
        if (riding != null && riding.func_184196_w((Entity)this) && riding instanceof EntityPlayer) {
            int i = riding.func_184188_bt().indexOf((Object)this);
            float radius = (i == 0 ? 0.0f : 0.4f) + (float)(((EntityPlayer)riding).func_184613_cA() ? 2 : 0);
            float angle = (float)Math.PI / 180 * ((EntityPlayer)riding).field_70761_aq + (i == 2 ? -92.5f : (i == 1 ? 92.5f : 0.0f));
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = riding.func_70093_af() ? 1.1 : 1.4;
            this.field_70177_z = ((EntityPlayer)riding).field_70759_as;
            this.field_70759_as = ((EntityPlayer)riding).field_70759_as;
            this.field_70126_B = ((EntityPlayer)riding).field_70759_as;
            this.func_70107_b(riding.field_70165_t + extraX, riding.field_70163_u + extraY, riding.field_70161_v + extraZ);
            if (((EntityPlayer)riding).func_184613_cA()) {
                this.func_184210_p();
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == RatsItemRegistry.RAT_TOGA) {
            if (!this.hasToga()) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(new ItemStack(RatsItemRegistry.RAT_TOGA), 0.0f);
            }
            this.setToga(!this.hasToga());
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.5f);
        }
        if (itemstack.func_77973_b() == RatsItemRegistry.CREATIVE_CHEESE && this.canBeTamed()) {
            this.func_70903_f(true);
            this.setOwnerMonster(false);
            this.field_70170_p.func_72960_a((Entity)this, (byte)83);
            this.func_193101_c(player);
            return true;
        }
        if (itemstack.func_111282_a(player, (EntityLivingBase)this, hand)) {
            return true;
        }
        if (!super.func_184645_a(player, hand) && this.func_70909_n() && !this.func_70631_g_() && this.func_152114_e((EntityLivingBase)player)) {
            if (itemstack.func_77973_b() == RatsItemRegistry.RAT_SACK) {
                NBTTagCompound compound = itemstack.func_77978_p();
                if (compound == null) {
                    compound = new NBTTagCompound();
                    itemstack.func_77982_d(compound);
                }
                NBTTagCompound ratTag = new NBTTagCompound();
                this.func_70014_b(ratTag);
                int currentRat = ItemRatSack.getRatsInStack(itemstack) + 1;
                compound.func_74782_a("Rat_" + currentRat, (NBTBase)ratTag);
                this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
                this.func_70106_y();
                player.func_184609_a(hand);
                return true;
            }
            if (itemstack.func_77973_b() == RatsItemRegistry.CHEESE_STICK || itemstack.func_77973_b() == RatsItemRegistry.RADIUS_STICK) {
                RatsMod.PROXY.setRefrencedRat(this);
                itemstack.func_77978_p().func_186854_a("RatUUID", this.getPersistentID());
                player.func_184609_a(hand);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("entity.rat.staff.bind", new Object[]{this.func_70005_c_()}), true);
                return true;
            }
            if (itemstack.func_77973_b() == Items.field_151032_g) {
                RatsMod.PROXY.setRefrencedRat(this);
                itemstack.func_190918_g(1);
                ItemStack ratArrowStack = new ItemStack(RatsItemRegistry.RAT_ARROW);
                NBTTagCompound compound = new NBTTagCompound();
                NBTTagCompound ratTag = new NBTTagCompound();
                this.func_70014_b(ratTag);
                compound.func_74782_a("Rat", (NBTBase)ratTag);
                ratArrowStack.func_77982_d(compound);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, ratArrowStack);
                } else if (!player.field_71071_by.func_70441_a(ratArrowStack)) {
                    player.func_71019_a(ratArrowStack, false);
                }
                this.func_184185_a(RatsSoundRegistry.RAT_HURT, 1.0f, 1.0f);
                player.func_184609_a(hand);
                this.func_70106_y();
                return true;
            }
            if (!player.func_70093_af() && this.canBeTamed()) {
                this.openGUI(player);
                return true;
            }
            if (player.func_184188_bt().size() < 3) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("entity.rat.dismount_instructions", new Object[0]), true);
                this.func_184205_a((Entity)player, true);
            }
            return true;
        }
        return false;
    }

    public void func_70903_f(boolean tamed) {
        if (tamed) {
            Arrays.fill(this.field_184655_bs, 1.0f);
            Arrays.fill(this.field_82174_bp, 1.0f);
        }
        super.func_70903_f(tamed);
    }

    public int func_70627_aG() {
        if (this.hasPlague() || this.func_70909_n()) {
            return 200;
        }
        return super.func_70627_aG();
    }

    public boolean canBeTamed() {
        return !this.hasPlague();
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            return this.ratInventory.func_70301_a(0);
        }
        if (slotIn == EntityEquipmentSlot.HEAD) {
            return this.ratInventory.func_70301_a(1);
        }
        if (slotIn == EntityEquipmentSlot.OFFHAND) {
            return this.ratInventory.func_70301_a(2);
        }
        return super.func_184582_a(slotIn);
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            this.ratInventory.func_70299_a(0, stack);
        } else if (slotIn == EntityEquipmentSlot.HEAD) {
            this.ratInventory.func_70299_a(1, stack);
        } else if (slotIn == EntityEquipmentSlot.OFFHAND) {
            this.ratInventory.func_70299_a(2, stack);
        } else {
            super.func_184582_a(slotIn);
        }
    }

    private void initInventory() {
        this.ratInventory = new ContainerHorseChest("ratInventory", 4);
        this.ratInventory.func_110133_a(this.func_70005_c_());
        if (this.ratInventory != null) {
            for (int j = 0; j < this.ratInventory.func_70302_i_(); ++j) {
                ItemStack itemstack = this.ratInventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.ratInventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!(this.hasFlight() || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) || this.inTube())) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.hasFlight() && !this.inTube()) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public RatStatus getRatStatus() {
        return this.status;
    }

    public void setRatStatus(RatStatus status) {
        if (this.status.canBeOverriden(this)) {
            this.status = status;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 82) {
            this.playEffect(0);
        } else if (id == 83) {
            this.playEffect(1);
        } else if (id == 84) {
            this.playEffect(2);
        } else if (id == 85) {
            this.crafting = true;
        } else if (id == 86) {
            this.crafting = false;
        } else if (id == 101) {
            this.playEffect(3);
        } else if (id != 125) {
            if (id == 126) {
                this.playEffect(5);
            } else {
                super.func_70103_a(id);
            }
        }
    }

    protected void playEffect(int type) {
        if (type == 3) {
            for (int j = 0; j < 5; ++j) {
                double d6 = (double)j / 5.0;
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                double d3 = this.field_70169_q + (this.field_70165_t - this.field_70169_q) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                double d4 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                double d5 = this.field_70166_s + (this.field_70161_v - this.field_70166_s) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
            }
        } else if (type == 2) {
            for (int j = 0; j < 5; ++j) {
                double d6 = (double)j / 5.0;
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                double d3 = this.field_70169_q + (this.field_70165_t - this.field_70169_q) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                double d4 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                double d5 = this.field_70166_s + (this.field_70161_v - this.field_70166_s) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
            }
        } else {
            EnumParticleTypes enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
            if (type == 1) {
                enumparticletypes = EnumParticleTypes.HEART;
            }
            if (type == 5) {
                enumparticletypes = EnumParticleTypes.SNOW_SHOVEL;
            }
            for (int i = 0; i < 9; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }

    public boolean isMoving() {
        return Math.abs(this.field_70159_w) >= 0.05 || Math.abs(this.field_70179_y) >= 0.05;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setColorVariant(this.func_70681_au().nextInt(4));
        this.setMale(this.func_70681_au().nextBoolean());
        if (this.func_70681_au().nextInt(15) == 0 && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && RatsMod.CONFIG_OPTIONS.plagueRats) {
            this.setPlague(true);
        }
        if (this.field_71093_bK == RatsMod.CONFIG_OPTIONS.ratlantisDimensionId) {
            this.setToga(true);
        }
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) > 10 && this.field_70146_Z.nextFloat() <= 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 1.0f;
        }
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && ((calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 11 && calendar.get(5) > 10 || calendar.get(2) + 1 == 12) && this.field_70146_Z.nextFloat() <= 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(RatsItemRegistry.SANTA_HAT));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 1.0f;
        }
        if (this.func_70681_au().nextFloat() < 0.025f) {
            this.setColorVariant(this.func_70681_au().nextBoolean() ? 9 : 4);
        }
        return livingdata;
    }

    @SideOnly(value=Side.CLIENT)
    public String getRatTexture() {
        return RAT_TEXTURES[MathHelper.func_76125_a((int)this.getColorVariant(), (int)0, (int)(RAT_TEXTURES.length - 1))];
    }

    public boolean shouldHuntAnimals() {
        return this.getCommandInteger() == 3 || !this.func_70909_n() && this.hasPlague();
    }

    public boolean shouldHuntMonsters() {
        return this.getCommandInteger() == 7 || !this.func_70909_n() && this.hasPlague();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        if (this.hasPlague()) {
            s = "plague_rat";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    public boolean shouldEyesGlow() {
        return this.hasPlague() || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NONBELIEVER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENDER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AQUATIC);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected SoundEvent func_184639_G() {
        SoundEvent possibleDragonSound;
        if (this.hasPlague() && this.func_70638_az() != null) {
            return RatsSoundRegistry.RAT_PLAGUE;
        }
        if (!this.hasPlague() && this.func_70909_n() && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS)) {
            return RatsSoundRegistry.RAT_SANTA;
        }
        if (!this.hasPlague() && (double)this.func_110143_aJ() <= (double)this.func_110138_aP() / 2.0 || this.func_70631_g_()) {
            return RatsSoundRegistry.RAT_IDLE;
        }
        if (RatsMod.iafLoaded && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON) && (possibleDragonSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("iceandfire", "firedragon_child_idle"))) != null) {
            return possibleDragonSound;
        }
        return super.func_184639_G();
    }

    protected SoundEvent func_184615_bR() {
        SoundEvent possibleDragonSound;
        if (RatsMod.iafLoaded && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON) && (possibleDragonSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("iceandfire", "firedragon_child_death"))) != null) {
            return possibleDragonSound;
        }
        return RatsSoundRegistry.RAT_DIE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        SoundEvent possibleDragonSound;
        if (RatsMod.iafLoaded && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON) && (possibleDragonSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("iceandfire", "firedragon_child_hurt"))) != null) {
            return possibleDragonSound;
        }
        return RatsSoundRegistry.RAT_HURT;
    }

    public boolean onHearFlute(EntityPlayer player, RatCommand ratCommand) {
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && !this.func_70631_g_() && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NO_FLUTE)) {
            this.setCommand(ratCommand);
            return true;
        }
        return false;
    }

    public boolean canRatPickupItem(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        if ((this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BLACKLIST) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_WHITELIST)) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && (nbttagcompound1 = this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BLACKLIST) ? this.getUpgrade(RatsItemRegistry.RAT_UPGRADE_BLACKLIST).func_77978_p() : this.getUpgrade(RatsItemRegistry.RAT_UPGRADE_WHITELIST).func_77978_p()) != null && nbttagcompound1.func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BLACKLIST)) {
                for (ItemStack itemstack : nonnulllist) {
                    if (!itemstack.func_77969_a(stack)) continue;
                    return false;
                }
                return true;
            }
            for (ItemStack itemstack : nonnulllist) {
                if (!itemstack.func_77969_a(stack)) continue;
                return true;
            }
            return false;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && this.getCommand() == RatCommand.HARVEST) {
            Item item = stack.func_77973_b();
            return item instanceof ItemSeeds || item instanceof ItemSeedFood || item instanceof ItemBlock || item == Items.field_151100_aR && EnumDyeColor.func_176766_a((int)stack.func_77960_j()) == EnumDyeColor.WHITE;
        }
        return true;
    }

    public boolean func_184595_k(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.field_70170_p.func_72960_a((Entity)this, (byte)84);
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    public boolean isDirectPathBetweenPoints(Vec3d target) {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.field_70170_p, this.func_174791_d(), target.func_72441_c(0.5, 0.5, 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            if (!this.field_70170_p.func_175623_d(pos) || !this.field_70170_p.func_175623_d(sidePos)) {
                return true;
            }
            return rayTrace.field_72313_a == RayTraceResult.Type.MISS;
        }
        return true;
    }

    public BlockPos getLightPosition() {
        BlockPos pos = new BlockPos((Entity)this);
        if (!this.field_70170_p.func_180495_p(pos).func_185913_b()) {
            return pos.func_177984_a();
        }
        return pos;
    }

    public boolean inTube() {
        return this.inTube;
    }

    private boolean inTubeLogic() {
        if (this.func_70909_n()) {
            BlockPos pos = new BlockPos((Entity)this);
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            boolean above = this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockRatTube;
            if (state.func_177230_c() instanceof BlockRatTube) {
                List<AxisAlignedBB> aabbs = ((BlockRatTube)state.func_177230_c()).compileAABBList((IBlockAccess)this.field_70170_p, pos, state);
                AxisAlignedBB bb = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);
                for (AxisAlignedBB box : aabbs) {
                    bb = bb.func_111270_a(box);
                }
                return (bb = bb.func_72314_b((double)0.05f, 0.0, (double)0.05f).func_186670_a(pos)).func_72318_a(this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0)) || bb.func_72318_a(this.func_174791_d()) && above;
            }
        }
        return false;
    }

    public void setTubeTarget(BlockPos targetPosition) {
        this.tubeTarget = targetPosition;
    }

    public ItemStack getUpgradeSlot() {
        return this.func_184586_b(EnumHand.OFF_HAND);
    }

    public ItemStack getUpgrade(Item item) {
        NBTTagCompound nbttagcompound1;
        ItemStack stack = this.getUpgradeSlot();
        if (stack.func_77973_b() == item) {
            return stack;
        }
        if ((stack.func_77973_b() instanceof ItemRatCombinedUpgrade || stack.func_77973_b() instanceof ItemRatUpgradeJuryRigged) && (nbttagcompound1 = stack.func_77978_p()) != null && nbttagcompound1.func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
            for (ItemStack stack1 : nonnulllist) {
                if (stack1.func_77973_b() != item) continue;
                return stack1;
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasUpgrade(Item item) {
        if (!this.getUpgradeSlot().func_190926_b()) {
            return this.getUpgrade(item) != ItemStack.field_190927_a;
        }
        return false;
    }

    public boolean holdsItemInHandUpgrade() {
        return this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SHEARS) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS);
    }

    public boolean shouldNotIdleAnimation() {
        return this.holdInMouth && this.getAnimation() != ANIMATION_EAT && this.cookingProgress <= 0 && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SHEARS);
    }

    private void onUpgradeChanged() {
        this.setupDynamicAI();
        boolean flagHealth = false;
        boolean flagArmor = false;
        boolean flagAttack = false;
        boolean flagSpeed = false;
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARISTOCRAT) && this.coinCooldown == 0) {
            this.coinCooldown = this.field_70146_Z.nextInt(6000) + 6000;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SPEED)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111263_d, 0.5);
            flagSpeed = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GOD)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 500.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 50.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 50.0);
            flagHealth = true;
            flagArmor = true;
            flagAttack = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_WARRIOR)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 40.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 12.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 10.0);
            flagHealth = true;
            flagArmor = true;
            flagAttack = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_HEALTH)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 25.0);
            flagHealth = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARMOR)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 10.0);
            flagArmor = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_STRENGTH)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 5.0);
            flagAttack = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_VOODOO)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 100.0);
            flagHealth = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 30.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 80.0);
            flagHealth = true;
            flagArmor = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 50.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 15.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 8.0);
            flagHealth = true;
            flagArmor = true;
            flagAttack = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NONBELIEVER)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 1000.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 100.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 100.0);
            flagHealth = true;
            flagArmor = true;
            flagAttack = true;
        }
        if (!flagHealth) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        if (!flagArmor) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        }
        if (!flagAttack) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        }
        if (!flagSpeed) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        }
        if (this.getHeldRF() > this.getRFTransferRate()) {
            this.setHeldRF(0);
        }
        this.func_70691_i(this.func_110138_aP());
    }

    private void tryIncreaseStat(IAttribute stat, double value) {
        double prev = this.func_110148_a(stat).func_111126_e();
        if (prev < value) {
            this.func_110148_a(stat).func_111128_a(value);
        }
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_POISON) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION))) {
            return false;
        }
        if (potioneffectIn.func_188419_a() == RatsMod.PLAGUE_POTION) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76347_k() && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ASBESTOS) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON))) {
            return true;
        }
        if ((source.func_82725_o() || source == DamageSource.field_82727_n) && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_POISON) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION))) {
            return true;
        }
        if (source == DamageSource.field_76368_d) {
            return true;
        }
        if (source == DamageSource.field_76369_e && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_POISON) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION))) {
            return true;
        }
        if (source == DamageSource.field_76379_h && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT_SURVIVOR))) {
            return true;
        }
        if (source.func_94541_c() && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT_SURVIVOR)) {
            return true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CREATIVE)) {
            return source.func_76346_g() == null || source.func_76346_g() instanceof EntityLivingBase && !this.func_152114_e((EntityLivingBase)source.func_76346_g());
        }
        return super.func_180431_b(source);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
        int moves = this.field_70146_Z.nextInt(4);
        if (!this.isDancing() && isPartying) {
            this.setDanceMoves(moves);
        }
        this.setDancing(isPartying);
        this.jukeboxPos = pos;
        if (this.field_70170_p.field_72995_K) {
            RatsMod.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDancingRat(this.func_145782_y(), isPartying, pos.func_177986_g(), moves));
        }
    }

    public boolean shouldDepositItem(ItemStack item) {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHEF) && !this.getCookingResultFor(item).func_190926_b()) {
            return false;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARCHEOLOGIST) && !this.getArcheologyResultFor(item).func_190926_b()) {
            return false;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GEMCUTTER) && !this.getGemcutterResultFor(item).func_190926_b()) {
            return false;
        }
        return !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) || !ItemRatUpgradeOreDoubling.isProcessable(item);
    }

    public int getRFTransferRate() {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_EXTREME_ENERGY)) {
            return ItemRatUpgradeEnergy.getRFTransferRate(RatsItemRegistry.RAT_UPGRADE_EXTREME_ENERGY) * 1000;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ELITE_ENERGY)) {
            return ItemRatUpgradeEnergy.getRFTransferRate(RatsItemRegistry.RAT_UPGRADE_ELITE_ENERGY) * 1000;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ADVANCED_ENERGY)) {
            return ItemRatUpgradeEnergy.getRFTransferRate(RatsItemRegistry.RAT_UPGRADE_ADVANCED_ENERGY) * 1000;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY)) {
            return ItemRatUpgradeEnergy.getRFTransferRate(RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY) * 1000;
        }
        return 0;
    }

    public int getMBTransferRate() {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BUCKET)) {
            return ItemRatUpgradeBucket.getMbTransferRate(RatsItemRegistry.RAT_UPGRADE_BUCKET);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MILKER)) {
            return ItemRatUpgradeBucket.getMbTransferRate(RatsItemRegistry.RAT_UPGRADE_MILKER);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BIG_BUCKET)) {
            return ItemRatUpgradeBucket.getMbTransferRate(RatsItemRegistry.RAT_UPGRADE_BIG_BUCKET);
        }
        return 0;
    }

    public boolean hasFlight() {
        return this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FLIGHT) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON);
    }

    public boolean func_184191_r(Entity entityIn) {
        EntityTameable tameable;
        if (entityIn instanceof EntityTameable && (tameable = (EntityTameable)entityIn).func_70909_n() && this.func_70909_n() && this.func_184753_b() != null && tameable.func_184753_b() != null && this.func_184753_b().equals(tameable.func_184753_b())) {
            return true;
        }
        return super.func_184191_r(entityIn);
    }

    public BlockPos getSearchCenter() {
        if (this.getSearchRadiusCenter() == null || !this.hasCustomSearchZone()) {
            return this.func_180425_c();
        }
        return this.getSearchRadiusCenter();
    }
}

