/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public class RatAIHarvestCrops
extends EntityAIBase {
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int feedingTicks;

    public RatAIHarvestCrops(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage()) {
            return false;
        }
        if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int RADIUS = this.entity.getSearchRadius();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS))) {
            Item item;
            IBlockState block = this.entity.field_70170_p.func_180495_p(pos);
            if (!(block.func_177230_c() instanceof BlockCrops && ((BlockCrops)block.func_177230_c()).func_185525_y(block) || !(block.func_177230_c() instanceof BlockCrops) && block.func_177230_c() instanceof BlockBush) && block.func_185904_a() != Material.field_151572_C || block.func_177230_c() instanceof BlockStem || !this.entity.canRatPickupItem(new ItemStack(item = block.func_177230_c().func_180660_a(block, this.entity.func_70681_au(), 0)))) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
        }
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && (this.entity.field_70170_p.func_180495_p(this.targetBlock).func_177230_c() instanceof BlockBush || this.entity.field_70170_p.func_180495_p(this.targetBlock).func_185904_a() == Material.field_151572_C);
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            IBlockState block = this.entity.field_70170_p.func_180495_p(this.targetBlock);
            this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
            if (block.func_177230_c() instanceof BlockBush || block.func_185904_a() == Material.field_151572_C) {
                if (block.func_177230_c() instanceof BlockCrops && !((BlockCrops)block.func_177230_c()).func_185525_y(block)) {
                    this.targetBlock = null;
                    this.func_75251_c();
                    return;
                }
                double distance = this.entity.func_70011_f(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (distance < 1.5) {
                    NonNullList drops = NonNullList.func_191196_a();
                    block.func_177230_c().getDrops(drops, (IBlockAccess)this.entity.field_70170_p, this.targetBlock, block, 0);
                    this.entity.field_70170_p.func_175655_b(this.targetBlock, false);
                    if ((!RatsMod.CONFIG_OPTIONS.ratsBreakBlockOnHarvest || this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_REPLANTER)) && block.func_177230_c() instanceof BlockCrops) {
                        for (int i = 0; i < drops.size(); ++i) {
                            if (!RatAIHarvestCrops.isPlantabe(((ItemStack)drops.get(i)).func_77973_b())) continue;
                            if (((ItemStack)drops.get(i)).func_190916_E() == 1) {
                                drops.remove(i);
                            } else {
                                ((ItemStack)drops.get(i)).func_190920_e(((ItemStack)drops.get(i)).func_190916_E() - 1);
                            }
                            this.entity.field_70170_p.func_175656_a(this.targetBlock, block.func_177230_c().func_176223_P());
                        }
                    }
                    if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
                        ItemStack duplicate = ((ItemStack)drops.get(0)).func_77946_l();
                        drops.remove(0);
                        if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
                            this.entity.func_70099_a(this.entity.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
                        }
                        this.entity.func_184611_a(EnumHand.MAIN_HAND, duplicate);
                        for (ItemStack drop : drops) {
                            this.entity.func_70099_a(drop, 0.0f);
                        }
                        this.entity.fleePos = this.targetBlock;
                    }
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            }
        }
    }

    private static boolean isPlantabe(Item item) {
        Block block;
        if (item instanceof IPlantable) {
            return true;
        }
        return item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) instanceof IPlantable;
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.field_70163_u + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

