/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class RatAIHarvestFarmer
extends EntityAIBase {
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;

    public RatAIHarvestFarmer(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.entity.getCommand() == RatCommand.HARVEST && !this.entity.isInCage() && this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && (this.holdingSeeds() || this.holdingBlock() || this.holdingBonemeal()))) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private boolean holdingSeeds() {
        return !this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && (this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemSeeds || this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemSeedFood);
    }

    private boolean holdingBonemeal() {
        ItemStack stack = this.entity.func_184586_b(EnumHand.MAIN_HAND);
        return !stack.func_190926_b() && stack.func_77973_b() == Items.field_151100_aR && EnumDyeColor.func_176766_a((int)stack.func_77960_j()) == EnumDyeColor.WHITE;
    }

    private boolean holdingBlock() {
        return !this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemBlock;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && (this.holdingSeeds() || this.holdingBonemeal() || this.holdingBlock());
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            double distance;
            IBlockState block;
            if (this.holdingSeeds()) {
                block = this.entity.field_70170_p.func_180495_p(this.targetBlock);
                this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
                if (block.func_177230_c().isFertile(this.entity.field_70170_p, this.targetBlock) && this.entity.field_70170_p.func_175623_d(this.targetBlock.func_177984_a())) {
                    distance = this.entity.func_70011_f(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                    if (distance < 1.5) {
                        if (this.holdingSeeds()) {
                            ItemStack seedStack = this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77946_l();
                            seedStack.func_190920_e(1);
                            this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190918_g(1);
                            if (seedStack.func_77973_b() instanceof ItemSeeds) {
                                this.entity.field_70170_p.func_175656_a(this.targetBlock.func_177984_a(), ((ItemSeeds)seedStack.func_77973_b()).getPlant((IBlockAccess)this.entity.field_70170_p, this.targetBlock.func_177984_a()));
                            }
                            if (seedStack.func_77973_b() instanceof ItemSeedFood) {
                                this.entity.field_70170_p.func_175656_a(this.targetBlock.func_177984_a(), ((ItemSeedFood)seedStack.func_77973_b()).getPlant((IBlockAccess)this.entity.field_70170_p, this.targetBlock.func_177984_a()));
                            }
                        }
                        this.targetBlock = null;
                        this.func_75251_c();
                    }
                } else {
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            }
            if (this.holdingBonemeal()) {
                block = this.entity.field_70170_p.func_180495_p(this.targetBlock);
                this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
                if (this.canPlantBeBonemealed(this.targetBlock, block)) {
                    distance = this.entity.func_70011_f(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                    if (distance < 1.5) {
                        if (this.holdingBonemeal()) {
                            IGrowable igrowable;
                            this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190918_g(1);
                            if (block.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)block.func_177230_c()).func_176473_a(this.entity.field_70170_p, this.targetBlock, block, this.entity.field_70170_p.field_72995_K) && !this.entity.field_70170_p.field_72995_K) {
                                this.entity.field_70170_p.func_175718_b(2005, this.targetBlock, 0);
                                igrowable.func_176474_b(this.entity.field_70170_p, this.entity.field_70170_p.field_73012_v, this.targetBlock, block);
                            }
                        }
                        this.targetBlock = null;
                        this.func_75251_c();
                    }
                } else {
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            } else if (this.holdingBlock()) {
                ItemBlock itemBlock = (ItemBlock)this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
                this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
                if (this.entity.field_70170_p.func_190527_a(itemBlock.func_179223_d(), this.targetBlock, false, EnumFacing.UP, (Entity)null)) {
                    distance = this.entity.func_70011_f(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                    if (distance < 1.5) {
                        if (this.holdingBlock()) {
                            IBlockState iblockstate1 = itemBlock.func_179223_d().getStateForPlacement(this.entity.field_70170_p, this.targetBlock, this.entity.func_174811_aO(), 0.0f, 0.0f, 0.0f, this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77960_j(), (EntityLivingBase)this.entity, EnumHand.MAIN_HAND);
                            this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190918_g(1);
                            this.entity.field_70170_p.func_175656_a(this.targetBlock, iblockstate1);
                            if (this.entity.func_70094_T()) {
                                this.entity.func_70107_b(this.entity.field_70165_t, this.entity.field_70163_u + 1.0, this.entity.field_70161_v);
                            }
                            SoundType placeSound = iblockstate1.func_177230_c().getSoundType(iblockstate1, this.entity.field_70170_p, this.targetBlock, (Entity)this.entity);
                            this.entity.func_184185_a(placeSound.func_185841_e(), (placeSound.func_185843_a() + 1.0f) / 2.0f, placeSound.func_185847_b() * 0.8f);
                        }
                        this.targetBlock = null;
                        this.func_75251_c();
                    }
                } else {
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            }
        }
    }

    private void resetTarget() {
        if (this.holdingBonemeal()) {
            ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
            int RADIUS = this.entity.getSearchRadius();
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS))) {
                if (!this.canPlantBeBonemealed(pos, this.entity.field_70170_p.func_180495_p(pos))) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.targetSorter);
                this.targetBlock = (BlockPos)allBlocks.get(0);
            }
        } else if (this.holdingSeeds()) {
            ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
            int RADIUS = this.entity.getSearchRadius();
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS))) {
                if (!this.entity.field_70170_p.func_180495_p(pos).func_177230_c().isFertile(this.entity.field_70170_p, pos) || !this.entity.field_70170_p.func_175623_d(pos.func_177984_a())) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.targetSorter);
                this.targetBlock = (BlockPos)allBlocks.get(0);
            }
        } else if (this.holdingBlock()) {
            ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
            Block block = Blocks.field_150345_g;
            if (this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != null && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemBlock) {
                block = ((ItemBlock)this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).func_179223_d();
            }
            int RADIUS = this.entity.getSearchRadius();
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS))) {
                if (!this.entity.field_70170_p.func_190527_a(block, pos, false, EnumFacing.UP, (Entity)null) || !this.entity.field_70170_p.func_175623_d(pos.func_177984_a())) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.targetSorter);
                this.targetBlock = (BlockPos)allBlocks.get(0);
            }
        }
    }

    private boolean canPlantBeBonemealed(BlockPos pos, IBlockState iblockstate) {
        IGrowable igrowable;
        if (iblockstate.func_177230_c() instanceof IGrowable && !(iblockstate.func_177230_c() instanceof BlockTallGrass) && !(iblockstate.func_177230_c() instanceof BlockGrass) && (igrowable = (IGrowable)iblockstate.func_177230_c()).func_176473_a(this.entity.field_70170_p, pos, iblockstate, this.entity.field_70170_p.field_72995_K) && !this.entity.field_70170_p.field_72995_K) {
            return igrowable.func_180670_a(this.entity.field_70170_p, this.entity.field_70170_p.field_73012_v, pos, iblockstate);
        }
        return false;
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.field_70163_u + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

