/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageUpdateRatFluid;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RatAIPickupFluid
extends EntityAIBase {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private BlockPos targetBlock = null;
    private int feedingTicks;

    public RatAIPickupFluid(EntityRat entity) {
        this.entity = entity;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.canPickUp() && this.entity.func_70638_az() == null && this.entity.getMBTransferRate() != 0)) {
            return false;
        }
        if (this.entity.transportingFluid != null && this.entity.transportingFluid.amount >= this.entity.getMBTransferRate()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        this.targetBlock = this.entity.pickupPos;
    }

    private boolean canPickUp() {
        return this.entity.getCommand() == RatCommand.TRANSPORT || this.entity.getCommand() == RatCommand.HARVEST && this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER);
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && (this.entity.transportingFluid == null || this.entity.transportingFluid.amount < this.entity.getMBTransferRate());
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
            TileEntity entity = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
            double distance = this.entity.func_70011_f((double)this.targetBlock.func_177958_n() + 0.5, this.targetBlock.func_177956_o() + 1, (double)this.targetBlock.func_177952_p() + 0.5);
            if (distance <= 1.7 && this.canSeeChest()) {
                IFluidHandler handler = (IFluidHandler)entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
                if (handler == null) {
                    return;
                }
                int currentAmount = 0;
                if (this.entity.transportingFluid != null) {
                    currentAmount = this.entity.transportingFluid.amount;
                }
                int howMuchWeWant = this.entity.getMBTransferRate() - currentAmount;
                FluidStack drainedStack = null;
                try {
                    boolean totalTankHeld = false;
                    if (handler.getTankProperties().length > 0) {
                        IFluidTankProperties firstTank = handler.getTankProperties()[0];
                        if (handler.getTankProperties().length > 1) {
                            for (IFluidTankProperties otherTank : handler.getTankProperties()) {
                                if (this.entity.transportingFluid == null || !this.entity.transportingFluid.isFluidEqual(otherTank.getContents())) continue;
                                firstTank = otherTank;
                            }
                        }
                        if (firstTank.getContents() != null && (this.entity.transportingFluid == null || this.entity.transportingFluid.isFluidEqual(firstTank.getContents())) && handler.drain(howMuchWeWant = Math.min(firstTank.getContents().amount, howMuchWeWant), false) != null) {
                            drainedStack = handler.drain(howMuchWeWant, true);
                        }
                    }
                }
                catch (Exception totalTankHeld) {
                    // empty catch block
                }
                if (drainedStack == null) {
                    this.targetBlock = null;
                    this.func_75251_c();
                } else {
                    if (this.entity.transportingFluid == null) {
                        this.entity.transportingFluid = drainedStack.copy();
                    } else {
                        this.entity.transportingFluid.amount += Math.max(drainedStack.amount, 0);
                    }
                    if (!this.entity.field_70170_p.field_72995_K) {
                        RatsMod.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdateRatFluid(this.entity.func_145782_y(), this.entity.transportingFluid));
                    }
                    SoundEvent sound = this.entity.transportingFluid == null ? SoundEvents.field_187630_M : this.entity.transportingFluid.getFluid().getFillSound();
                    this.entity.func_184185_a(sound, 1.0f, 1.0f);
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            }
        }
    }
}

