/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityFeralRatlantean;
import com.github.alexthe666.rats.server.entity.EntityPirat;
import com.github.alexthe666.rats.server.entity.EntityRatlanteanSpirit;
import com.github.alexthe666.rats.server.world.gen.WorldGenMarblePile;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeRatlantis
extends Biome {
    private static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final WorldGenerator cheeseOre = new WorldGenMinable(RatsBlockRegistry.BLOCK_OF_CHEESE.func_176223_P(), 9);
    private final WorldGenerator cheeseMarbleOre = new WorldGenMinable(RatsBlockRegistry.MARBLED_CHEESE_RAW.func_176223_P(), 25);

    public BiomeRatlantis() {
        super(new Biome.BiomeProperties("ratlantis").func_185410_a(0.95f).func_185395_b(0.9f));
        this.setRegistryName("ratlantis");
        this.field_76760_I.field_76832_z = 30;
        this.field_76760_I.field_76803_B = 25;
        this.field_76760_I.field_76802_A = 4;
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityParrot.class, 60, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityFeralRatlantean.class, 70, 1, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityPirat.class, 20, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityRatlanteanSpirit.class, 50, 1, 3));
        this.addFlower(RatsBlockRegistry.RATGLOVE_FLOWER.func_176223_P(), 30);
    }

    public WorldGenerator func_76730_b(Random rand) {
        return rand.nextInt(4) == 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (rand.nextInt(10) == 0) {
            return field_76758_O;
        }
        if (rand.nextInt(2) == 0) {
            return new WorldGenShrub(JUNGLE_LOG, OAK_LEAF);
        }
        return rand.nextInt(3) == 0 ? new WorldGenMegaJungle(false, 10, 20, JUNGLE_LOG, JUNGLE_LEAF) : new WorldGenTrees(false, 4 + rand.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return 16762410;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int i2;
        int l1;
        int k1;
        int j1;
        int j;
        int i;
        int height;
        super.func_180624_a(worldIn, rand, pos);
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(worldIn, rand, pos));
        EmeraldGenerator emeralds = new EmeraldGenerator();
        if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)emeralds, (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.EMERALD)) {
            emeralds.func_180709_b(worldIn, rand, pos);
        }
        if ((height = worldIn.func_175645_m(pos.func_177982_a(i = rand.nextInt(16) + 8, 0, j = rand.nextInt(16) + 8)).func_177956_o() * 2) < 1) {
            height = 1;
        }
        int k = rand.nextInt(height);
        for (int melons = 0; melons < 3; ++melons) {
            new WorldGenMarblePile().func_180709_b(worldIn, rand, pos.func_177982_a(i, k, j));
        }
        for (j1 = 0; j1 < 7; ++j1) {
            k1 = rand.nextInt(16);
            l1 = rand.nextInt(100);
            i2 = rand.nextInt(16);
            this.cheeseMarbleOre.func_180709_b(worldIn, rand, pos.func_177982_a(k1, l1, i2));
        }
        for (j1 = 0; j1 < 7; ++j1) {
            k1 = rand.nextInt(16);
            l1 = rand.nextInt(100);
            i2 = rand.nextInt(16);
            this.cheeseOre.func_180709_b(worldIn, rand, pos.func_177982_a(k1, l1, i2));
        }
    }

    private static class EmeraldGenerator
    extends WorldGenerator {
        private EmeraldGenerator() {
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
            int count = 3 + rand.nextInt(6);
            for (int i = 0; i < count; ++i) {
                int offset = ForgeModContainer.fixVanillaCascading ? 8 : 0;
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(16) + offset, rand.nextInt(28) + 4, rand.nextInt(16) + offset);
                IBlockState state = worldIn.func_180495_p(blockpos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                worldIn.func_180501_a(blockpos, Blocks.field_150412_bA.func_176223_P(), 18);
            }
            return true;
        }
    }
}

