/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.gen;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.world.village.WorldGenPetShop;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RatsVillageProcessor
implements ITemplateProcessor {
    private Biome biome;
    private BlockPos blockPos;
    private PlacementSettings settings;
    private WorldGenPetShop petShop;

    public RatsVillageProcessor(BlockPos pos, WorldGenPetShop worldGenPetShop, PlacementSettings settings, Biome biome) {
        this.biome = biome;
        this.blockPos = pos;
        this.settings = settings;
        this.petShop = worldGenPetShop;
    }

    @Nullable
    public Template.BlockInfo func_189943_a(World worldIn, BlockPos pos, Template.BlockInfo blockInfoIn) {
        if (blockInfoIn.field_186243_b.func_177230_c() instanceof BlockChest) {
            ResourceLocation loot = blockInfoIn.field_186243_b.func_177230_c() == Blocks.field_150447_bR ? WorldGenPetShop.UPSTAIRS_LOOT : WorldGenPetShop.LOOT;
            Random rand = new Random(worldIn.func_72905_C() + pos.func_177986_g());
            NBTTagCompound tag = blockInfoIn.field_186244_c == null ? new NBTTagCompound() : blockInfoIn.field_186244_c;
            tag.func_74778_a("LootTable", loot.toString());
            tag.func_74772_a("LootTableSeed", rand.nextLong());
            Template.BlockInfo newInfo = new Template.BlockInfo(pos, Blocks.field_150486_ae.func_176223_P(), tag);
            return newInfo;
        }
        if (blockInfoIn.field_186243_b.func_177230_c() == Blocks.field_150484_ah) {
            if ((this.petShop.wolfPos.size() == 0 || this.petShop.wolfPos.size() < 2 && worldIn.field_73012_v.nextInt(1) == 0) && !this.petShop.wolfPos.contains(pos)) {
                this.petShop.wolfPos.add(pos);
            }
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return new Template.BlockInfo(pos, Blocks.field_150350_a.func_176223_P(), null);
        }
        if (blockInfoIn.field_186243_b.func_177230_c() == Blocks.field_150340_R) {
            if (!this.petShop.ratPos.contains(pos)) {
                this.petShop.ratPos.add(pos);
            }
            return new Template.BlockInfo(pos, RatsBlockRegistry.RAT_CAGE.func_176223_P(), null);
        }
        if (blockInfoIn.field_186243_b.func_177230_c() == Blocks.field_150371_ca) {
            if (!this.petShop.rabbitPos.contains(pos)) {
                this.petShop.rabbitPos.add(pos);
            }
            return new Template.BlockInfo(pos, RatsBlockRegistry.RAT_CAGE.func_176223_P(), null);
        }
        if (blockInfoIn.field_186243_b.func_177230_c() == Blocks.field_150339_S) {
            if ((this.petShop.ocelotPos.size() == 0 || this.petShop.ocelotPos.size() < 2 && worldIn.field_73012_v.nextInt(3) == 0) && !this.petShop.ocelotPos.contains(pos)) {
                this.petShop.ocelotPos.add(pos);
            }
            return new Template.BlockInfo(pos, RatsBlockRegistry.RAT_CAGE.func_176223_P(), null);
        }
        if (blockInfoIn.field_186243_b.func_177230_c() == Blocks.field_150475_bE) {
            if (!this.petShop.parrotPos.contains(pos)) {
                this.petShop.parrotPos.add(pos);
            }
            return new Template.BlockInfo(pos, RatsBlockRegistry.RAT_CAGE.func_176223_P(), null);
        }
        if (blockInfoIn.field_186243_b.func_177230_c() == Blocks.field_150402_ci) {
            if (!this.petShop.villagerPos.contains(pos)) {
                this.petShop.villagerPos.add(pos);
            }
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return new Template.BlockInfo(pos, Blocks.field_150350_a.func_176223_P(), null);
        }
        if (blockInfoIn.field_186243_b.func_177230_c() == Blocks.field_150368_y) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return new Template.BlockInfo(pos, Blocks.field_150350_a.func_176223_P(), null);
        }
        IBlockState state = this.getBiomeSpecificBlockState(blockInfoIn.field_186243_b, this.biome);
        if (state != blockInfoIn.field_186243_b) {
            return new Template.BlockInfo(pos, state, null);
        }
        return blockInfoIn;
    }

    protected IBlockState getBiomeSpecificBlockState(IBlockState blockstateIn, Biome biome) {
        BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(biome, blockstateIn);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        int structureType = 0;
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            structureType = 1;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            structureType = 2;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
            structureType = 3;
        }
        if (event.getResult() == Event.Result.DENY) {
            return event.getReplacement();
        }
        if (blockstateIn.func_177230_c() instanceof BlockDoor && blockstateIn.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            EnumFacing facing = (EnumFacing)blockstateIn.func_177229_b((IProperty)BlockDoor.field_176520_a);
            return this.biomeDoor(structureType).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing);
        }
        if (blockstateIn.func_177230_c() instanceof BlockDoor && blockstateIn.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            EnumFacing facing = (EnumFacing)blockstateIn.func_177229_b((IProperty)BlockDoor.field_176520_a);
            return this.biomeDoor(structureType).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
        }
        if (structureType == 1) {
            if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                return Blocks.field_150322_A.func_176223_P();
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.DEFAULT.func_176675_a());
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150346_d) {
                return Blocks.field_150354_m.func_176223_P();
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150349_c) {
                return Blocks.field_150322_A.func_176223_P();
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a());
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150351_n) {
                return Blocks.field_150322_A.func_176223_P();
            }
        } else if (structureType == 3) {
            if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                return Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                return Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                return Blocks.field_180408_aP.func_176223_P();
            }
        } else if (structureType == 2) {
            if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA);
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                return Blocks.field_150400_ck.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
            }
            if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                return Blocks.field_180405_aT.func_176223_P();
            }
        }
        if (blockstateIn.func_177230_c() == Blocks.field_150349_c && structureType != 1) {
            return Blocks.field_185774_da.func_176223_P();
        }
        return blockstateIn;
    }

    protected IBlockState biomeDoor(int structureType) {
        switch (structureType) {
            case 2: {
                return Blocks.field_180410_as.func_176223_P();
            }
            case 3: {
                return Blocks.field_180414_ap.func_176223_P();
            }
        }
        return Blocks.field_180413_ao.func_176223_P();
    }
}

