/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.village;

import com.github.alexthe666.rats.server.entity.EntityPlagueDoctor;
import com.github.alexthe666.rats.server.world.gen.RatsPlagueHutProcessor;
import com.github.alexthe666.rats.server.world.gen.WorldGenRatRuin;
import com.github.alexthe666.rats.server.world.village.VillageComponentPlagueDoctor;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WorldGenPlagueDoctor
extends WorldGenerator {
    public static final ResourceLocation LOOT = new ResourceLocation("rats", "plague_doctor_house");
    private static final ResourceLocation STRUCTURE = new ResourceLocation("rats", "village_plague_doctor_house");
    private VillageComponentPlagueDoctor component;
    public BlockPos villagerPos;
    private Rotation rotation;
    private EnumFacing facing;

    public WorldGenPlagueDoctor(VillageComponentPlagueDoctor component, EnumFacing facing) {
        this.component = component;
        this.facing = facing;
        switch (facing) {
            case SOUTH: {
                this.rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case EAST: {
                this.rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case WEST: {
                this.rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                this.rotation = Rotation.NONE;
            }
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (worldIn == null) {
            return false;
        }
        this.villagerPos = null;
        MinecraftServer server = worldIn.func_73046_m();
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(WorldGenRatRuin.getRotationFromFacing(this.facing)).func_186225_a(Blocks.field_150350_a);
        Template template = templateManager.func_186237_a(server, STRUCTURE);
        Biome biome = worldIn.func_180494_b(position);
        BlockPos genPos = position.func_177967_a(this.facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(this.facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2);
        template.func_189960_a(worldIn, genPos, (ITemplateProcessor)new RatsPlagueHutProcessor(position.func_177981_b(2), this, settings, biome), settings, 2);
        if (this.villagerPos != null) {
            EntityPlagueDoctor doctor = new EntityPlagueDoctor(worldIn);
            doctor.func_70012_b((double)this.villagerPos.func_177958_n() + 0.5, this.villagerPos.func_177956_o(), (double)this.villagerPos.func_177952_p() + 0.5, 0.0f, 0.0f);
            doctor.func_180482_a(worldIn.func_175649_E(this.villagerPos), null);
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)doctor);
            }
        }
        return true;
    }
}

