/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translate;

import com.ringosham.translate.Log;
import com.ringosham.translate.Main;
import com.ringosham.translate.Reference;
import com.rmtheis.yandtran.YandexTranslatorAPI;
import com.rmtheis.yandtran.detect.Detect;
import com.rmtheis.yandtran.language.Language;
import com.rmtheis.yandtran.translate.Translate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.Level;

public class ChatTranslator {
    protected static EntityPlayer player;
    protected static final String commandPrefix;
    public static Language translateChat;
    public static Language translateFrom;
    public static Language translateTo;
    public static String chatSeparator;
    public static boolean disableTranslation;
    public static String loggingLevel;
    public static String userKey;
    public static int msgColor;
    public static HashMap<Integer, EnumChatFormatting> chatFormat;
    public static boolean bold;
    public static boolean italic;
    public static boolean underline;
    public static String[] chatRegex;
    public static boolean translateSign;
    private static int msgCount;
    private static ChatTranslator translator;
    private static LinkedList<String> chatHistory;

    private Language detectLang(String message) {
        Language lang = null;
        try {
            lang = Detect.execute(message);
        }
        catch (Exception e) {
            Log.log(Level.ERROR, e.getMessage());
            this.ErrorHandling(e);
        }
        return lang;
    }

    public static String translate(String message, Language from, Language to) {
        String chatString = "";
        try {
            chatString = Translate.execute(message, from, to);
        }
        catch (Exception e) {
            Log.log(Level.ERROR, e.getMessage());
            translator.ErrorHandling(e);
        }
        return chatString;
    }

    private void translateChat(String chat, String sender) {
        ChatTranslator translator = new ChatTranslator();
        Language lang = translator.detectLang(chat);
        if (lang != translateChat && lang != null) {
            String translatedMessage = ChatTranslator.translate(chat, lang, translateChat);
            String langName = Reference.LanguageMap.capitalize(Reference.LanguageMap.getLangString(lang));
            boolean filter = ChatTranslator.filterChat(translatedMessage, chat);
            if (loggingLevel.equals("debug")) {
                Log.log(Level.INFO, String.format("Language: %s  Selected language: %s", new Object[]{lang, translateChat}));
                Log.log(Level.INFO, "\" " + chat + " \"");
                Log.log(Level.INFO, "\" " + translatedMessage + " \"");
                Log.log(Level.INFO, "Is translated? :" + Boolean.toString(filter));
            }
            if (filter) {
                ChatTranslator.sendChatMessage("Translated(" + langName + "): " + translatedMessage, chatFormat.get(msgColor), bold, italic, underline, EnumChatFormatting.GOLD + "Message sender: " + sender);
            }
        }
    }

    public static boolean filterChat(String translated, String original) {
        return !original.trim().equalsIgnoreCase(translated.trim());
    }

    private void ErrorHandling(Exception exception) {
        String errorMessage = exception.getMessage();
        int responseCode = 0;
        if (exception instanceof IOException) {
            if (YandexTranslatorAPI.getResponseCode() == 200) {
                return;
            }
            responseCode = YandexTranslatorAPI.getResponseCode();
            Log.log(Level.ERROR, "Error during translation with HTTP response code " + responseCode);
        } else if (exception instanceof RuntimeException) {
            if (errorMessage.equals("INVALID_API_KEY - Please set the API Key with your Yandex API Key")) {
                responseCode = -402;
                Log.log(Level.ERROR, "[Translation Wrapper] Invalid API key. This is not supposed to happen!");
            } else if (errorMessage.equals("[yandex-translator-api] Error reading translation stream.")) {
                responseCode = -403;
                Log.log(Level.ERROR, "[Translation Wrapper] Errro reading translation stream");
            } else {
                responseCode = -404;
                Log.log(Level.ERROR, "[Translation Wrapper] Cause unknown!");
            }
        } else {
            exception.printStackTrace();
            responseCode = -404;
            Log.log(Level.ERROR, "Unknown error during translation!");
        }
        ChatTranslator translator = new ChatTranslator();
        int[] normalLog = new int[]{400, 401, 402, 403, 404, 422, 500, 503, -402};
        if (!loggingLevel.equals("off")) {
            if (loggingLevel.equals("debug")) {
                ChatTranslator.sendChatMessage("Error " + responseCode + " from translation server", true, EnumChatFormatting.RED);
                if (responseCode <= 0) {
                    ChatTranslator.sendChatMessage("Internal error caught. Please report to mod creator", true, EnumChatFormatting.RED);
                }
            } else {
                for (int i = 0; i < normalLog.length; ++i) {
                    if (normalLog[i] != responseCode) continue;
                    ChatTranslator.sendChatMessage("Error " + responseCode + " from translation server", true, EnumChatFormatting.RED);
                    if (responseCode > 0) continue;
                    ChatTranslator.sendChatMessage("Internal error caught. Please report to mod creator", true, EnumChatFormatting.RED);
                }
            }
        }
        if (!loggingLevel.equals("off")) {
            switch (responseCode) {
                case 400: {
                    ChatTranslator.sendChatMessage("Description: Bad request. Most likely this language translation is not available temporailty.", false, EnumChatFormatting.RED);
                    break;
                }
                case 401: {
                    ChatTranslator.sendChatMessage("Description: Translation API key expired. Please notify the mod creator to update it.", false, EnumChatFormatting.RED);
                    break;
                }
                case 402: {
                    ChatTranslator.sendChatMessage("Description: Translation API key has been blocked. Please notify the mod creator to update it", false, EnumChatFormatting.RED);
                    break;
                }
                case 403: {
                    ChatTranslator.sendChatMessage("Description: The mod has exceeded the daily limit of translation requests", false, EnumChatFormatting.RED);
                    break;
                }
                case 404: {
                    ChatTranslator.sendChatMessage("Description: The mod has exceeded the daily limit of translation text", false, EnumChatFormatting.RED);
                    break;
                }
                case 408: {
                    if (loggingLevel != "debug") break;
                    ChatTranslator.sendChatMessage("Description: Request timeout", false, EnumChatFormatting.RED);
                    break;
                }
                case 422: {
                    ChatTranslator.sendChatMessage("Description: The text cannot be translated", false, EnumChatFormatting.RED);
                }
                case 500: {
                    ChatTranslator.sendChatMessage("Description: Internal server error. Translation servers are currently offline.", false, EnumChatFormatting.RED);
                    ChatTranslator.sendChatMessage("If this message is popping up continuously, disable the mod through the settings", false, EnumChatFormatting.RED);
                    break;
                }
                case 503: {
                    ChatTranslator.sendChatMessage("Description: Translation server is currently overloaded or down for maintainence", false, EnumChatFormatting.RED);
                    ChatTranslator.sendChatMessage("If this message is popping up continuously, disable the mod through the settings", false, EnumChatFormatting.RED);
                    break;
                }
                case -402: {
                    ChatTranslator.sendChatMessage("Description: Invalid translation key. This is not supposed to happen!", false, EnumChatFormatting.RED);
                    break;
                }
                case -403: {
                    if (loggingLevel != "debug") break;
                    ChatTranslator.sendChatMessage("Description: Error during reading translation stream", false, EnumChatFormatting.RED);
                    break;
                }
                default: {
                    Log.log(Level.ERROR, "Unknown error. Error code: " + responseCode);
                    if (loggingLevel != "debug") break;
                    ChatTranslator.sendChatMessage("Description: Unknown error recevied from servers", false, EnumChatFormatting.RED);
                }
            }
        }
        if (responseCode == 403 || responseCode == 404 || responseCode == -402) {
            ChatTranslator.sendChatMessage("Switching translation key...", true, EnumChatFormatting.RESET);
            translator.changeKey();
        }
    }

    private final void changeKey() {
        Log.log(Level.INFO, "Changing translation key");
        if (Main.setTranslateKey()) {
            ChatTranslator.sendChatMessage("Translation key successfully changed", true, EnumChatFormatting.RESET);
        } else {
            Log.log(Level.ERROR, "Failed changing translation key");
            ChatTranslator.sendChatMessage("All translation keys have exceeded the daily limit. The mod cannot translate your Minecraft chat until the next day/month. Sorry for the inconvenience", true, EnumChatFormatting.RED);
            disableTranslation = true;
        }
    }

    public static void sendChatMessage(IChatComponent message) {
        player.func_145747_a(message);
    }

    public static void sendChatMessage(String message, boolean addPrefix, EnumChatFormatting color) {
        if (addPrefix) {
            player.func_145747_a((IChatComponent)new ChatComponentText(commandPrefix + color + message.replace(" ", " " + color)));
        } else {
            player.func_145747_a(new ChatComponentText(message).func_150255_a(new ChatStyle().func_150238_a(color)));
        }
    }

    public static void sendChatMessage(String message, EnumChatFormatting color, boolean bold, boolean italic, boolean underline, String hoverText) {
        player.func_145747_a(new ChatComponentText(message).func_150255_a(new ChatStyle().func_150238_a(color).func_150227_a(Boolean.valueOf(bold)).func_150217_b(Boolean.valueOf(italic)).func_150228_d(Boolean.valueOf(underline)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(hoverText)))));
    }

    public static LinkedList<String> getChatHistory() {
        return chatHistory;
    }

    static {
        commandPrefix = EnumChatFormatting.GREEN + "[" + EnumChatFormatting.RESET + "TranslateMod" + EnumChatFormatting.GREEN + "] ";
        translateChat = Language.ENGLISH;
        translateFrom = Language.ENGLISH;
        translateTo = Language.ENGLISH;
        disableTranslation = false;
        userKey = "";
        msgColor = 7;
        chatFormat = new HashMap();
        chatRegex = Reference.defaultConfig.chatRegex;
        translator = new ChatTranslator();
        chatHistory = new LinkedList();
    }

    public static class translateMe
    extends Thread {
        private String playerMessage;
        private String prefix;

        public translateMe(String prefix, String playerMessage) {
            this.playerMessage = playerMessage;
            this.prefix = prefix;
        }

        @Override
        public void run() {
            String translated = ChatTranslator.translate(this.playerMessage, translateFrom, translateTo);
            if (translated != "") {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(this.prefix.concat(" " + translated));
            }
        }
    }

    static class chatHandler
    extends Thread {
        private String message;

        public chatHandler(String message) {
            this.message = message;
        }

        private String getSender(String messagefinal, int regexIndex) {
            String sender;
            try {
                String regex = "^" + chatRegex[regexIndex].replace("%name%", "\\w+");
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(messagefinal);
                matcher.find();
                sender = matcher.group();
                String[] separator = chatRegex[regexIndex].split("%name%");
                for (int i = 0; i < separator.length; ++i) {
                    sender = sender.replaceAll(separator[i], "");
                }
            }
            catch (IllegalStateException | PatternSyntaxException e) {
                sender = EnumChatFormatting.RED + "(Regex error. Sender name cannot be shown)";
                Log.log(Level.ERROR, "Regex error. Sender name cannot be aquired.");
            }
            return sender;
        }

        private void resetRegex() {
            Reference.configGet.chatRegex.set(Reference.defaultConfig.chatRegex);
            Reference.config.save();
            Main.syncConfig();
        }

        @Override
        public void run() {
            int index = 0;
            ArrayList<String> messageTmp = new ArrayList<String>();
            ArrayList<Integer> indexTmp = new ArrayList<Integer>();
            if (this.message.trim().isEmpty() || disableTranslation) {
                return;
            }
            if (loggingLevel.equals("debug")) {
                Log.log(Level.INFO, "Message caught. Processed.");
            }
            for (int i = 0; i < chatRegex.length; ++i) {
                String regex = chatRegex[i].replace("%name%", "\\w+");
                Pattern pattern = Pattern.compile("^" + regex);
                Matcher match = pattern.matcher(this.message);
                if (!match.find()) continue;
                messageTmp.add(this.message.replaceFirst("^" + regex, ""));
                indexTmp.add(i);
                if (loggingLevel.equals("debug")) {
                    Log.log(Level.INFO, "Detected regex: " + regex);
                }
                if (chatRegex[i].contains("%name%")) continue;
                Log.log(Level.INFO, "Regex configuration needed to be updated.");
                ChatTranslator.sendChatMessage("Regex configuration needed to be updated. Resetting all chat regexes to default", true, EnumChatFormatting.RED);
                this.resetRegex();
                return;
            }
            if (messageTmp.isEmpty()) {
                return;
            }
            int charCount = Integer.MAX_VALUE;
            for (int i = 0; i < messageTmp.size(); ++i) {
                if (((String)messageTmp.get(i)).length() >= charCount) continue;
                charCount = ((String)messageTmp.get(i)).length();
                index = i;
                if (!loggingLevel.equals("debug")) continue;
                Log.log(Level.INFO, "Filtering results: \"" + (String)messageTmp.get(i) + "\"");
            }
            String messagefinal = (String)messageTmp.get(index);
            int regexIndex = (Integer)indexTmp.get(index);
            msgCount++;
            if (msgCount >= 10) {
                msgCount = 10;
                chatHistory.pollFirst();
            }
            if (loggingLevel.equals("debug")) {
                Log.log(Level.INFO, "Regex matched: " + messageTmp.size());
                Log.log(Level.INFO, "Final message chosen: " + messagefinal);
            }
            chatHistory.add(messagefinal);
            translator.translateChat(messagefinal, this.getSender(this.message, regexIndex));
        }
    }

    static class signHandler
    extends Thread {
        private String text;
        private String sender;

        public signHandler(String text, String sender) {
            this.text = text;
            this.sender = sender;
        }

        @Override
        public void run() {
            translator.translateChat(this.text, this.sender);
        }
    }
}

