/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translate;

import com.ringosham.gui.AddKeyGui;
import com.ringosham.gui.TranslateGui;
import com.ringosham.translate.ChatTranslator;
import com.ringosham.translate.KeyBind;
import com.ringosham.translate.Log;
import com.ringosham.translate.Main;
import com.ringosham.translate.Reference;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;

public class ModEventHandler {
    private boolean creditShown = false;
    private boolean resetKey = false;
    private static Thread readSign;
    private static boolean translatingSign;

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui == null) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
        if (event.gui instanceof AddKeyGui) {
            this.resetKey = true;
        }
    }

    @SubscribeEvent
    public void chatReceived(ClientChatReceivedEvent event) {
        IChatComponent eventMessage = event.message;
        String message = eventMessage.func_150260_c().replaceAll("\u00ef\u00bf\u00bd(.)", "");
        if (ChatTranslator.disableTranslation || Main.modDisable) {
            return;
        }
        ChatTranslator.chatHandler translate = new ChatTranslator.chatHandler(message);
        translate.start();
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        ChatTranslator.player = event.player;
        if (!this.creditShown) {
            this.creditShown = true;
            if (ChatTranslator.disableTranslation) {
                ChatTranslator.sendChatMessage("Error caught during setting up translation services. Mod disabled until game restarts", true, EnumChatFormatting.RED);
                ChatTranslator.sendChatMessage("You can go to the mod settings -> User key. You can add your own translation key there.", false, EnumChatFormatting.RED);
            }
            ChatTranslator.sendChatMessage("Press [" + EnumChatFormatting.AQUA + Keyboard.getKeyName((int)KeyBind.translateKey.func_151463_i()) + EnumChatFormatting.WHITE + "] for translation settings", true, EnumChatFormatting.WHITE);
            if (ChatTranslator.chatRegex.length == 0) {
                Log.log(Level.WARN, "No chat regex in the configurations");
                ChatTranslator.sendChatMessage("The mod needs chat regex to function. Check the mod options to add one", true, EnumChatFormatting.RED);
            }
        }
        if (!(Minecraft.func_71410_x().field_71462_r instanceof AddKeyGui) && this.resetKey) {
            Main.setTranslateKey();
            this.resetKey = false;
        }
        if (ChatTranslator.translateSign) {
            Minecraft mc = Minecraft.func_71410_x();
            MovingObjectPosition mouseOver = Minecraft.func_71410_x().field_71476_x;
            if (mouseOver == null) {
                return;
            }
            if (mouseOver.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                translatingSign = false;
                if (readSign != null) {
                    readSign.interrupt();
                }
                return;
            }
            BlockPos block = mouseOver.func_178782_a();
            if (!(mc.field_71441_e.func_180495_p(block).func_177230_c() != Block.func_149729_e((int)63) && mc.field_71441_e.func_180495_p(block).func_177230_c() != Block.func_149729_e((int)68) || translatingSign)) {
                String text = "";
                for (int i = 0; i < 4; ++i) {
                    IChatComponent line = ((TileEntitySign)mc.field_71441_e.func_175625_s((BlockPos)block)).field_145915_a[i];
                    text = text + " " + line.func_150260_c();
                }
                text.replaceAll("\u00ef\u00bf\u00bd(.)", "");
                if (text.isEmpty()) {
                    return;
                }
                readSign = new ReadSign(text, block.func_177958_n(), block.func_177956_o(), block.func_177952_p());
                translatingSign = true;
                if (!readSign.isAlive()) {
                    readSign.start();
                }
                return;
            }
            if (mc.field_71441_e.func_180495_p(block).func_177230_c() == Block.func_149729_e((int)63) || mc.field_71441_e.func_180495_p(block).func_177230_c() == Block.func_149729_e((int)68)) {
                return;
            }
            if (mc.field_71441_e.func_180495_p(block).func_177230_c() != Block.func_149729_e((int)63) && mc.field_71441_e.func_180495_p(block).func_177230_c() != Block.func_149729_e((int)68) && readSign != null) {
                translatingSign = false;
                readSign.interrupt();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        Reference.config.save();
        Main.syncConfig();
    }

    @SubscribeEvent
    public void onKeybind(InputEvent.KeyInputEvent event) {
        if (KeyBind.translateKey.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new TranslateGui());
        }
    }

    static {
        translatingSign = false;
    }

    private static class ReadSign
    extends Thread {
        private String text;
        private static int x;
        private static int y;
        private static int z;

        public ReadSign(String text, int x, int y, int z) {
            this.text = text;
            if (ReadSign.x == x && ReadSign.y == y && ReadSign.z == z) {
                return;
            }
            ReadSign.x = x;
            ReadSign.y = y;
            ReadSign.z = z;
        }

        @Override
        public void run() {
            try {
                if (ChatTranslator.loggingLevel.equals("debug")) {
                    Log.log(Level.INFO, "Sign detected. Translating");
                }
                Thread.sleep(1000L);
                ChatTranslator.signHandler translate = new ChatTranslator.signHandler(this.text, String.format("(Sign at: %1$d, %2$d, %3$d)", x, y, z));
                translate.start();
            }
            catch (InterruptedException e) {
                if (ChatTranslator.loggingLevel.equals("debug")) {
                    Log.log(Level.INFO, "Translation interrupted");
                }
                translatingSign = false;
            }
        }
    }
}

