/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translate;

import com.ringosham.proxy.CommonProxy;
import com.ringosham.translate.ChatTranslator;
import com.ringosham.translate.KeyBind;
import com.ringosham.translate.Log;
import com.ringosham.translate.ModEventHandler;
import com.ringosham.translate.Reference;
import com.rmtheis.yandtran.detect.Detect;
import com.rmtheis.yandtran.translate.Translate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

@Mod(modid="TranslateMod", name="Real-time translation mod", version="4.1", acceptedMinecraftVersions="[1.9.4]")
public class Main {
    ModEventHandler handler = new ModEventHandler();
    @SidedProxy(clientSide="com.ringosham.proxy.ClientProxy", serverSide="com.ringosham.proxy.CommonProxy")
    protected static CommonProxy proxy;
    private static List<String> key;
    public static boolean modDisable;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        Reference.LanguageMap.init();
        Reference.config = new Configuration(e.getSuggestedConfigurationFile());
        Reference.config.load();
        Main.syncConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        KeyBind.keyInit();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this.handler);
        Log.log(Level.INFO, "Event handler initialized");
        this.setColor();
        this.setKeyList();
        Log.log(Level.INFO, "Translation keys loaded");
        if (Main.setTranslateKey()) {
            Log.log(Level.INFO, "Translation key set");
        } else {
            Log.log(Level.FATAL, "Network error / Translation keys reached max limit");
            ChatTranslator.disableTranslation = true;
            modDisable = true;
        }
    }

    private void setColor() {
        int i = 0;
        for (TextFormatting format : TextFormatting.values()) {
            ChatTranslator.chatFormat.put(i, format);
            if (++i == 16) break;
        }
    }

    public static final boolean setTranslateKey() {
        if (ChatTranslator.userKey != "") {
            try {
                Translate.setKey(Reference.configGet.userKey.getString());
                Detect.execute("The quick brown fox jumps over the lazy dog.");
                return true;
            }
            catch (Exception e) {
                if (e.getMessage().equals("translate.yandex.net")) {
                    Log.log(Level.ERROR, "[User key] Connection problem");
                }
                if (e.getMessage().length() < 40) {
                    Log.log(Level.ERROR, "[User key]" + e.getMessage());
                }
                Log.log(Level.ERROR, "[User key]" + e.getMessage().substring(0, 40));
            }
        }
        for (int i = 0; i < key.size(); ++i) {
            try {
                Translate.setKey(key.get(i));
                Detect.execute("The quick brown fox jumps over the lazy dog.");
                break;
            }
            catch (Exception e) {
                if (e.getMessage().equals("translate.yandex.net")) {
                    Log.log(Level.ERROR, "[Key " + i + "] Connection problem");
                } else if (e.getMessage().length() < 40) {
                    Log.log(Level.ERROR, "[Key " + i + "]" + e.getMessage());
                } else {
                    Log.log(Level.ERROR, "[Key " + i + "]" + e.getMessage().substring(0, 40));
                }
                if (i != key.size() - 1) continue;
                return false;
            }
        }
        return true;
    }

    private final void setKeyList() {
        key.add("trnsl.1.1.20160711T032031Z.5f8b2b286554afef.da8c375f5fcbcf6339482430c746c7bd2d60407a");
        key.add("trnsl.1.1.20160711T032338Z.e076baaafd7f9316.05aac465e585571d617defbbc3df09b43dce2623");
        key.add("trnsl.1.1.20160711T032437Z.fdff8151cd40bb5f.2c5ee54984ee87623ff10a8b19da14b76fecde17");
        key.add("trnsl.1.1.20160711T032540Z.4574d45d84eb3bfd.4953ea90437282ec24b37ed35dc5d7e4a4d9d45c");
        key.add("trnsl.1.1.20160711T032633Z.20d1f8d87e8d1b57.efaac1695b6a6f918c318368b2d70e6b0e74bdd8");
        key.add("trnsl.1.1.20160711T032732Z.a6bbdff6c40818cd.bdbedc84081af44c1c04b40b4ba1f571726ae890");
        key.add("trnsl.1.1.20160711T032839Z.4dde862d9df32a76.b072fb67d659aa9dba5ed1acbe4a775e4bd8c7bf");
        key.add("trnsl.1.1.20160711T032945Z.2f5853853f873328.f1df636a6f2e8886970c11e2ce1d68ccee69d688");
        key.add("trnsl.1.1.20160711T033044Z.a53565c367e2ca3f.8a78115fe6e17672ede13a14eefb6042099045dd");
        key.add("trnsl.1.1.20160711T033141Z.a45452dd3cd38627.4c4b733b9fd1c7c8165bc2d1294ac56904b336cf");
        key.add("trnsl.1.1.20160711T033246Z.a2d08f5860b0253d.1f2e73c4a336033ba5cb7e1b9d3df44c9f01c792");
        key.add("trnsl.1.1.20160711T033419Z.b49ea1c72de42b8a.98527dd1b677b321831b660f2ee5ce5745e49636");
        key.add("trnsl.1.1.20160711T033513Z.0fbec1032f4b261a.c5249b0934f28d2c185119f60ac09fb3e676284e");
        key.add("trnsl.1.1.20160711T033611Z.4a4a6476d934e9e4.eb81f2379f43262c4245204c03d59e3b51466bda");
        key.add("trnsl.1.1.20160711T033706Z.e622764ba7a19755.6e55443c9bed72077c6148d7cd0e7ba9a0833cc1");
        key.add("trnsl.1.1.20160711T033804Z.172a4305452b2da5.2dfbd10d96097c8679de26a629f0287c4c66d88a");
        key.add("trnsl.1.1.20160711T033901Z.559ac883c450120c.beaa37b572dd9fa361edc230852c60c4f98c02bf");
        key.add("trnsl.1.1.20160711T033959Z.413675029d489301.77a39c4e9bcb9517116efcb98dfcc67373392a17");
    }

    public static final void syncConfig() {
        ChatTranslator.translateChat = Reference.LanguageMap.getLang(Reference.configGet.translateChat.getString());
        ChatTranslator.translateFrom = Reference.LanguageMap.getLang(Reference.configGet.translateFrom.getString());
        ChatTranslator.translateTo = Reference.LanguageMap.getLang(Reference.configGet.translateTo.getString());
        ChatTranslator.loggingLevel = Reference.configGet.loggingLevel.getString();
        ChatTranslator.userKey = Reference.configGet.userKey.getString();
        ChatTranslator.msgColor = Reference.configGet.msgColor.getInt();
        ChatTranslator.bold = Reference.configGet.msgBold.getBoolean();
        ChatTranslator.italic = Reference.configGet.msgItalic.getBoolean();
        ChatTranslator.underline = Reference.configGet.msgUnderline.getBoolean();
        ChatTranslator.chatRegex = Reference.configGet.chatRegex.getStringList();
        ChatTranslator.translateSign = Reference.configGet.translateSign.getBoolean();
        if (!(ChatTranslator.loggingLevel.equals("off") || ChatTranslator.loggingLevel.equals("normal") || ChatTranslator.loggingLevel.equals("debug"))) {
            Reference.configGet.loggingLevel.set("normal");
            Main.syncConfig();
        }
        if (ChatTranslator.translateChat == null) {
            Reference.configGet.translateChat.set("english");
            Main.syncConfig();
        }
        if (ChatTranslator.translateFrom == null) {
            Reference.configGet.translateFrom.set("english");
            Main.syncConfig();
        }
        if (ChatTranslator.translateTo == null) {
            Reference.configGet.translateTo.set("spanish");
            Main.syncConfig();
        }
        if (ChatTranslator.msgColor > 15 || ChatTranslator.msgColor < 0) {
            Reference.configGet.msgColor.set(7);
            Main.syncConfig();
        }
        Reference.config.save();
    }

    static {
        key = new ArrayList<String>();
        modDisable = false;
    }
}

