/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.respawnablepets;

import java.util.Objects;
import java.util.UUID;
import moriyashiine.respawnablepets.ExtendedWorld;
import moriyashiine.respawnablepets.RespawnablePets;
import moriyashiine.respawnablepets.Util;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ModEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void toggleRespawn(LivingAttackEvent event) {
        EntityPlayer player;
        Entity attacker;
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && !(entity instanceof EntityPlayer) && (attacker = event.getSource().func_76364_f()) instanceof EntityPlayer && (player = (EntityPlayer)attacker).func_184614_ca().func_77973_b() == RespawnablePets.Registry.etheric_gem) {
            event.setCanceled(true);
            UUID owner = Util.getOwner(entity);
            if (owner != null && owner.equals(player.func_110124_au())) {
                EntityEntry entry = EntityRegistry.getEntry(entity.getClass());
                if (entry != null) {
                    if (RespawnablePets.config.blacklist.contains(Objects.requireNonNull(entry.getRegistryName()).toString())) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("respawnablepets.blacklisted", new Object[]{entity.func_145748_c_()}), true);
                    } else if (Util.addPet(entity)) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("respawnablepets.enable_respawn", new Object[]{entity.func_145748_c_()}), true);
                    } else if (Util.removePet(entity)) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("respawnablepets.disable_respawn", new Object[]{entity.func_145748_c_()}), true);
                    }
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("respawnablepets.not_owner", new Object[]{entity.func_145748_c_()}), true);
            }
        }
    }

    @SubscribeEvent
    public void wakeUp(PlayerWakeUpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            ExtendedWorld ext = ExtendedWorld.get();
            for (int i = ext.pets.size() - 1; i >= 0; --i) {
                EntityLivingBase entity;
                NBTTagCompound tag = ext.pets.get(i);
                if (!tag.func_74779_i("OwnerUUID").equalsIgnoreCase(player.func_110124_au().toString()) || (entity = (EntityLivingBase)((EntityEntry)Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.func_74779_i("id"))))).newInstance(world)) == null) continue;
                entity.deserializeNBT(tag);
                BlockPos playerPos = player.func_180425_c();
                entity.func_70080_a((double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), (float)world.field_73012_v.nextInt(360), 0.0f);
                if (!world.func_72838_d((Entity)entity)) continue;
                entity.func_70691_i(Float.MAX_VALUE);
                entity.func_70066_B();
                entity.func_70674_bp();
            }
        }
    }

    @SubscribeEvent
    public void livingDamage(LivingDamageEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && !(entity instanceof EntityPlayer)) {
            ExtendedWorld ext = ExtendedWorld.get();
            UUID owner = Util.getOwner(entity);
            if (owner != null && entity.func_110143_aJ() - event.getAmount() <= 0.0f && ext.containsEntity(entity)) {
                EntityPlayer player;
                event.setCanceled(true);
                Util.removePet(entity);
                Util.addPet(entity);
                entity.func_70106_y();
                if (!entity.field_70128_L) {
                    entity.field_70128_L = true;
                }
                if (world.func_82736_K().func_82766_b("showDeathMessages") && (player = Util.findPlayer(owner)) != null) {
                    player.func_145747_a(entity.func_110142_aN().func_151521_b());
                }
            }
        }
    }
}

